/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.Stats;
import java.util.ArrayList;

public class BinomialDist {
    private int noOfSamples;
    private double prob;
    private int[] C = null;

    public BinomialDist(int noOfSamples, double prob) {
        if (noOfSamples < 0) {
            System.err.println("Error in BinomialDist.class: The number of samples must be non-negative.");
        }
        this.noOfSamples = noOfSamples;
        if (prob < 0.0 || prob > 1.0) {
            System.err.println("Error in BinomialDist.class: The probability must be in [0, 1].");
        } else {
            this.prob = prob;
        }
    }

    public int getNoOfSamples() {
        return this.noOfSamples;
    }

    public double getProb() {
        return this.prob;
    }

    public double getMean() {
        return (double)this.noOfSamples * this.prob;
    }

    public double getVariance() {
        return (double)this.noOfSamples * this.prob * (1.0 - this.prob);
    }

    public double getStdDev() {
        return Math.sqrt((double)this.noOfSamples * this.prob * (1.0 - this.prob));
    }

    public double getStdScore(double rawScore) {
        return (double)this.noOfSamples * (rawScore - this.prob) / this.getStdDev();
    }

    public double upperBoundNormal95() {
        return Stats.upperBoundNormal95(this.getMean(), this.getVariance()) / (double)this.noOfSamples;
    }

    public double upperBoundNormal95Upper() {
        return Stats.upperBoundNormal95Upper(this.getMean(), this.getVariance()) / (double)this.noOfSamples;
    }

    public double lowerBoundNormal95() {
        return Stats.lowerBoundNormal95(this.getMean(), this.getVariance()) / (double)this.noOfSamples;
    }

    public double lowerBoundNormal95Lower() {
        return Stats.lowerBoundNormal95Lower(this.getMean(), this.getVariance()) / (double)this.noOfSamples;
    }

    public static double erf(double z, double accuracy) {
        double product;
        double sum = 0.0;
        double prev = 0.0;
        int n = 0;
        do {
            product = 1.0;
            int k = 1;
            while (k <= n) {
                product *= -z * z / (double)k;
                ++k;
            }
        } while (Math.abs((prev = sum) - (sum += z / (double)(2 * ++n + 1) * product)) > accuracy);
        double val = sum * 2.0 / Math.sqrt(Math.PI);
        return val;
    }

    public static double erfInv(double v, double accuracy) {
        double sum = 0.0;
        double prev = 0.0;
        int k = 0;
        if (v < -1.0 - accuracy || v > 1.0 + accuracy) {
            System.out.println("Error: The first argument of erfInv must be in (-1, 1).");
            System.exit(1);
        }
        ArrayList<Double> c = new ArrayList<Double>();
        do {
            prev = sum;
            c.add(0.0);
            if (k == 0) {
                c.set(k, 1.0);
                continue;
            }
            double val = 0.0;
            int m = 0;
            while (m < k) {
                double ck1m;
                double cm = (Double)c.get(m);
                if (Double.isInfinite(val += cm * (ck1m = ((Double)c.get(k - 1 - m)).doubleValue()) / (double)((m + 1) * (2 * m + 1)))) {
                    return prev;
                }
                ++m;
            }
            c.set(k, val);
        } while (Math.abs(prev - (sum += (Double)c.get(++k) / (double)(2 * k + 1) * Math.pow(Math.sqrt(Math.PI) * v / 2.0, 2 * k + 1))) > accuracy);
        return sum;
    }

    public double WilsonIntervalUpper(double confidenceLevel, double accuracy) {
        double z = BinomialDist.erfInv(confidenceLevel, accuracy) * Math.sqrt(2.0);
        double zzn = z * z / (double)this.noOfSamples;
        double error = z * Math.sqrt(this.prob * (1.0 - this.prob) / (double)this.noOfSamples + z * z / (double)(4 * this.noOfSamples * this.noOfSamples));
        double numerator = this.prob + zzn / 2.0 + error;
        double denominator = 1.0 + zzn;
        return numerator / denominator;
    }

    public double WilsonIntervalLower(double confidenceLevel, double accuracy) {
        double z = BinomialDist.erfInv(confidenceLevel, accuracy) * Math.sqrt(2.0);
        double zzn = z * z / (double)this.noOfSamples;
        double error = z * Math.sqrt(this.prob * (1.0 - this.prob) / (double)this.noOfSamples + z * z / (double)(4 * this.noOfSamples * this.noOfSamples));
        double numerator = this.prob + zzn / 2.0 - error;
        double denominator = 1.0 + zzn;
        return numerator / denominator;
    }

    public double populationBelowNormal(double upperBound) {
        double stdScore = this.getStdScore(upperBound);
        double accuracy = 1.0E-12;
        double populationRange = 0.5;
        populationRange = Math.abs(stdScore) > 6.0 ? 1.0 : BinomialDist.erf(Math.abs(stdScore) / Math.sqrt(2.0), accuracy);
        if (stdScore > 0.0) {
            return 0.5 + populationRange / 2.0;
        }
        return 0.5 - populationRange / 2.0;
    }

    public double populationBelow(double upperBound) {
        double searchMid;
        double prev;
        double accuracy = 1.0E-12;
        double upperBoundNew = 0.0;
        double searchMin = 0.0;
        double searchMax = 1.0;
        do {
            prev = upperBoundNew;
            searchMid = (searchMin + searchMax) / 2.0;
            upperBoundNew = this.WilsonIntervalLower(1.0 - searchMid * 2.0, 1.0E-12);
            if (upperBoundNew > upperBound) {
                searchMax = searchMid;
                continue;
            }
            searchMin = searchMid;
        } while (Math.abs(upperBoundNew - prev) > accuracy);
        return searchMid;
    }

    public double populationAbove(double lowerBound) {
        double stdScore = this.getStdScore(lowerBound);
        double accuracy = 1.0E-9;
        double populationRange = 0.5;
        populationRange = Math.abs(stdScore) > 6.0 ? 1.0 : BinomialDist.erf(Math.abs(stdScore) / Math.sqrt(2.0), accuracy);
        if (stdScore > 0.0) {
            return 0.5 - populationRange / 2.0;
        }
        return 0.5 + populationRange / 2.0;
    }

    public double PMF(int k) {
        int kCn = this.getBinomialCoefficient(k);
        return (double)kCn * Math.pow(this.prob, k) * Math.pow(1.0 - this.prob, this.noOfSamples - k);
    }

    public int getBinomialCoefficient(int k) {
        if (this.noOfSamples < 0) {
            System.err.println("Error: Cannot calculate a binomial coefficient when the number of samples is negative.");
            System.exit(1);
        } else if (this.C == null) {
            this.calcBinomialCoefficients(this.noOfSamples);
        }
        int size = this.noOfSamples / 2 + 1;
        if (k >= size) {
            k = this.noOfSamples - k;
        }
        if (k >= 0 && k <= this.noOfSamples) {
            return this.C[k];
        }
        return -1;
    }

    private void calcBinomialCoefficients(int n) {
        int size = n / 2 + 1;
        this.C = new int[size];
        this.C[0] = 1;
        int i = 1;
        while (i < n) {
            if (i < size) {
                this.C[i] = 1;
            }
            int j = Math.min(size - 1, i);
            while (j > 0) {
                int n2 = j;
                this.C[n2] = this.C[n2] + this.C[j - 1];
                --j;
            }
            ++i;
        }
    }
}

