/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.ProbDist;
import bham.leakiest.Stats;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.comparator.ComparatorStringWithInt;
import bham.leakiest.comparator.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Channel {
    String[] outputNames;
    private ArrayList<Pair<String, Integer>> outputNamesSorted = new ArrayList();
    String[] inputNames;
    double[][] channelMatrix_W;
    double[][] channelMatrix_W_Sorted;
    Vector[] inputsPerRow;
    String[] groupNames;
    Vector[] groupsPerRow;
    int[] groupForRow;
    Vector[] rowsForGroup;
    int kind;
    private boolean sortOutputsDouble = true;
    private boolean sortOutputsDoubleDone = false;
    private static boolean readFromChanFile = TestInfoLeak.readFromChanFile;
    private static int verbose = TestInfoLeak.verbose;
    static final int BASIC = 1;
    static final int MULTI = 2;
    static final int COND = 3;

    public Channel() {
    }

    public Channel(int kind, String[] inputNames, String[] outputNames, double[][] matrix) {
        this.kind = kind;
        this.inputNames = inputNames;
        this.outputNames = outputNames;
        this.channelMatrix_W = matrix;
    }

    public Channel(String[] inputNames, String[] outputNames, double[][] matrix) {
        this.kind = 1;
        this.inputNames = inputNames;
        this.outputNames = outputNames;
        this.channelMatrix_W = matrix;
    }

    public String[] getOutputNames() {
        return this.outputNames;
    }

    public String[] getInputNames() {
        return this.inputNames;
    }

    public double[][] getMatrix() {
        return this.channelMatrix_W;
    }

    public int noOfInputs() {
        return this.inputNames.length;
    }

    public int noOfOutputs() {
        return this.outputNames.length;
    }

    public void setOutputNames(String[] arg) {
        this.outputNames = arg;
    }

    public void setInputNames(String[] arg) {
        this.inputNames = arg;
    }

    public void setGroupNames(String[] arg) {
        this.groupNames = arg;
    }

    public void setMatrix(double[][] arg) {
        this.channelMatrix_W = arg;
    }

    public void setInputsPerRow(Vector[] arg) {
        this.inputsPerRow = arg;
    }

    public void setGroupForRow(int[] arg) {
        this.groupForRow = arg;
    }

    public void setRowsForGroup(Vector[] arg) {
        this.rowsForGroup = arg;
    }

    private String getRowLabel(int rowNo) {
        switch (this.kind) {
            case 1: {
                return this.inputNames[rowNo];
            }
            case 3: {
                return String.valueOf(this.inputNames[rowNo]) + ":" + this.groupNames[this.groupForRow[rowNo]];
            }
        }
        if (this.kind == 1 || this.kind == 3) {
            return this.inputNames[rowNo];
        }
        String result = "";
        if (this.inputsPerRow[rowNo].size() > 0) {
            result = this.inputNames[(Integer)this.inputsPerRow[rowNo].get(0)];
            int i = 1;
            while (i < this.inputsPerRow[rowNo].size()) {
                result = String.valueOf(result) + ", " + this.inputNames[(Integer)this.inputsPerRow[rowNo].get(i)];
                ++i;
            }
        }
        return result;
    }

    public boolean isWellFormed(double accuracy) {
        if (this.inputNames.length != this.channelMatrix_W.length) {
            System.out.println("Caution: inputNames.length = " + this.inputNames.length + " channelMatrix_W.length = " + this.channelMatrix_W.length);
            return false;
        }
        if (this.outputNames.length != this.channelMatrix_W[0].length) {
            System.out.println("Caution: outputNames.length = " + this.outputNames.length + " channelMatrix_W[0].length = " + this.channelMatrix_W[0].length);
            return false;
        }
        int row = 0;
        while (row < this.inputNames.length) {
            double sum = 0.0;
            int col = 0;
            while (col < this.outputNames.length) {
                sum += this.channelMatrix_W[row][col];
                ++col;
            }
            if (sum < 1.0 - accuracy || sum > 1.0 + accuracy) {
                System.out.println("Caution: The summation of the row " + row + " = " + sum);
                return false;
            }
            ++row;
        }
        return true;
    }

    public Channel getJointDist(ProbDist prior) {
        double[] pmf = prior.probDistToPMFArray(this.getInputNames());
        double[][] chMatrix = this.getMatrix();
        int numRows = this.noOfInputs();
        int numCols = this.noOfOutputs();
        double[][] jointMatrix = new double[numRows][numCols];
        int row = 0;
        while (row < numRows) {
            int col = 0;
            while (col < numCols) {
                jointMatrix[row][col] = pmf[row] * chMatrix[row][col];
                ++col;
            }
            ++row;
        }
        Channel jointCh = new Channel(this.getInputNames(), this.getOutputNames(), jointMatrix);
        return jointCh;
    }

    public static Channel getJointDist(ProbDist prior, Channel channel) {
        double[] pmf = prior.probDistToPMFArray(channel.getInputNames());
        double[][] chMatrix = channel.getMatrix();
        int numRows = channel.noOfInputs();
        int numCols = channel.noOfOutputs();
        double[][] jointMatrix = new double[numRows][numCols];
        int row = 0;
        while (row < numRows) {
            int col = 0;
            while (col < numCols) {
                jointMatrix[row][col] = pmf[row] * chMatrix[row][col];
                ++col;
            }
            ++row;
        }
        Channel jointCh = new Channel(channel.getInputNames(), channel.getOutputNames(), jointMatrix);
        return jointCh;
    }

    public ProbDist getPosteriorProbDist(ProbDist prior) {
        String[] inputNames = this.getInputNames();
        String[] outputNames = this.getOutputNames();
        double[][] matrix = this.getMatrix();
        double[] priorPMF = prior.probDistToPMFArray(inputNames);
        if (priorPMF.length != matrix.length) {
            System.out.println("  The number of prior          = " + priorPMF.length);
            System.out.println("  The number of rows of matrix = " + matrix.length);
            System.exit(1);
        }
        int numRows = priorPMF.length;
        int numCols = matrix[0].length;
        double[] postPMF = new double[numCols];
        int col = 0;
        while (col < numCols) {
            postPMF[col] = 0.0;
            int row = 0;
            while (row < numRows) {
                int n = col;
                postPMF[n] = postPMF[n] + priorPMF[row] * matrix[row][col];
                ++row;
            }
            ++col;
        }
        ProbDist post = new ProbDist(outputNames, postPMF);
        return post;
    }

    public static Channel parallelComposition(Channel[] channels) {
        return Channel.parallelComposition(channels, false, false);
    }

    public static Channel parallelComposition(Channel[] channels, boolean removeBrackets1, boolean removeBrackets2) {
        int i;
        if (channels == null || channels.length <= 1) {
            System.out.println("Error in the channels.");
            System.out.println("  Incorrect channels are specified.");
            System.exit(1);
        }
        int numChannels = channels.length;
        int numRows = 1;
        int numCols = 1;
        int num = 0;
        while (num < numChannels) {
            numRows *= channels[num].noOfInputs();
            numCols *= channels[num].noOfOutputs();
            ++num;
        }
        int tmpMatrixNumRows = numRows / channels[numChannels - 1].noOfInputs();
        int tmpMatrixNumCols = numCols / channels[numChannels - 1].noOfOutputs();
        double[][] tmpMatrix = new double[tmpMatrixNumRows][tmpMatrixNumCols];
        int i2 = 0;
        while (i2 < channels[0].noOfInputs()) {
            int j = 0;
            while (j < channels[0].noOfOutputs()) {
                tmpMatrix[i2][j] = channels[0].getMatrix()[i2][j];
                ++j;
            }
            ++i2;
        }
        double[][] matrix = new double[numRows][numCols];
        int tmpNumRows = channels[0].noOfInputs();
        int tmpNumCols = channels[0].noOfOutputs();
        int num2 = 0;
        while (num2 < numChannels - 1) {
            double[][] matrix2 = channels[num2 + 1].getMatrix();
            matrix = Channel.parallelComposition(tmpMatrix, matrix2, tmpNumRows, tmpNumCols, matrix2.length, matrix2[0].length);
            if (num2 < numChannels - 2) {
                i = 0;
                while (i < tmpNumRows * matrix2.length) {
                    int j = 0;
                    while (j < tmpNumCols * matrix2[0].length) {
                        tmpMatrix[i][j] = matrix[i][j];
                        ++j;
                    }
                    ++i;
                }
            }
            tmpNumRows *= channels[num2].noOfInputs();
            tmpNumCols *= channels[num2].noOfOutputs();
            ++num2;
        }
        if (verbose >= 5) {
            System.out.println("--------------------");
        }
        String[] composedInputNames = new String[numRows];
        int i3 = 0;
        while (i3 < channels[0].noOfInputs()) {
            composedInputNames[i3] = channels[0].getInputNames()[i3];
            ++i3;
        }
        tmpNumRows = 1;
        int num3 = 0;
        while (num3 < numChannels - 1) {
            composedInputNames = Channel.parallelComposition(composedInputNames, channels[num3 + 1].getInputNames(), tmpNumRows *= channels[num3].noOfInputs(), channels[num3 + 1].noOfInputs(), numRows, removeBrackets1, "");
            ++num3;
        }
        i3 = 0;
        while (i3 < composedInputNames.length) {
            composedInputNames[i3] = "(" + composedInputNames[i3] + ")";
            ++i3;
        }
        String[] composedOutputNames = new String[numRows];
        int j = 0;
        while (j < channels[0].noOfOutputs()) {
            composedOutputNames[j] = channels[0].getOutputNames()[j];
            ++j;
        }
        tmpNumCols = 1;
        int num4 = 0;
        while (num4 < numChannels - 1) {
            composedOutputNames = Channel.parallelComposition(composedOutputNames, channels[num4 + 1].getOutputNames(), tmpNumCols *= channels[num4].noOfOutputs(), channels[num4 + 1].noOfOutputs(), numCols, removeBrackets2, "");
            ++num4;
        }
        i = 0;
        while (i < composedOutputNames.length) {
            composedOutputNames[i] = "(" + composedOutputNames[i] + ")";
            ++i;
        }
        Channel ch = new Channel(1, composedInputNames, composedOutputNames, matrix);
        return ch;
    }

    private static double[][] parallelComposition(double[][] matrix1, double[][] matrix2, int matrix1noOfInputs, int matrix1noOfOutputs, int matrix2noOfInputs, int matrix2noOfOutputs) {
        if (matrix1noOfInputs > matrix1.length || matrix1noOfOutputs > matrix1[0].length || matrix2noOfInputs > matrix2.length || matrix2noOfOutputs > matrix2[0].length) {
            System.out.println("Error in the sizes of matrices.");
            System.out.println("  The actual size of matrix1 =    (" + matrix1[0].length + ", " + matrix1.length + ")");
            System.out.println("  The actual size of matrix2 =    (" + matrix2[0].length + ", " + matrix2.length + ")");
            System.out.println("  The specified size of matrix1 = (" + matrix1noOfInputs + ", " + matrix1noOfOutputs + ")");
            System.out.println("  The specified size of matrix2 = (" + matrix2noOfInputs + ", " + matrix2noOfOutputs + ")");
            System.exit(1);
        }
        int numRows = matrix1noOfInputs * matrix2noOfInputs;
        int numCols = matrix1noOfOutputs * matrix2noOfOutputs;
        double[][] matrix = new double[numRows][numCols];
        int i = 0;
        while (i < matrix1noOfInputs) {
            int j = 0;
            while (j < matrix2noOfInputs) {
                int row = matrix2noOfInputs * i + j;
                int k = 0;
                while (k < matrix1noOfOutputs) {
                    double a = matrix1[i][k];
                    int lMaxk = matrix2noOfOutputs * k;
                    int l = 0;
                    while (l < matrix2noOfOutputs) {
                        int col = lMaxk + l;
                        matrix[row][col] = matrix2[j][l] * a;
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static String[] parallelComposition(String[] names1, String[] names2, int size1, int size2, int size) {
        return Channel.parallelComposition(names1, names2, size1, size2, size, false, "");
    }

    public static String[] parallelComposition(String[] names1, String[] names2, int size1, int size2, int size, boolean removeBrackets, String separator) {
        if (size1 > names1.length || size2 > names2.length) {
            System.out.println("Error in the sizes of matrices.");
            System.out.println("  The actual size of names1 =    " + names1.length);
            System.out.println("  The actual size of names2 =    " + names2.length);
            System.out.println("  The specified size of names1 = " + size1);
            System.out.println("  The specified size of names2 = " + size2);
            System.exit(1);
        }
        String[] names = new String[size];
        int i = 0;
        while (i < size1) {
            int j = 0;
            while (j < size2) {
                String name1 = names1[i];
                String name2 = names2[j];
                if (removeBrackets) {
                    Matcher matcher;
                    Pattern pattern;
                    try {
                        pattern = Pattern.compile("\\([\\s]*([\\W\\w]+)[\\s]*\\)");
                        matcher = pattern.matcher(name1);
                        if (matcher.find()) {
                            name1 = matcher.group(1);
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Caution: Couldnot remove brackets from " + name1);
                    }
                    try {
                        pattern = Pattern.compile("\\([\\s]*([\\W\\w]+)[\\s]*\\)");
                        matcher = pattern.matcher(name2);
                        if (matcher.find()) {
                            name2 = matcher.group(1);
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Caution: Couldnot remove brackets from " + name2);
                    }
                }
                names[names2.length * i + j] = separator != "" ? String.valueOf(name1) + ", " + separator + ", " + name2 : String.valueOf(name1) + ", " + name2;
                ++j;
            }
            ++i;
        }
        return names;
    }

    private static Channel disjointMerge(Channel[] channels) {
        int j;
        int i;
        if (channels == null || channels.length <= 1) {
            System.out.println("Error in the channels.");
            System.out.println("  Incorrect channels are specified.");
            System.exit(1);
        }
        int numChannels = channels.length;
        int numRows = 0;
        int numCols = 0;
        int num = 0;
        while (num < numChannels) {
            numRows += channels[num].noOfInputs();
            numCols += channels[num].noOfOutputs();
            ++num;
        }
        double[][] matrix = new double[numRows][numCols];
        int currentRow = 0;
        int currentCol = 0;
        int num2 = 0;
        while (num2 < numChannels) {
            double[][] currentMatrix = channels[num2].getMatrix();
            i = 0;
            while (i < channels[num2].noOfInputs()) {
                j = 0;
                while (j < channels[num2].noOfOutputs()) {
                    matrix[currentRow + i][currentCol + j] = currentMatrix[i][j];
                    ++j;
                }
                ++i;
            }
            currentRow += channels[num2].noOfInputs();
            currentCol += channels[num2].noOfOutputs();
            ++num2;
        }
        String[] inputNames = new String[numRows];
        currentRow = 0;
        int num3 = 0;
        while (num3 < numChannels) {
            i = 0;
            while (i < channels[num3].noOfInputs()) {
                inputNames[currentRow + i] = "__" + num3 + "_" + channels[num3].getInputNames()[i];
                ++i;
            }
            currentRow += channels[num3].noOfInputs();
            ++num3;
        }
        String[] outputNames = new String[numCols];
        System.out.println("  numCols = " + numCols);
        currentCol = 0;
        int num4 = 0;
        while (num4 < numChannels) {
            j = 0;
            while (j < channels[num4].noOfOutputs()) {
                outputNames[currentCol + j] = "__" + num4 + "_" + channels[num4].getOutputNames()[j];
                ++j;
            }
            currentCol += channels[num4].noOfOutputs();
            ++num4;
        }
        Channel ch = new Channel(1, inputNames, outputNames, matrix);
        return ch;
    }

    public static Channel cascade(Channel[] channels) {
        if (channels == null || channels.length <= 1) {
            System.out.println("Error in the channels.");
            System.out.println("  Incorrect channels are specified.");
            System.exit(1);
        }
        int numChannels = channels.length;
        Channel ch = new Channel();
        int num = 0;
        while (num < numChannels - 1) {
            ch = Channel.cascade(channels[num], channels[num + 1]);
            ++num;
        }
        return ch;
    }

    private static Channel cascade(Channel ch1, Channel ch2) {
        String[] inputNames1 = ch1.getInputNames();
        String[] outputNames1 = ch1.getOutputNames();
        double[][] matrix1 = ch1.getMatrix();
        String[] inputNames2 = ch2.getInputNames();
        String[] outputNames2 = ch2.getOutputNames();
        double[][] matrix2 = ch2.getMatrix();
        if (matrix1[0].length != matrix2.length) {
            System.out.println("  The number of columns of matrix1 = " + matrix1[0].length);
            System.out.println("  The number of rows of matrix2    = " + matrix2.length);
            System.exit(1);
        }
        int numRows = matrix1.length;
        int numCols = matrix2[0].length;
        int numInner = matrix1[0].length;
        double[][] matrix = new double[numRows][numCols];
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                matrix[i][j] = 0.0;
                ++j;
            }
            int k1 = 0;
            while (k1 < numInner) {
                int k2 = k1;
                String innerName = outputNames1[k1];
                int row2 = 0;
                while (row2 < numInner) {
                    if (innerName.equals(inputNames2[row2])) {
                        k2 = row2;
                        break;
                    }
                    ++row2;
                }
                if (k2 < 0) {
                    System.out.println("Error: The output name of channel 1 was not found in channel 2: " + innerName);
                    System.exit(1);
                }
                double d = matrix1[i][k1];
                int j2 = 0;
                while (j2 < numCols) {
                    double[] dArray = matrix[i];
                    int n = j2;
                    dArray[n] = dArray[n] + matrix2[k2][j2] * d;
                    ++j2;
                }
                ++k1;
            }
            ++i;
        }
        Channel ch = new Channel(inputNames1, outputNames2, matrix);
        return ch;
    }

    private static double[][] cascade(double[][] matrix1, double[][] matrix2) {
        if (matrix1[0].length != matrix2.length) {
            System.out.println("  The number of columns of matrix1 = " + matrix1[0].length);
            System.out.println("  The number of rows of matrix2    = " + matrix2.length);
            System.exit(1);
        }
        int numRows = matrix1.length;
        int numCols = matrix2[0].length;
        int numInner = matrix1[0].length;
        double[][] matrix = new double[numRows][numCols];
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                matrix[i][j] = 0.0;
                ++j;
            }
            int k = 0;
            while (k < numInner) {
                double d = matrix1[i][k];
                int j2 = 0;
                while (j2 < numCols) {
                    double[] dArray = matrix[i];
                    int n = j2;
                    dArray[n] = dArray[n] + matrix2[k][j2] * d;
                    ++j2;
                }
                ++k;
            }
            ++i;
        }
        return matrix;
    }

    public static void addspaces(int i) {
        int j = 0;
        while (j <= i) {
            System.out.print(" ");
            ++j;
        }
    }

    protected static void printToLength(String s, int i) {
        System.out.print(s);
        int j = s.length();
        while (j <= i) {
            System.out.print(" ");
            ++j;
        }
    }

    public void printChannel() {
        int i;
        if (readFromChanFile) {
            System.out.println("The channel matrix to 4 decimal places:");
        } else {
            System.out.println("These observations lead to the following channel matrix, to 4 decimal places:");
        }
        if (this.outputNames.length <= 1) {
            this.sortOutputsDouble = false;
        }
        if (this.sortOutputsDouble && !this.sortOutputsDoubleDone) {
            this.sortByOutputValue();
            this.sortOutputsDoubleDone = true;
        }
        String sizeMatrix = "(" + this.inputNames.length + ", " + this.outputNames.length + ")";
        int maxOutLength = 0;
        int i2 = 0;
        while (i2 < this.outputNames.length) {
            maxOutLength = Math.max(maxOutLength, this.outputNames[i2].length());
            ++i2;
        }
        maxOutLength = Math.max(maxOutLength, 6);
        int maxInLength = 0;
        switch (this.kind) {
            case 1: {
                i = 0;
                while (i < this.inputNames.length) {
                    maxInLength = Math.max(maxInLength, this.inputNames[i].length());
                    ++i;
                }
                maxInLength = Math.max(maxInLength, sizeMatrix.length());
            }
        }
        System.out.print(sizeMatrix);
        Channel.addspaces(maxInLength - sizeMatrix.length() + 2);
        i = 0;
        while (i < this.outputNames.length) {
            System.out.print("| ");
            if (this.sortOutputsDouble) {
                Channel.printToLength(this.outputNamesSorted.get(i).getElement1(), maxOutLength);
            } else {
                Channel.printToLength(this.outputNames[i], maxOutLength);
            }
            ++i;
        }
        System.out.println("");
        i = 0;
        while (i < this.channelMatrix_W.length) {
            this.printRow(i, maxInLength, maxOutLength);
            ++i;
        }
        System.out.println("");
    }

    private void printRow(int RowNo, int maxInLength, int maxOutLength) {
        System.out.print(" ");
        Channel.printToLength(this.getRowLabel(RowNo), maxInLength + 1);
        int j = 0;
        while (j < this.outputNames.length) {
            System.out.print("| ");
            int k = this.sortOutputsDouble ? this.outputNamesSorted.get(j).getElement2() : j;
            Channel.printToLength(Double.toString(Stats.round(this.channelMatrix_W[RowNo][k], Math.max(4, maxOutLength - 2))), maxOutLength);
            ++j;
        }
        System.out.println("");
    }

    public void printJointMatrix(ProbDist pd) {
        int i;
        if (readFromChanFile) {
            System.out.println("The joint probability matrix to 4 decimal places:");
        } else {
            System.out.println("These observations lead to the following joint probability matrix, to 4 decimal places:");
        }
        if (this.sortOutputsDouble && !this.sortOutputsDoubleDone) {
            this.sortByOutputValue();
            this.sortOutputsDoubleDone = true;
        }
        String sizeMatrix = "(" + this.inputNames.length + ", " + this.outputNames.length + ")";
        int maxOutLength = 0;
        int i2 = 0;
        while (i2 < this.outputNames.length) {
            maxOutLength = Math.max(maxOutLength, this.outputNames[i2].length());
            ++i2;
        }
        maxOutLength = Math.max(maxOutLength, 6);
        int maxInLength = 0;
        switch (this.kind) {
            case 1: {
                i = 0;
                while (i < this.inputNames.length) {
                    maxInLength = Math.max(maxInLength, this.inputNames[i].length());
                    ++i;
                }
                maxInLength = Math.max(maxInLength, sizeMatrix.length());
            }
        }
        System.out.print(sizeMatrix);
        Channel.addspaces(maxInLength - sizeMatrix.length() + 2);
        i = 0;
        while (i < this.outputNames.length) {
            System.out.print("| ");
            if (this.sortOutputsDouble) {
                Channel.printToLength(this.outputNamesSorted.get(i).getElement1(), maxOutLength);
            } else {
                Channel.printToLength(this.outputNames[i], maxOutLength);
            }
            ++i;
        }
        System.out.println("");
        if (pd == null) {
            double inputProb = 1.0 / (double)this.channelMatrix_W.length;
            int i3 = 0;
            while (i3 < this.channelMatrix_W.length) {
                this.printRowJoint(i3, maxInLength, maxOutLength, inputProb);
                ++i3;
            }
        } else {
            i = 0;
            while (i < this.channelMatrix_W.length) {
                double inputProb = pd.getProb(this.getRowLabel(i));
                this.printRowJoint(i, maxInLength, maxOutLength, inputProb);
                ++i;
            }
        }
        System.out.println("");
    }

    private void printRowJoint(int RowNo, int maxInLength, int maxOutLength, double inputProb) {
        System.out.print(" ");
        Channel.printToLength(this.getRowLabel(RowNo), maxInLength + 1);
        int j = 0;
        while (j < this.outputNames.length) {
            System.out.print("| ");
            int k = this.outputNamesSorted.get(j).getElement2();
            double prob = this.channelMatrix_W[RowNo][k] * inputProb;
            Channel.printToLength(Double.toString(Stats.round(prob, Math.max(4, maxOutLength - 2))), maxOutLength);
            ++j;
        }
        System.out.println("");
    }

    private void sortByOutputValue() {
        try {
            int i = 0;
            while (i < this.outputNames.length) {
                Pair<String, Integer> swsi = new Pair<String, Integer>(this.outputNames[i], i);
                this.outputNamesSorted.add(swsi);
                ++i;
            }
            ComparatorStringWithInt comparator = new ComparatorStringWithInt();
            Collections.sort(this.outputNamesSorted, comparator);
        }
        catch (Exception e) {
            System.out.println("Error: failed to sort outputs in sortByOutputValue(): " + e);
            System.exit(1);
        }
    }
}

