/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.CSVFile;
import bham.leakiest.Channel;
import bham.leakiest.ContinuousData;
import bham.leakiest.Estimate;
import bham.leakiest.Observations;
import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.TestInfoLeak;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReadFile {
    int noOfInputs;
    String[] outputNames;
    String[] inputNames;
    double[][] channelMatrix;
    Observations obs;
    ProbDist pd;
    TreeSet<String> guessDomain;
    int noOfGroups;
    String[] groupNames;
    int[] groupForRow;
    Vector[] rowsForGroup;
    Vector<Vector<Integer>> inputsPerRow = new Vector();
    Channel channel;
    String fileName;
    String fileName2;
    private int verbose = 3;
    private int csvInterval;
    private CSVFile csvFile;
    private boolean terminateWhenStabilised = false;
    ContinuousData cdata;

    public ReadFile(String inputFileName, int v, String comment) {
        if (inputFileName == null) {
            System.out.println("Error: No file name (for " + comment + ") is specifed correctly.");
            System.exit(1);
        }
        this.fileName = this.removeQuotation(inputFileName);
        this.verbose = v;
        if (this.verbose > 3) {
            System.out.println("Loading data (" + comment + ") from " + inputFileName + "...");
        }
    }

    public ReadFile(String inputFileName, int v, int csvInterval, CSVFile csvFile) {
        if (inputFileName == null) {
            System.out.println("Error: No file name is specifed correctly.");
            System.exit(1);
        }
        this.fileName = this.removeQuotation(inputFileName);
        this.verbose = v;
        this.csvInterval = csvInterval;
        this.csvFile = csvFile;
        if (this.verbose > 3) {
            System.out.println("Loading data from " + inputFileName + " in increments of " + csvInterval + " lines...");
        }
    }

    public ReadFile(String inputFileName1, String inputFileName2, int v, String comment) {
        if (inputFileName1 == null || inputFileName2 == null) {
            System.out.println("Error: No file names (for " + comment + ") are specifed correctly.");
            System.exit(1);
        }
        this.fileName = this.removeQuotation(inputFileName1);
        this.fileName2 = this.removeQuotation(inputFileName2);
        this.verbose = v;
        if (this.verbose > 3) {
            System.out.println("Loading data (" + comment + ") from " + this.fileName + " and " + this.fileName2 + "...");
        }
    }

    public ReadFile(String inputFileName1, String inputFileName2, int v, int csvInterval, CSVFile csvFile) {
        if (inputFileName1 == null || inputFileName2 == null) {
            System.out.println("Error: No file names are specifed correctly.");
            System.exit(1);
        }
        this.fileName = this.removeQuotation(inputFileName1);
        this.fileName2 = this.removeQuotation(inputFileName2);
        this.verbose = v;
        this.csvInterval = csvInterval;
        this.csvFile = csvFile;
        if (this.verbose > 3) {
            System.out.println("Loading data from " + inputFileName1 + " and " + inputFileName2 + " in increments of " + csvInterval + " lines...");
        }
    }

    public void setTerminateWhenStabilised(boolean flag) {
        this.terminateWhenStabilised = flag;
        if (flag && this.verbose > 3) {
            System.out.println("Samples will stop being read when the corrected leakage value stabilises.");
        }
    }

    public String removeQuotation(String inputFileName) {
        if ((inputFileName.startsWith("\"") || inputFileName.startsWith("'") || inputFileName.startsWith("`")) && (inputFileName.endsWith("\"") || inputFileName.endsWith("'") || inputFileName.startsWith("`"))) {
            return inputFileName.substring(1, inputFileName.length() - 1);
        }
        return inputFileName;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Observations getObservations() {
        return this.obs;
    }

    public ProbDist getDistribution() {
        return this.pd;
    }

    public TreeSet<String> getGuessDomain() {
        return this.guessDomain;
    }

    public String[] readConfiguration() {
        ArrayList<String> optionsList = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.fileName));
            while ((line = reader.readLine()) != null) {
                String[] splitedLine;
                if (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) continue;
                String[] stringArray = splitedLine = line.split(" ", -1);
                int n = splitedLine.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (!str.trim().equalsIgnoreCase("")) {
                        optionsList.add(this.removeQuotation(str.trim()));
                    }
                    ++n2;
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Configuration file " + this.fileName + " not found.");
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("Error in reading the configuration file.");
            System.out.println("  The file does not follow a configuration (-cfg) format.");
            e.printStackTrace();
            System.exit(1);
        }
        String[] optionsArray = optionsList.toArray(new String[0]);
        return optionsArray;
    }

    public int decideFileType(String dataFileName) {
        int fileType = -1;
        try {
            if (this.verbose > 3) {
                System.out.println("Checking the file type...");
            }
            BufferedReader reader = new BufferedReader(new FileReader(dataFileName));
            String line = reader.readLine();
            Pattern patternCFG = Pattern.compile("^//CFG");
            Matcher matcherCFG = patternCFG.matcher(line);
            while (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) {
                line = reader.readLine();
            }
            Pattern patternARFF = Pattern.compile("@relation ([\\S]+)");
            Matcher matcherARFF = patternARFF.matcher(line);
            Pattern patternCh1 = Pattern.compile("\\([\\s]*([\\d]+)[\\s]*,[\\s]*([\\d]+)[\\s]*\\)[\\s]*:[\\s]*([\\d]+)*[\\s]*[\\s]*\\|");
            Matcher matcherCh1 = patternCh1.matcher(line);
            Pattern patternCh2 = Pattern.compile("\\([\\s]*([\\d]+)[\\s]*,[\\s]*([\\d]+)[\\s]*\\)[\\s]*\\|");
            Matcher matcherCh2 = patternCh2.matcher(line);
            line = reader.readLine();
            Pattern patternObs = Pattern.compile("\\([\\s]*([\\.\\w:]+)[\\s]*,[\\s]*([\\.\\w]+)[\\s]*\\)");
            Matcher matcherObs = patternObs.matcher(line.trim());
            if (matcherCFG.find()) {
                fileType = -2;
            } else if (matcherARFF.find()) {
                fileType = 0;
            } else if (matcherCh1.find() || matcherCh2.find()) {
                fileType = 1;
            } else if (matcherObs.find()) {
                fileType = 2;
            }
            reader.close();
        }
        catch (IOException e) {
            System.out.println("Error in trying to read the file: " + dataFileName);
            System.exit(1);
        }
        return fileType;
    }

    public void readChannel() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.fileName));){
            String line = reader.readLine();
            while (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) {
                line = reader.readLine();
            }
            this.channel = new Channel();
            String[] terms = line.split("\\|");
            Pattern pattern = Pattern.compile("\\([\\s]*([\\d]+)[\\s]*,[\\s]*([\\d]+)[\\s]*\\)[\\s]*:[\\s]*([\\d]+)*[\\s]*");
            Matcher matcher = pattern.matcher(terms[0].trim());
            if (matcher.find()) {
                this.channel.kind = 3;
                int noOfInputs = Integer.parseInt(matcher.group(1));
                int noOfOutputs = Integer.parseInt(matcher.group(2));
                int noOfGroups = Integer.parseInt(matcher.group(3));
                this.outputNames = new String[noOfOutputs];
                this.inputNames = new String[noOfInputs];
                this.groupNames = new String[noOfGroups];
                this.channelMatrix = new double[noOfInputs][noOfOutputs];
                this.groupForRow = new int[noOfInputs];
                this.rowsForGroup = new Vector[noOfGroups];
                int i = 0;
                while (i < noOfGroups) {
                    this.rowsForGroup[i] = new Vector();
                    ++i;
                }
                i = 1;
                while (i < terms.length) {
                    this.outputNames[i - 1] = terms[i].trim();
                    ++i;
                }
                this.channel.setOutputNames(this.outputNames);
                int linecounter = 0;
                while ((line = reader.readLine()) != null) {
                    int groupIndex;
                    if (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) continue;
                    terms = line.split("\\|");
                    String[] rowlabel = terms[0].split(":");
                    this.inputNames[linecounter] = rowlabel[0].trim();
                    this.groupForRow[linecounter] = groupIndex = this.addifnew(rowlabel[1].trim(), this.groupNames);
                    this.rowsForGroup[groupIndex].add(new Integer(linecounter));
                    int i2 = 1;
                    while (i2 < terms.length) {
                        this.channelMatrix[linecounter][i2 - 1] = Double.parseDouble(terms[i2].trim());
                        ++i2;
                    }
                    ++linecounter;
                }
                this.channel.setRowsForGroup(this.rowsForGroup);
                this.channel.setGroupForRow(this.groupForRow);
                this.channel.setInputNames(this.inputNames);
                this.channel.setMatrix(this.channelMatrix);
                this.channel.setOutputNames(this.outputNames);
                this.channel.setGroupNames(this.groupNames);
            } else {
                pattern = Pattern.compile("\\([\\s]*([\\d]+)[\\s]*,[\\s]*([\\d]+)[\\s]*\\)");
                matcher = pattern.matcher(terms[0].trim());
                if (matcher.find()) {
                    this.channel.kind = 1;
                    int noOfInputs = Integer.parseInt(matcher.group(1));
                    int noOfOutputs = Integer.parseInt(matcher.group(2));
                    this.outputNames = new String[noOfOutputs];
                    this.inputNames = new String[noOfInputs];
                    this.channelMatrix = new double[noOfInputs][noOfOutputs];
                    int i = 1;
                    while (i < terms.length) {
                        this.outputNames[i - 1] = terms[i].trim();
                        ++i;
                    }
                    this.channel.setOutputNames(this.outputNames);
                    int linecounter = 0;
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) continue;
                        terms = line.split("\\|");
                        if (linecounter >= noOfInputs) {
                            System.out.println("Error in reading line " + (linecounter + 1) + " in the channel file.");
                            System.out.println("  The size of the matrix is specified incorrectly.");
                            System.out.println("  noOfInputs (specified size)   = " + noOfInputs);
                            System.out.println("  line                          = " + line);
                        }
                        if (terms.length - 1 > noOfOutputs) {
                            System.out.println("Error in reading line " + (linecounter + 1) + " in the channel file.");
                            System.out.println("  The size of the matrix is specified incorrectly.");
                            System.out.println("  noOfOutputs (specified size)  = " + noOfOutputs);
                            System.out.println("  number of columns in the file = " + (terms.length - 1));
                        }
                        this.inputNames[linecounter] = terms[0].trim();
                        int i3 = 1;
                        while (i3 < terms.length) {
                            this.channelMatrix[linecounter][i3 - 1] = Double.parseDouble(terms[i3].trim());
                            ++i3;
                        }
                        ++linecounter;
                    }
                    this.channel.setInputNames(this.inputNames);
                    this.channel.setMatrix(this.channelMatrix);
                } else {
                    pattern = Pattern.compile("\\([\\s]*([\\d]+)[\\s]*,[\\s]*([\\d]+)[\\s]*,[\\s]*([\\d]+)[\\s]*\\)*");
                    matcher = pattern.matcher(terms[0].trim());
                    if (matcher.find()) {
                        this.channel.kind = 2;
                        this.outputNames = new String[Integer.parseInt(matcher.group(3))];
                        this.inputNames = new String[Integer.parseInt(matcher.group(1))];
                        this.channelMatrix = new double[Integer.parseInt(matcher.group(2))][Integer.parseInt(matcher.group(3))];
                        int i = 1;
                        while (i < terms.length) {
                            this.outputNames[i - 1] = terms[i].trim();
                            ++i;
                        }
                        this.channel.setOutputNames(this.outputNames);
                        int rowCounter = 0;
                        while ((line = reader.readLine()) != null) {
                            if (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) continue;
                            terms = line.split("\\|");
                            String[] arrayOfInputs = terms[0].split(",");
                            Vector<Integer> inputIndexRowVector = new Vector<Integer>();
                            if (!arrayOfInputs[0].trim().equals("")) {
                                int ic = 0;
                                while (ic < arrayOfInputs.length) {
                                    int inputIndex = 0;
                                    while (this.inputNames[inputIndex] != null && !this.inputNames[inputIndex].equals(arrayOfInputs[ic].trim())) {
                                        ++inputIndex;
                                    }
                                    if (this.inputNames[inputIndex] == null) {
                                        this.inputNames[inputIndex] = arrayOfInputs[ic].trim();
                                    }
                                    inputIndexRowVector.add(new Integer(inputIndex));
                                    ++ic;
                                }
                            }
                            this.inputsPerRow.add(inputIndexRowVector);
                            int i4 = 1;
                            while (i4 < terms.length) {
                                this.channelMatrix[rowCounter][i4 - 1] = Double.parseDouble(terms[i4].trim());
                                ++i4;
                            }
                            ++rowCounter;
                        }
                        this.channel.setInputNames(this.inputNames);
                        this.channel.setInputsPerRow(ReadFile.vectorVectorToArrayVector(this.inputsPerRow));
                        this.channel.setMatrix(this.channelMatrix);
                    } else {
                        System.out.println("Syntax error while reading line: " + line);
                        System.out.println("  File should start with a term of the form (noOfInputs,noOfOutputs),");
                        System.out.println("  (noOfInputs,noOfOutputs):noOfGroups or (noOfInputs,noOfRows,noOfOutputs)");
                        System.out.println("  The file does not follow a channel file (-c) format.");
                        System.exit(0);
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("Channel file not found: " + this.fileName);
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println("Error in reading the channel file.");
            System.out.println("  The file does not follow a channel file (-c) format.");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private int addifnew(String str, String[] strs) {
        int i = 0;
        while (i < strs.length) {
            if (strs[i] == null) {
                strs[i] = str;
                break;
            }
            if (strs[i].equals(str)) break;
            ++i;
        }
        return i;
    }

    public static Vector[] vectorVectorToArrayVector(Vector<Vector<Integer>> v) {
        Vector[] result = new Vector[v.size()];
        int i = 0;
        while (i < v.size()) {
            result[i] = v.get(i);
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readObservations() {
        this.obs = new Observations();
        try (BufferedReader input = new BufferedReader(new FileReader(this.fileName));){
            try {
                Pattern pattern = Pattern.compile("\\([\\s]*([\\.\\w\\W:]+)[\\s]*,[\\s]*([\\.\\w\\W]+)[\\s]*\\)");
                int lineNumber = 1;
                boolean leakageStabilised = false;
                double correctedLeakageFirstInterval = Double.NaN;
                double correctedLeakageSecondInterval = Double.NaN;
                int nextLeakageInterval = 100;
                while (!leakageStabilised) {
                    String line = input.readLine();
                    if (line == null) {
                        return;
                    }
                    Matcher matcher = pattern.matcher(line.trim());
                    if (!matcher.find()) {
                        System.out.println("Syntax error while reading line: " + line);
                    }
                    this.obs.addObservation(matcher.group(1), matcher.group(2));
                    if (this.csvInterval != 0 && lineNumber % this.csvInterval == 0) {
                        this.csvFile.addLeakageData(this.obs, TestInfoLeak.taskType);
                    }
                    if (this.terminateWhenStabilised && lineNumber == nextLeakageInterval) {
                        nextLeakageInterval += 2 * (this.obs.getUniqueInputCount() * this.obs.getUniqueOutputCount());
                        if (Double.isNaN(correctedLeakageFirstInterval)) {
                            correctedLeakageFirstInterval = Estimate.getCorrectedMutualInformation(this.obs);
                            if (this.verbose > 3) {
                                System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by > %s, checking again after %d samples\n", lineNumber, correctedLeakageFirstInterval, String.valueOf(0.01), nextLeakageInterval);
                            }
                        } else {
                            correctedLeakageSecondInterval = Estimate.getCorrectedMutualInformation(this.obs);
                            if (Math.abs(correctedLeakageSecondInterval - correctedLeakageFirstInterval) <= 0.01) {
                                if (this.verbose > 3) {
                                    System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by <= %s, not reading any more samples\n", lineNumber, correctedLeakageSecondInterval, String.valueOf(0.01));
                                }
                                leakageStabilised = true;
                            } else {
                                if (this.verbose > 3) {
                                    System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by > %s, checking again after %d samples\n", lineNumber, correctedLeakageSecondInterval, String.valueOf(0.01), nextLeakageInterval);
                                }
                                correctedLeakageFirstInterval = correctedLeakageSecondInterval;
                            }
                        }
                    }
                    ++lineNumber;
                }
                return;
            }
            catch (Exception ex) {
                if (this.verbose >= 5) {
                    ex.printStackTrace();
                }
                System.out.println("Error in reading the observation file: " + this.fileName);
                System.out.println("  The file does not follow an observation file (-o) format.");
                System.exit(1);
                input.close();
                return;
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("Observation file not found:" + this.fileName);
            System.out.println("Failed to read a discrete observation file.");
            System.exit(1);
            return;
        }
        catch (Exception ex) {
            System.out.println("Error in reading the observation file: " + this.fileName);
            System.out.println("  The file might not follow an observation file (-o) format.");
            System.exit(1);
        }
    }

    public void readContinuousObservations() {
        this.obs = new Observations();
        this.cdata = new ContinuousData();
        try {
            ArrayList tmpDataList;
            block15: {
                BufferedReader input = new BufferedReader(new FileReader(this.fileName));
                tmpDataList = new ArrayList();
                try {
                    try {
                        String line;
                        Pattern pattern = Pattern.compile("\\([\\s]*([\\.\\w:]+)[\\s]*,[\\s]*([\\.\\w]+)[\\s]*\\)");
                        while ((line = input.readLine()) != null) {
                            Matcher matcher = pattern.matcher(line.trim());
                            if (!matcher.find()) {
                                System.out.println("Syntax error  while reading line: " + line);
                            }
                            String instr = matcher.group(1);
                            String outstr = matcher.group(2);
                            this.obs.addObservation(instr, outstr);
                            while (tmpDataList.size() < this.obs.getUniqueInputCount()) {
                                ArrayList ald = new ArrayList();
                                tmpDataList.add(ald);
                            }
                            int inputIndex = 0;
                            boolean foundInput = false;
                            while (inputIndex < this.obs.getUniqueInputCount() && !foundInput) {
                                if (this.obs.getInputNames()[inputIndex].equals(instr)) {
                                    ((ArrayList)tmpDataList.get(inputIndex)).add(Double.parseDouble(outstr));
                                    foundInput = true;
                                    continue;
                                }
                                ++inputIndex;
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Error in reading the observation file: " + this.fileName);
                        System.out.println("  The file does not follow an observation file (-o) format.");
                        System.exit(1);
                        input.close();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    input.close();
                    throw throwable;
                }
                input.close();
            }
            for (ArrayList arrayList : tmpDataList) {
                double[] tmp = new double[arrayList.size()];
                int i = 0;
                while (i < arrayList.size()) {
                    tmp[i] = (Double)arrayList.get(i);
                    ++i;
                }
                this.cdata.DataList.add(tmp);
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("Observation file not found:" + this.fileName);
            System.out.println("Failed to read a continuous observation file.");
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println("Error in reading the continuous observation file: " + this.fileName);
            System.out.println("  The file might not follow an observation file (-o) format.");
            System.out.println("  or does not contain continuous data");
            System.exit(1);
        }
    }

    public void read2DiscreteObservationsFiles() {
        this.obs = new Observations();
        int totalLines = 1;
        try {
            BufferedReader reader1 = new BufferedReader(new FileReader(this.fileName));
            BufferedReader reader2 = new BufferedReader(new FileReader(this.fileName2));
            BufferedReader[] readers = new BufferedReader[]{reader1, reader2};
            String[] fileNames = new String[]{this.fileName, this.fileName2};
            int activeBuffer = 0;
            boolean switchBuffers = true;
            boolean leakageStabilised = false;
            double correctedLeakageFirstInterval = Double.NaN;
            double correctedLeakageSecondInterval = Double.NaN;
            int nextLeakageInterval = 100;
            try {
                try {
                    while (!leakageStabilised) {
                        String line = readers[activeBuffer].readLine();
                        if (line == null) {
                            if (switchBuffers) {
                                activeBuffer = activeBuffer == 0 ? 1 : 0;
                                switchBuffers = false;
                                continue;
                            }
                            break;
                        }
                        this.obs.addObservation(fileNames[activeBuffer], line);
                        if (this.csvInterval != 0 && totalLines % this.csvInterval == 0) {
                            this.csvFile.addLeakageData(this.obs, TestInfoLeak.taskType);
                        }
                        if (this.terminateWhenStabilised && totalLines == nextLeakageInterval) {
                            nextLeakageInterval += 2 * (this.obs.getUniqueInputCount() * this.obs.getUniqueOutputCount());
                            if (Double.isNaN(correctedLeakageFirstInterval)) {
                                correctedLeakageFirstInterval = Estimate.getCorrectedMutualInformation(this.obs);
                                if (this.verbose > 3) {
                                    System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by > %s, checking again after %d samples\n", totalLines, correctedLeakageFirstInterval, String.valueOf(0.01), nextLeakageInterval);
                                }
                            } else {
                                correctedLeakageSecondInterval = Estimate.getCorrectedMutualInformation(this.obs);
                                if (Math.abs(correctedLeakageSecondInterval - correctedLeakageFirstInterval) <= 0.01) {
                                    if (this.verbose > 3) {
                                        System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by <= %s, not reading any more samples\n", totalLines, correctedLeakageSecondInterval, String.valueOf(0.01));
                                    }
                                    leakageStabilised = true;
                                } else {
                                    if (this.verbose > 3) {
                                        System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by > %s, checking again after %d samples\n", totalLines, correctedLeakageSecondInterval, String.valueOf(0.01), nextLeakageInterval);
                                    }
                                    correctedLeakageFirstInterval = correctedLeakageSecondInterval;
                                }
                            }
                        }
                        if (switchBuffers) {
                            activeBuffer = activeBuffer == 0 ? 1 : 0;
                        }
                        ++totalLines;
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in reading the observation file: " + this.fileName);
                    System.out.println("  The file does not follow an observation file (-o2) format.");
                    System.exit(1);
                    reader1.close();
                    reader2.close();
                }
            }
            finally {
                reader1.close();
                reader2.close();
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found: Failed to read two discrete observation files.");
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println("Error in reading the observation file: " + this.fileName + " or " + this.fileName2);
            System.out.println("  These files might not follow observation files (-o2) format.");
            System.exit(1);
        }
    }

    public void read2ContinuousObservationsFiles() {
        this.cdata = new ContinuousData(this.fileName, this.fileName2);
        try {
            double[] Data1 = this.cdata.loadData(this.fileName);
            double[] Data2 = this.cdata.loadData(this.fileName2);
            this.cdata.DataList.add(Data1);
            this.cdata.DataList.add(Data2);
            if (TestInfoLeak.fixMeanForPassportAnalyses) {
                this.cdata.fixedMeans(Data1, Data2);
                System.out.println("Fixing the mean of the data of passport analyses...");
            } else if (TestInfoLeak.fixMedianForPassportAnalyses) {
                this.cdata.fixedMedians(Data1, Data2);
                System.out.println("Fixing the median of the data of passport analyses...");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found error:" + e);
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("Error in reading and parsing data");
            System.out.println("The data might not be continuous.");
            System.exit(1);
        }
    }

    public ContinuousData getContinuousData() {
        return this.cdata;
    }

    public void readDistribution() {
        try (BufferedReader input = new BufferedReader(new FileReader(this.fileName));){
            try {
                String line;
                Pattern pattern = Pattern.compile("^[\\s]*\\([\\s]*([\\.\\-\\w:]+)[\\s]*,[\\s]*([\\(|\\.|\\w|\\W|\\s|,|\\)]+)[\\s]*\\)");
                int lineNumber = 0;
                ArrayList<String> sts = new ArrayList<String>();
                ArrayList<Double> pmf = new ArrayList<Double>();
                while ((line = input.readLine()) != null) {
                    if (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) continue;
                    Matcher matcher = pattern.matcher(line.trim());
                    if (!matcher.find()) {
                        System.out.println("Syntax error while reading line: " + line);
                    }
                    double prob = 0.0;
                    try {
                        prob = Double.parseDouble(matcher.group(1));
                    }
                    catch (Exception e) {
                        System.out.println("Error in reading the input (prior) file.");
                        System.out.println("  The file does not follow the prior file (-prior) format.");
                        System.exit(1);
                    }
                    sts.add(matcher.group(2));
                    pmf.add(prob);
                    ++lineNumber;
                }
                this.pd = new ProbDist(lineNumber);
                int i = 0;
                while (i < lineNumber) {
                    State st = new State();
                    st.updateValue("input", (String)sts.get(i));
                    this.pd.updateProb(st, (Double)pmf.get(i));
                    ++i;
                }
            }
            catch (Exception ex) {
                if (this.verbose >= 5) {
                    ex.printStackTrace();
                }
                System.out.println("Error in reading the prior file: " + this.fileName);
                System.out.println("  The file does not follow the prior file (-prior) format.");
                System.exit(1);
                input.close();
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("Prior file not found:" + this.fileName);
            System.out.println("Failed to read a discrete prior file.");
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println("Error in reading the prior file: " + this.fileName);
            System.out.println("  The file might not follow the prior file (-prior) format.");
            System.exit(1);
        }
    }

    public void readGuessDomain() {
        try {
            this.guessDomain = new TreeSet();
            try (BufferedReader input = new BufferedReader(new FileReader(this.fileName));){
                try {
                    String line;
                    Pattern pattern = Pattern.compile("\\{[\\s]*(.*)[\\s]*\\}");
                    while ((line = input.readLine()) != null) {
                        if (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) continue;
                        Matcher matcher = pattern.matcher(line.trim());
                        if (!matcher.find()) {
                            System.out.println("Syntax error while reading line: " + line);
                            continue;
                        }
                        this.guessDomain.add(matcher.group(1));
                    }
                    if (this.verbose >= 5) {
                        System.out.println("Guess domain = {");
                        for (String str : this.guessDomain) {
                            System.out.println("  {" + str + "},");
                        }
                        System.out.println("}");
                    }
                }
                catch (Exception ex) {
                    if (this.verbose >= 5) {
                        ex.printStackTrace();
                    }
                    System.out.println("Error in reading the guess domain file: " + this.fileName);
                    System.out.println("  The file does not follow a guess domain file (-guess) format.");
                    System.exit(1);
                    input.close();
                }
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("Guess domain file not found:" + this.fileName);
            System.out.println("Failed to read a guess domain file.");
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println("Error in reading the guess domain file: " + this.fileName);
            System.out.println("  The file might not follow a guess domain file (-guess) format.");
            System.exit(1);
        }
    }
}

