/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.infotheory.InfoTheory;
import java.util.ArrayList;

public class Stats {
    private static final double ERROR = -1.0;
    public static double[] chiSquareValues95 = new double[]{3.841, 5.991, 7.815, 9.488, 11.07, 12.59, 14.07, 15.51, 16.92, 18.31, 19.68, 21.03, 22.36, 23.69, 25.0, 26.3, 27.59, 28.87, 30.14, 31.41, 32.67, 33.92, 35.17, 36.42, 37.65, 38.89, 40.11, 41.34, 42.56, 43.77, 44.99, 46.19, 47.4, 48.6, 49.8, 51.0, 52.19, 53.38, 54.57, 55.76, 56.94, 58.12, 59.3, 60.48, 61.66, 62.83, 64.0, 65.17, 66.34, 67.51, 68.67, 69.83, 70.99, 72.15, 73.31, 74.47, 75.62, 76.78, 77.93, 79.08, 80.23, 81.38, 82.53, 83.68, 84.82, 85.97, 87.11, 88.25, 89.39, 90.53, 91.67, 92.81, 93.95, 95.08, 96.22, 97.35, 98.49, 99.62, 100.75, 101.88, 103.01, 104.14, 105.27, 106.4, 107.52, 108.65, 109.77, 110.9, 112.02, 113.15, 114.27, 115.39, 116.51, 117.63, 118.75, 119.87, 120.99, 122.11, 123.23, 124.34};

    public static double round(double n, int dp) {
        if (dp < 0) {
            throw new IllegalArgumentException("Parameter \"dp\" must be non-negative");
        }
        dp = Math.min(dp, 50);
        return Math.rint(n * Math.pow(10.0, dp)) / Math.pow(10.0, dp);
    }

    public static int maxIndex(double[] array) {
        double max = array[0];
        int indexMax = 0;
        int index = 1;
        while (index < array.length) {
            if (max < array[index]) {
                indexMax = index;
                max = array[index];
            }
            ++index;
        }
        return indexMax;
    }

    public static int minIndex(double[] array) {
        double min = array[0];
        int indexMin = 0;
        int index = 1;
        while (index < array.length) {
            if (min > array[index]) {
                indexMin = index;
                min = array[index];
            }
            ++index;
        }
        return indexMin;
    }

    public static int maxIndex(int[] array) {
        int max = array[0];
        int indexMax = 0;
        int index = 1;
        while (index < array.length) {
            if (max < array[index]) {
                indexMax = index;
                max = array[index];
            }
            ++index;
        }
        return indexMax;
    }

    public static int minIndex(int[] array) {
        int min = array[0];
        int indexMin = 0;
        int index = 1;
        while (index < array.length) {
            if (min > array[index]) {
                indexMin = index;
                min = array[index];
            }
            ++index;
        }
        return indexMin;
    }

    public static int maxIndex(ArrayList<Integer> array) {
        int max = array.get(0);
        int indexMax = 0;
        int index = 1;
        while (index < array.size()) {
            if (max < array.get(index)) {
                indexMax = index;
                max = array.get(index);
            }
            ++index;
        }
        return indexMax;
    }

    public static int minIndex(ArrayList<Integer> array) {
        int min = array.get(0);
        int indexMin = 0;
        int index = 1;
        while (index < array.size()) {
            if (min > array.get(index)) {
                indexMin = index;
                min = array.get(index);
            }
            ++index;
        }
        return indexMin;
    }

    public static double chiSqu95Interval(int freedom) {
        if (freedom <= 0) {
            throw new IllegalArgumentException("Parameter \"freedom\" must be greater than 0");
        }
        if (freedom < 101) {
            return chiSquareValues95[freedom - 1];
        }
        return 1.644854 * Math.sqrt(2 * freedom) + (double)freedom;
    }

    public static double chiSquare(int[] observedCounts, double[] expectedCounts) {
        if (observedCounts.length != expectedCounts.length) {
            System.out.println("Error: the lengths of arrays of observed and expected counts are different.");
            System.exit(1);
        }
        double chisq = 0.0;
        int i = 0;
        while (i < observedCounts.length) {
            double diff = (double)observedCounts[i] - expectedCounts[i];
            double sq = diff * diff / expectedCounts[i];
            chisq += sq;
            ++i;
        }
        return chisq;
    }

    public static double chiSquare(int[] observedCounts, int[] expectedCounts) {
        if (observedCounts.length != expectedCounts.length) {
            System.out.println("Error: the lengths of arrays of observed and expected counts are different.");
            System.exit(1);
        }
        double chisq = 0.0;
        int i = 0;
        while (i < observedCounts.length) {
            double diff = (double)observedCounts[i] - (double)expectedCounts[i];
            double sq = diff * diff / (double)expectedCounts[i];
            chisq += sq;
            ++i;
        }
        return chisq;
    }

    public static double G(int[] observedCounts, double[] expectedCounts) {
        if (observedCounts.length != expectedCounts.length) {
            System.out.println("Error: the lengths of arrays of observed and expected counts are different.");
            System.exit(1);
        }
        double sum = 0.0;
        int i = 0;
        while (i < observedCounts.length) {
            double KL = (double)observedCounts[i] * Math.log((double)observedCounts[i] / expectedCounts[i]);
            sum += KL;
            ++i;
        }
        return 2.0 * sum;
    }

    public static double upperBoundNormal95(double mean, double variance) {
        return mean + 1.959964 * Math.sqrt(variance);
    }

    public static double upperBoundNormal95Upper(double mean, double variance) {
        return mean + 1.644854 * Math.sqrt(variance);
    }

    public static double lowerBoundNormal95(double mean, double variance) {
        return mean - 1.959964 * Math.sqrt(variance);
    }

    public static double lowerBoundNormal95Lower(double mean, double variance) {
        return mean - 1.644854 * Math.sqrt(variance);
    }

    public static double upperBoundForZero(int freedom, int sampleSize) {
        return Math.pow(InfoTheory.log2(Math.E), 2.0) * Stats.chiSqu95Interval(freedom) / (double)(2 * sampleSize);
    }

    public static double sdtDevSampled(double[] data, double sum) {
        double average = sum / (double)data.length;
        double sumDiffsSquares = 0.0;
        int i = 0;
        while (i < data.length) {
            sumDiffsSquares += (average - data[i]) * (average - data[i]);
            ++i;
        }
        return Math.sqrt(1.0 / ((double)data.length - 1.0) * sumDiffsSquares);
    }

    public static double sdtDevSampled(double[] data) {
        double sum = 0.0;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        return Stats.sdtDevSampled(data, sum);
    }
}

