/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.ARFFFile;
import bham.leakiest.CSVFile;
import bham.leakiest.Channel;
import bham.leakiest.CommandLine;
import bham.leakiest.CompositionalEstimate;
import bham.leakiest.ContinuousData;
import bham.leakiest.Observations;
import bham.leakiest.PrintLeakageValue;
import bham.leakiest.ProbDist;
import bham.leakiest.ReadFile;
import bham.leakiest.Stats;
import bham.leakiest.infotheory.GainFunction;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class TestInfoLeak {
    static String version = "1.4.8.2";
    static final int CLC_MUTUAL_INFO = 1;
    static final int CLC_CAPACITY = 2;
    static final int CLC_MIN_ENTROPY = 3;
    static final int CLC_MIN_CAPACITY = 4;
    static final int CLC_G_LEAK = 5;
    static final int READ_CFG = -2;
    static final int READ_ERROR = -1;
    static final int READ_ARFF = 0;
    static final int READ_CH = 1;
    static final int READ_OBS1 = 2;
    static final int READ_OBS2 = 3;
    static final int READ_PRIOR = 4;
    static final int READ_GUESS = 5;
    static final int LEAKAGE_STABILISATION_INITIAL_INTERVAL = 100;
    static final double LEAKAGE_STABILISATION_DELTA = 0.01;
    static final double ERROR = -1.0;
    static final double UNKNOWN = -2.0;
    static final double APPROX_OPTIMIZED = 10.0;
    static TreeSet<Integer> highFeatures = new TreeSet();
    static TreeSet<String> highFeaturesSet = new TreeSet();
    static TreeSet<Integer> lowFeatures = new TreeSet();
    static TreeSet<String> lowFeaturesSet = new TreeSet();
    static boolean checkEachFeature = false;
    static boolean readFromChanFile = false;
    static boolean readFromCfgFile = false;
    static boolean readFromObsFile = false;
    static boolean readFrom2ObsFiles = false;
    static boolean readFromARFFFile = false;
    static boolean readFromPriorFile = false;
    static boolean readFromGuessFile = false;
    static boolean ignoreOptionDis = false;
    static boolean ignoreOptionCfg = false;
    static boolean ignoreOptionDir = false;
    static boolean ignoreOptionIn = false;
    static boolean ignoreOptionOut = false;
    static boolean ignoreOptionPrior = false;
    static boolean ignoreOptionGuess = false;
    static boolean ignoreOptionNOCR = false;
    static boolean ignoreOptionAPPROX = false;
    static boolean ignoreOptionAJS = false;
    static boolean ignoreOptionPM = false;
    static boolean ignoreOptionPJ = false;
    static boolean ignoreOptionCSV = false;
    static boolean ignoreOptionTerminate = false;
    static int taskType = 1;
    static boolean compositionalEstimate = false;
    static boolean priorShared = false;
    static boolean skipZLT = false;
    static boolean correctLeak = true;
    static boolean correctLeakNew = true;
    static double approxPriorLevel = 0.0;
    static boolean approxDoNotKnowChannels = false;
    static boolean checkJointlySupported = true;
    static int fileType = 1;
    static boolean OBS_DISCRETE = true;
    static boolean debugCode = false;
    static boolean PRINT_CHANNELMATRIX = false;
    static boolean PRINT_JOINTMATRIX = false;
    public static int verbose = 0;
    static double acceptableError = 1.0E-12;
    static int noOfIterations = 10000;
    static int noOfTestsContinuous = 200;
    protected static boolean fixMeanForPassportAnalyses = false;
    protected static boolean fixMedianForPassportAnalyses = false;
    static Observations obs;
    private static int numChannels;
    static Channel channel;
    static Channel[] channels;
    static ContinuousData cdata;
    private static int numPriors;
    static ProbDist[] pds;
    static Set<String> guessDomain;
    static String nameGainFunction;
    static GainFunction gf;
    static String cfgFileName;
    static String directoryName;
    static String dataFileName;
    static String dataFileName2;
    static String[] dataFileNames;
    static String[] priorFileNames;
    static String guessFileName;
    static int csvEstimationInterval;
    static CSVFile csvFile;
    static boolean terminateWhenStabilised;
    static boolean priorNonUniform;
    static int sampleSize;
    static int[] sampleSizeGivenInput;
    static int[] sampleSizeGivenOutput;
    static ArrayList<String> name;

    static {
        numChannels = 1;
        numPriors = 1;
        cfgFileName = "";
        directoryName = "";
        dataFileName = "";
        dataFileName2 = "";
        guessFileName = "";
        csvEstimationInterval = 0;
        terminateWhenStabilised = false;
        priorNonUniform = false;
        sampleSize = 0;
        name = new ArrayList();
    }

    public static void main(String[] args) {
        TreeSet lowFeaturesNow;
        ReadFile obsReader;
        CommandLine cl = new CommandLine(args);
        highFeatures = cl.highFeatures;
        highFeaturesSet = cl.highFeaturesSet;
        lowFeatures = cl.lowFeatures;
        lowFeaturesSet = cl.lowFeaturesSet;
        checkEachFeature = cl.checkEachFeature;
        readFromChanFile = cl.readFromChanFile;
        readFromCfgFile = cl.readFromCfgFile;
        readFromObsFile = cl.readFromObsFile;
        readFrom2ObsFiles = cl.readFrom2ObsFiles;
        readFromARFFFile = cl.readFromARFFFile;
        readFromPriorFile = cl.readFromPriorFile;
        readFromGuessFile = cl.readFromGuessFile;
        ignoreOptionDis = cl.ignoreOptionDis;
        ignoreOptionCfg = cl.ignoreOptionCfg;
        ignoreOptionDir = cl.ignoreOptionDir;
        ignoreOptionIn = cl.ignoreOptionIn;
        ignoreOptionOut = cl.ignoreOptionOut;
        ignoreOptionPrior = cl.ignoreOptionPrior;
        ignoreOptionGuess = cl.ignoreOptionGuess;
        ignoreOptionNOCR = cl.ignoreOptionNOCR;
        ignoreOptionAPPROX = cl.ignoreOptionAPPROX;
        ignoreOptionAJS = cl.ignoreOptionAJS;
        ignoreOptionPM = cl.ignoreOptionPM;
        ignoreOptionPJ = cl.ignoreOptionPJ;
        ignoreOptionCSV = cl.ignoreOptionCSV;
        ignoreOptionTerminate = cl.ignoreOptionTerminate;
        taskType = cl.taskType;
        compositionalEstimate = cl.compositionalEstimate;
        priorShared = cl.priorShared;
        skipZLT = cl.skipZLT;
        correctLeak = cl.correctLeak;
        correctLeakNew = cl.correctLeakNew;
        approxPriorLevel = cl.approxPriorLevel;
        approxDoNotKnowChannels = cl.approxDoNotKnowChannels;
        checkJointlySupported = cl.checkJointlySupported;
        fileType = cl.fileType;
        OBS_DISCRETE = cl.OBS_DISCRETE;
        debugCode = cl.debugCode;
        PRINT_CHANNELMATRIX = cl.PRINT_CHANNELMATRIX;
        PRINT_JOINTMATRIX = cl.PRINT_JOINTMATRIX;
        verbose = cl.verbose;
        acceptableError = cl.acceptableError;
        noOfIterations = cl.noOfIterations;
        noOfTestsContinuous = cl.noOfTestsContinuous;
        fixMeanForPassportAnalyses = cl.fixMeanForPassportAnalyses;
        fixMedianForPassportAnalyses = cl.fixMedianForPassportAnalyses;
        numChannels = cl.numChannels;
        channels = cl.channels;
        numPriors = cl.numPriors;
        pds = cl.pds;
        nameGainFunction = cl.nameGainFunction;
        gf = cl.gf;
        cfgFileName = cl.cfgFileName;
        directoryName = cl.directoryName;
        dataFileName = cl.dataFileName;
        dataFileName2 = cl.dataFileName2;
        dataFileNames = cl.dataFileNames;
        priorFileNames = cl.priorFileNames;
        guessFileName = cl.guessFileName;
        csvEstimationInterval = cl.csvEstimationInterval;
        csvFile = cl.csvFile;
        terminateWhenStabilised = cl.terminateWhenStabilised;
        PrintLeakageValue plv = new PrintLeakageValue(PRINT_CHANNELMATRIX, PRINT_JOINTMATRIX, verbose, acceptableError, noOfIterations, OBS_DISCRETE, readFromChanFile, skipZLT, correctLeak, correctLeakNew);
        boolean bl = priorNonUniform = readFromPriorFile || !readFromChanFile;
        if (readFromObsFile && OBS_DISCRETE) {
            obsReader = csvFile == null ? new ReadFile(dataFileName, verbose, "discrete observations") : new ReadFile(dataFileName, verbose, csvEstimationInterval, csvFile);
            obsReader.setTerminateWhenStabilised(terminateWhenStabilised);
            obsReader.readObservations();
            obs = obsReader.getObservations();
            if (verbose > 1) {
                System.out.println("Calculating the channel matrix...");
            }
            channel = obs.generateChannel();
            pds = new ProbDist[1];
            TestInfoLeak.pds[0] = obs.getInputProbDist();
            if (verbose >= 5) {
                System.out.println("Input distribution:");
                pds[0].printProbDist();
            }
            sampleSize = obs.getSampleCount();
            sampleSizeGivenInput = obs.getSampleCountGivenInput();
            sampleSizeGivenOutput = obs.getSampleCountGivenOutput();
            if (verbose > 3) {
                obs.printObservationsMatrix();
            }
            if (verbose > 4) {
                System.out.println("\nThe largest " + TestInfoLeak.obs.certainty * 100.0 + "% confidence interval for any entry, to 4 decimal places, is " + Stats.round(2.0 * obs.largestInterval(), 4));
            }
        }
        if (readFromObsFile && !OBS_DISCRETE) {
            obsReader = new ReadFile(dataFileName, verbose, "continuous observations");
            obsReader.readContinuousObservations();
            cdata = obsReader.getContinuousData();
        }
        if (readFrom2ObsFiles && OBS_DISCRETE) {
            obsReader = csvFile == null ? new ReadFile(dataFileName, dataFileName2, verbose, "discrete observations") : new ReadFile(dataFileName, dataFileName2, verbose, csvEstimationInterval, csvFile);
            obsReader.setTerminateWhenStabilised(terminateWhenStabilised);
            obsReader.read2DiscreteObservationsFiles();
            obs = obsReader.getObservations();
            if (verbose > 1) {
                System.out.println("Calculating the channel matrix...");
            }
            channel = obs.generateChannel();
            pds = new ProbDist[1];
            TestInfoLeak.pds[0] = obs.getInputProbDist();
            sampleSize = obs.getSampleCount();
            sampleSizeGivenInput = obs.getSampleCountGivenInput();
            sampleSizeGivenOutput = obs.getSampleCountGivenOutput();
            if (verbose > 4) {
                System.out.println("\nThe largest " + TestInfoLeak.obs.certainty * 100.0 + "% confidence interval for any entry, to 4 decimal places, is " + Stats.round(2.0 * obs.largestInterval(), 4));
            }
        }
        if (readFrom2ObsFiles && !OBS_DISCRETE) {
            obsReader = new ReadFile(dataFileName, dataFileName2, verbose, "continuous observations");
            obsReader.read2ContinuousObservationsFiles();
            cdata = obsReader.getContinuousData();
        }
        if (readFromChanFile) {
            int ic = 0;
            while (ic < numChannels) {
                if (dataFileNames != null && ic < dataFileNames.length && dataFileNames[ic] != null) {
                    ReadFile channelFileReader = new ReadFile(dataFileNames[ic], verbose, "discrete channel");
                    channelFileReader.readChannel();
                    TestInfoLeak.channels[ic] = channelFileReader.getChannel();
                } else {
                    System.out.println("Commandline error: Options for channel file names are not specified correctly.");
                    System.out.println("  Number of channels specified: " + numChannels);
                    System.exit(1);
                }
                ++ic;
            }
        }
        if (readFromARFFFile && OBS_DISCRETE) {
            ARFFFile file = csvFile == null ? new ARFFFile(dataFileName, verbose) : new ARFFFile(dataFileName, verbose, csvEstimationInterval, csvFile);
            file.setTerminateWhenStabilised(terminateWhenStabilised);
            highFeatures = file.getFeatureIndices(highFeatures, highFeaturesSet);
            lowFeatures = file.getFeatureIndices(lowFeatures, lowFeaturesSet);
            if (highFeatures.size() < 1) {
                highFeatures.add(file.attributes.length - 1);
                System.out.println("Commandline option warning: -high <numbers> is missing or badly specified");
                System.out.println("Set -high " + (file.attributes.length - 1) + ".");
            }
            if (lowFeatures.size() < 1 && !checkEachFeature) {
                checkEachFeature = true;
                System.out.println("Commandline option warning: -low <numbers> is missing or badly specified");
                System.out.println("Set -low @each.");
                if (csvFile != null) {
                    System.out.println("Incremental estimations of leakage can only be calculated when reading the following file types:");
                    System.out.println("* Observations file containing discrete data");
                    System.out.println("* 2 observations files containing discrete data");
                    System.out.println("* ARFF file containing discrete data, with value of -low other than @each");
                    CommandLine.printUsage();
                    System.exit(1);
                }
            }
            if (checkEachFeature) {
                if (verbose <= 1) {
                    System.out.print("Processing attribute... ");
                } else {
                    System.out.println("");
                    System.out.println("-----------------------------------------------------------------------------");
                }
                if (lowFeatures.size() >= 1) {
                    file.printFeatures(highFeatures, lowFeatures, verbose);
                    Observations obs0 = file.obsFromARFF(highFeatures, lowFeatures);
                    if (verbose > 1) {
                        System.out.println("Calculating the channel matrix...");
                    }
                    channel = obs0.generateChannel();
                    sampleSize = obs0.getSampleCount();
                    sampleSizeGivenInput = obs0.getSampleCountGivenInput();
                    sampleSizeGivenOutput = obs0.getSampleCountGivenOutput();
                    pds = new ProbDist[1];
                    TestInfoLeak.pds[0] = obs0.getInputProbDist();
                    plv.printMeasure(taskType, pds[0], channel, obs0, priorNonUniform, checkEachFeature);
                }
                int i = 0;
                while (i < file.attributes.length) {
                    if (!highFeatures.contains(i) && !lowFeatures.contains(i)) {
                        if (verbose <= 1) {
                            if (i % 10 == 0) {
                                System.out.println("");
                            }
                            System.out.print(String.valueOf(i) + "/" + (file.attributes.length - 1) + "... ");
                        }
                        lowFeaturesNow = (TreeSet)lowFeatures.clone();
                        lowFeaturesNow.add(i);
                        if (verbose > 1) {
                            System.out.println("-----------------------------------------------------------------------------");
                        }
                        file.printFeatures(highFeatures, lowFeaturesNow, verbose);
                        Observations obs = file.obsFromARFF(highFeatures, lowFeaturesNow);
                        if (verbose > 1) {
                            System.out.println("Calculating the channel matrix...");
                        }
                        channel = obs.generateChannel();
                        sampleSize = obs.getSampleCount();
                        sampleSizeGivenInput = obs.getSampleCountGivenInput();
                        sampleSizeGivenOutput = obs.getSampleCountGivenOutput();
                        pds = new ProbDist[1];
                        TestInfoLeak.pds[0] = obs.getInputProbDist();
                        plv.printMeasure(taskType, pds[0], channel, obs, priorNonUniform, checkEachFeature);
                        name.add(file.getStringLowFeatures(lowFeaturesNow, verbose));
                    }
                    ++i;
                }
                plv.printAllResults(taskType, name);
                System.exit(0);
            } else {
                file.printFeatures(highFeatures, lowFeatures, verbose);
                obs = file.obsFromARFF(highFeatures, lowFeatures);
                if (verbose > 1) {
                    System.out.println("Calculating the channel matrix...");
                }
                channel = obs.generateChannel();
                sampleSize = obs.getSampleCount();
                sampleSizeGivenInput = obs.getSampleCountGivenInput();
                sampleSizeGivenOutput = obs.getSampleCountGivenOutput();
                pds = new ProbDist[1];
                TestInfoLeak.pds[0] = obs.getInputProbDist();
            }
        }
        if (readFromARFFFile && !OBS_DISCRETE) {
            ARFFFile file = new ARFFFile(dataFileName, verbose);
            highFeatures = file.getFeatureIndices(highFeatures, highFeaturesSet);
            lowFeatures = file.getFeatureIndices(lowFeatures, lowFeaturesSet);
            if (highFeatures.size() < 1) {
                highFeatures.add(file.attributes.length - 1);
                System.out.println("Commandline option warning: -high <numbers> is missing or badly specified");
                System.out.println("Set -high " + (file.attributes.length - 1) + ".");
            }
            if (checkEachFeature) {
                if (verbose <= 1) {
                    System.out.print("Processing attribute... ");
                } else {
                    System.out.println("");
                    System.out.println("-----------------------------------------------------------------------------");
                }
                if (lowFeatures.size() >= 1) {
                    file.printFeatures(highFeatures, lowFeatures, verbose);
                    cdata = file.cdataFromARFF(highFeatures, lowFeatures, verbose);
                    sampleSize = file.noOfTests;
                    if (cdata != null) {
                        plv.printMeasure(taskType, cdata, priorNonUniform, checkEachFeature);
                    }
                }
                int i = 0;
                while (i < file.attributes.length) {
                    if (!highFeatures.contains(i) && !lowFeatures.contains(i)) {
                        if (verbose <= 1) {
                            if (i % 10 == 0) {
                                System.out.println("");
                            }
                            System.out.print(String.valueOf(i) + "/" + (file.attributes.length - 1) + "... ");
                        }
                        lowFeaturesNow = (TreeSet)lowFeatures.clone();
                        lowFeaturesNow.add(i);
                        if (verbose > 1) {
                            System.out.println("");
                            System.out.println("-----------------------------------------------------------------------------");
                            System.out.println("-----------------------------------------------------------------------------");
                        }
                        file.printFeatures(highFeatures, lowFeaturesNow, verbose);
                        cdata = file.cdataFromARFF(highFeatures, lowFeaturesNow, verbose);
                        sampleSize = file.noOfTests;
                        if (cdata != null) {
                            plv.printMeasure(taskType, cdata, priorNonUniform, checkEachFeature);
                        }
                        name.add(file.getStringLowFeatures(lowFeaturesNow, verbose));
                    }
                    ++i;
                }
                plv.printAllResults(taskType, name);
                System.exit(0);
            } else {
                file.printFeatures(highFeatures, lowFeatures, verbose);
                cdata = file.cdataFromARFF(highFeatures, lowFeatures, verbose);
                sampleSize = file.noOfTests;
                if (cdata == null) {
                    System.exit(1);
                }
            }
        }
        if (readFromPriorFile && OBS_DISCRETE) {
            int num = 0;
            while (num < numPriors) {
                ReadFile priorFileReader = new ReadFile(priorFileNames[num], verbose, "marginal of discrete prior");
                priorFileReader.readDistribution();
                TestInfoLeak.pds[num] = priorFileReader.getDistribution();
                if (verbose >= 5) {
                    if (numPriors > 1) {
                        System.out.println("Marginals of the input distribution:");
                    } else {
                        System.out.println("Joint (prior) input distribution:");
                    }
                    pds[num].printProbDist();
                }
                ++num;
            }
        }
        if (readFromGuessFile && OBS_DISCRETE) {
            ReadFile guessFileReader = new ReadFile(guessFileName, verbose, "discrete guess");
            guessFileReader.readGuessDomain();
            guessDomain = guessFileReader.getGuessDomain();
        }
        if (debugCode) {
            if (verbose >= 5) {
                System.out.println("-------------------");
                System.out.println("Debug mode started.");
            }
            TestInfoLeak.methodForDebug();
        }
        if (OBS_DISCRETE) {
            if (pds == null) {
                pds = new ProbDist[1];
            }
            if (!compositionalEstimate) {
                if (priorShared && numChannels > 1) {
                    Channel[] channelArray = channels;
                    int n = channels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Channel ch = channelArray[n2];
                        if (pds[0].sizeSampleSpace() != ch.noOfInputs()) {
                            System.out.println("Error: The size of the (prior) input domain is larger than the channel matrix.");
                            System.out.println("  the shared input domain size: " + pds[0].sizeSampleSpace());
                            System.out.println("  the number of rows in the channel matrix: " + ch.noOfInputs());
                            System.out.println("Failed to produce a shared input probability distribution.");
                            System.exit(1);
                        }
                        ++n2;
                    }
                    if (taskType != 3) {
                        TestInfoLeak.pds[0] = pds[0].sharedProbDist(numChannels, true);
                    }
                }
                if (numChannels > 1) {
                    if (taskType == 3) {
                        CompositionalEstimate.printExactDiscreteMinEntropyLeakOnly(pds, channels, priorShared);
                    } else {
                        if (verbose >= 5) {
                            System.out.println("Calculating the composed channel...");
                        }
                        Channel channel = Channel.parallelComposition(channels);
                        plv.printMeasure(taskType, pds[0], channel, obs, priorNonUniform, checkEachFeature);
                    }
                } else if (readFromChanFile) {
                    plv.printMeasure(taskType, pds[0], channels[0], obs, priorNonUniform, checkEachFeature);
                } else {
                    plv.printMeasure(taskType, pds[0], channel, obs, priorNonUniform, checkEachFeature);
                }
            } else if (readFromChanFile || readFromObsFile) {
                if (verbose >= 5) {
                    System.out.println("Calculating bounds for the leakage measure...");
                }
                if (numChannels > 1) {
                    CompositionalEstimate.printEstimatedMeasure(taskType, pds, channels, numChannels, sampleSize, priorShared, gf, guessDomain, compositionalEstimate, approxPriorLevel, approxDoNotKnowChannels);
                } else {
                    plv.printMeasure(taskType, pds[0], channels[0], obs, priorNonUniform, checkEachFeature);
                }
            } else {
                System.out.println("Error: The specified set of options is not supported.");
                System.exit(1);
            }
        } else {
            plv.printMeasure(taskType, cdata, priorNonUniform, checkEachFeature);
        }
        if (csvFile != null) {
            csvFile.close();
        }
    }

    private static void methodForDebug() {
    }

    private static void debugStop(String msg) {
        System.out.println(" Stop at " + msg);
        try {
            BufferedReader read = new BufferedReader(new InputStreamReader(System.in));
            read.readLine();
        }
        catch (Exception ex) {
            System.out.println("In debugStop(): " + ex);
        }
    }
}

