/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest.infotheory;

import bham.leakiest.Channel;
import bham.leakiest.infotheory.InfoTheory;
import bham.leakiest.infotheory.ShannonEntropy;
import java.util.Arrays;

public class BlahutArimoto {
    private boolean verbose = false;
    private boolean displayIts = false;
    private int noOfOutputs;
    private int noOfInputs;
    private String[] inputNames;
    private String[] outputNames;
    private double[][] channelMatrix_W;
    private double acceptableError;
    private int noOfiterations;
    private double[] inputPMF_Q;
    private Channel channel;
    private double capacity;
    private double possibleError;
    private int iteration = 1;

    public BlahutArimoto(Channel channel, double[] inputPMF_Q, double acceptableError, int noOfiterations) {
        this.inputNames = channel.getInputNames();
        this.outputNames = channel.getOutputNames();
        this.channelMatrix_W = channel.getMatrix();
        this.inputPMF_Q = inputPMF_Q;
        this.acceptableError = acceptableError;
        this.noOfiterations = noOfiterations;
        this.noOfInputs = this.inputNames.length;
        this.noOfOutputs = this.outputNames.length;
        this.channel = channel;
    }

    public BlahutArimoto(Channel channel, double acceptableError, int noOfiterations) {
        this.inputNames = channel.getInputNames();
        this.outputNames = channel.getOutputNames();
        this.channelMatrix_W = channel.getMatrix();
        this.inputPMF_Q = InfoTheory.uniformDist(this.inputNames.length);
        this.acceptableError = acceptableError;
        this.noOfiterations = noOfiterations;
        this.noOfInputs = this.inputNames.length;
        this.noOfOutputs = this.outputNames.length;
        this.channel = channel;
    }

    public BlahutArimoto(String[] inputNames, String[] outputNames, double[][] channelMatrix_W, double[] inputPMF_Q, double acceptableError, int noOfiterations) {
        this.inputNames = inputNames;
        this.outputNames = outputNames;
        this.channelMatrix_W = channelMatrix_W;
        this.inputPMF_Q = inputPMF_Q;
        this.acceptableError = acceptableError;
        this.noOfiterations = noOfiterations;
        this.noOfInputs = inputNames.length;
        this.noOfOutputs = outputNames.length;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public double getPossibleError() {
        return this.possibleError;
    }

    public double getAcceptableError() {
        return this.acceptableError;
    }

    public double[] getMaxInputDist() {
        return this.inputPMF_Q;
    }

    public int getIterationCount() {
        return this.iteration;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public double calculateCapacity() {
        boolean finished = false;
        double[] newInputPMF = new double[this.noOfInputs];
        if (this.verbose && this.displayIts) {
            System.out.println("\n Channel Matix is: \n");
            this.channel.printChannel();
        }
        while (this.iteration < this.noOfiterations && !finished) {
            if (this.verbose && this.displayIts) {
                System.out.println("\n \nIteration " + this.iteration);
                System.out.print("  Trying inputPMF_Q =    ");
                InfoTheory.printPMF(this.inputNames, this.inputPMF_Q);
            }
            this.possibleError = this.calculateError(this.inputPMF_Q, this.channelMatrix_W);
            if (this.verbose && this.displayIts) {
                System.out.print("\n  Maximum possible error = " + this.possibleError);
            }
            int i = 0;
            while (i < this.noOfInputs) {
                newInputPMF[i] = this.inc_2powerT(i, this.inputPMF_Q, this.channelMatrix_W) / this.sumOfTValues(this.inputPMF_Q, this.channelMatrix_W);
                ++i;
            }
            this.capacity = ShannonEntropy.mutualInformation(this.inputPMF_Q, this.channelMatrix_W);
            if (this.verbose && this.displayIts) {
                System.out.println("\n  This input PMF give a Channel Capacity " + this.capacity);
            }
            if (Arrays.equals(this.inputPMF_Q, newInputPMF) || this.possibleError <= this.acceptableError) {
                finished = true;
                continue;
            }
            System.arraycopy(newInputPMF, 0, this.inputPMF_Q, 0, this.noOfInputs);
            ++this.iteration;
        }
        if (finished && Arrays.equals(this.inputPMF_Q, newInputPMF)) {
            this.possibleError = 0.0;
        }
        if (this.verbose) {
            if (finished && (Arrays.equals(this.inputPMF_Q, newInputPMF) || this.possibleError == 0.0)) {
                System.out.println("\n\nComplete, after " + this.iteration + " iterations");
                System.out.println("  The attacker learns: " + this.capacity + " bit of information about the users");
                System.out.println("  Capacity/log2(inputs)} is " + this.capacity / InfoTheory.log2(this.noOfInputs) + " out of 1");
            } else {
                if (this.possibleError <= this.acceptableError) {
                    System.out.println("\n\nCapacity calculated to within acceptable error, in " + this.iteration + " iterations");
                } else {
                    System.out.println("\n\nNOT COMPLETE\nPerformed the maximum number of iterations: " + this.iteration + "\n  The current results are:");
                }
                System.out.printf("  The Channel Capacity is: %1$6.5g +/- %2$6.5g\n", this.capacity + this.possibleError / 2.0, this.possibleError / 2.0);
                System.out.println("  Capacity/2^{inputs} is " + this.capacity / InfoTheory.log2(this.noOfInputs) + " out of 1");
            }
            System.out.print("  Input distribution: ");
            InfoTheory.printPMF(this.inputNames, this.inputPMF_Q);
        }
        return this.capacity;
    }

    private double inc_2powerT(int inputElement, double[] inputProbs_Q, double[][] matrix_W) {
        boolean minusinf = false;
        double sum = 0.0;
        int loopcounter = 0;
        while (loopcounter < this.noOfOutputs && !minusinf) {
            double W = matrix_W[inputElement][loopcounter];
            double logtop = inputProbs_Q[inputElement] * matrix_W[inputElement][loopcounter];
            double logbottom = InfoTheory.QW(loopcounter, inputProbs_Q, matrix_W);
            if (W != 0.0 && logtop != 0.0) {
                sum += W * InfoTheory.log2(logtop / logbottom);
            } else if (W != 0.0 && logtop == 0.0 && logbottom != 0.0) {
                minusinf = true;
            }
            ++loopcounter;
        }
        if (minusinf) {
            return 0.0;
        }
        return Math.pow(2.0, sum);
    }

    public double calculateError(double[] inputProbs_Q, double[][] matrix_W) {
        double maxTminuslogQ = 0.0;
        boolean maxTminuslogQSet = false;
        int u = 0;
        while (u < this.noOfInputs) {
            if (inputProbs_Q[u] != 0.0) {
                double T = 0.0;
                int y = 0;
                while (y < this.noOfOutputs) {
                    if (matrix_W[u][y] != 0.0) {
                        T += matrix_W[u][y] * InfoTheory.log2(inputProbs_Q[u] * matrix_W[u][y] / InfoTheory.QW(y, inputProbs_Q, matrix_W));
                    }
                    ++y;
                }
                if (maxTminuslogQSet) {
                    maxTminuslogQ = Math.max(maxTminuslogQ, T - InfoTheory.log2(inputProbs_Q[u]));
                } else {
                    maxTminuslogQ = T - InfoTheory.log2(inputProbs_Q[u]);
                    maxTminuslogQSet = true;
                }
            }
            ++u;
        }
        return maxTminuslogQ - ShannonEntropy.mutualInformation(inputProbs_Q, matrix_W);
    }

    private double sumOfTValues(double[] inputProbs_Q, double[][] matrix_W) {
        double result = 0.0;
        int i = 0;
        while (i < this.noOfInputs) {
            if (inputProbs_Q[i] != 0.0) {
                result += this.inc_2powerT(i, inputProbs_Q, matrix_W);
            }
            ++i;
        }
        return result;
    }
}

