/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.Channel;
import bham.leakiest.Observations;
import bham.leakiest.ProbDist;
import bham.leakiest.Stats;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.infotheory.BlahutArimoto;
import bham.leakiest.infotheory.InfoTheory;
import bham.leakiest.infotheory.MinEntropy;
import bham.leakiest.infotheory.ShannonEntropy;

public class Estimate {
    private static final double ERROR = -1.0;
    private static double acceptableError = TestInfoLeak.acceptableError;
    private static int noOfIterations = TestInfoLeak.noOfIterations;

    public Estimate() {
        TestInfoLeak.verbose = 0;
    }

    public Estimate(int verbose) {
        TestInfoLeak.verbose = verbose;
    }

    public static double getMutualInformation(Observations obs) {
        ProbDist pd = obs.getInputProbDist();
        Channel channel = obs.generateChannel();
        return ShannonEntropy.mutualInformation(pd, channel);
    }

    public static double getCorrectedMutualInformation(Observations obs) {
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * obs.getSampleCount()) * InfoTheory.log2(Math.E);
        return Math.max(0.0, Estimate.getMutualInformation(obs) - correction);
    }

    public static double getOldCorrectedMutualInformation(Observations obs) {
        double correction = (double)((obs.getUniqueInputCount() - 1) * (obs.getUniqueOutputCount() - 1)) / (double)(2 * obs.getSampleCount()) * InfoTheory.log2(Math.E);
        return Math.max(0.0, Estimate.getMutualInformation(obs) - correction);
    }

    protected static double VarianceOfEstimatedMIUnderEstimatedPrior(double[] pmf, double[][] W, int sampleSize) {
        double result = 0.0;
        int x = 0;
        while (x < W.length) {
            double jointProb;
            double firstPart = 0.0;
            double secondPart = 0.0;
            int y = 0;
            while (y < W[0].length) {
                if (W[x][y] != 0.0 && pmf[x] != 0.0) {
                    jointProb = pmf[x] * W[x][y];
                    firstPart += W[x][y] * Math.pow(InfoTheory.log2(jointProb / (pmf[x] * InfoTheory.outputProb(y, pmf, W))), 2.0);
                }
                ++y;
            }
            y = 0;
            while (y < W[0].length) {
                if (W[x][y] != 0.0 && pmf[x] != 0.0) {
                    jointProb = pmf[x] * W[x][y];
                    secondPart += W[x][y] * InfoTheory.log2(jointProb / (pmf[x] * InfoTheory.outputProb(y, pmf, W)));
                }
                ++y;
            }
            secondPart = Math.pow(secondPart, 2.0);
            result += pmf[x] * (firstPart - secondPart);
            ++x;
        }
        return 1.0 / (double)sampleSize * result;
    }

    public static double VarianceOfEstimatedMIUnderEstimatedPrior(ProbDist pd, Channel channel, int sampleSize) {
        double[] pmf = pd != null ? pd.probDistToPMFArray(channel.getInputNames()) : ProbDist.uniformProbArray(channel.noOfInputs());
        double[][] matrix = channel.getMatrix();
        if (pmf != null) {
            return Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pmf, matrix, sampleSize);
        }
        return -1.0;
    }

    public static double getCorrectedMutualInformationLowerBound(Observations obs) {
        ProbDist pd = obs.getInputProbDist();
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        return lower;
    }

    public static double getOldCorrectedMutualInformationLowerBound(Observations obs) {
        ProbDist pd = obs.getInputProbDist();
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        return lower;
    }

    public static double getCorrectedMutualInformationUpperBound(Observations obs) {
        ProbDist pd = obs.getInputProbDist();
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pd, channel, sampleSize);
        double upper = Stats.upperBoundNormal95(mean, variance);
        return upper;
    }

    public static double getOldCorrectedMutualInformationUpperBound(Observations obs) {
        ProbDist pd = obs.getInputProbDist();
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pd, channel, sampleSize);
        double upper = Stats.upperBoundNormal95(mean, variance);
        return upper;
    }

    public static double getCorrectedMutualInformationConfidenceInterval(Observations obs) {
        Channel channel = obs.generateChannel();
        ProbDist pd = obs.getInputProbDist();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        double upper = Stats.upperBoundNormal95(mean, variance);
        return Stats.round((upper - lower) / 2.0, 4);
    }

    public static double getOldCorrectedMutualInformationConfidenceInterval(Observations obs) {
        Channel channel = obs.generateChannel();
        ProbDist pd = obs.getInputProbDist();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        double upper = Stats.upperBoundNormal95(mean, variance);
        return Stats.round((upper - lower) / 2.0, 4);
    }

    public static double getVariance(Observations obs) {
        return Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(obs.getInputProbDist(), obs.generateChannel(), obs.getSampleCount());
    }

    public static double getUpperBoundForZeroLeakage(Observations obs) {
        if (obs.getUniqueInputCount() < 1 || obs.getUniqueOutputCount() < 1) {
            return -1.0;
        }
        return Stats.upperBoundForZero((obs.getUniqueInputCount() - 1) * (obs.getUniqueOutputCount() - 1), obs.getSampleCount());
    }

    public static double getCorrectedMutualInformationWithKnownPrior(Observations obs, ProbDist pd) {
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * obs.getSampleCount()) * InfoTheory.log2(Math.E);
        Channel channel = obs.generateChannel();
        double MI = ShannonEntropy.mutualInformation(pd, channel);
        return Math.max(0.0, MI - correction);
    }

    public static double getOldCorrectedMutualInformationWithKnownPrior(Observations obs, ProbDist pd) {
        double correction = (double)((obs.getUniqueInputCount() - 1) * (obs.getUniqueOutputCount() - 1)) / (double)(2 * obs.getSampleCount()) * InfoTheory.log2(Math.E);
        Channel channel = obs.generateChannel();
        double MI = ShannonEntropy.mutualInformation(pd, channel);
        return Math.max(0.0, MI - correction);
    }

    protected static double VarianceOfEstimatedMIUnderKnownPrior(double[] pmf, double[][] W, int sampleSize) {
        double result = 0.0;
        int x = 0;
        while (x < W.length) {
            double jointProb;
            double firstPart = 0.0;
            double secondPart = 0.0;
            int y = 0;
            while (y < W[0].length) {
                if (W[x][y] != 0.0 && pmf[x] != 0.0) {
                    jointProb = pmf[x] * W[x][y];
                    firstPart += W[x][y] * Math.pow(InfoTheory.log2(jointProb / InfoTheory.outputProb(y, pmf, W)), 2.0);
                }
                ++y;
            }
            y = 0;
            while (y < W[0].length) {
                if (W[x][y] != 0.0 && pmf[x] != 0.0) {
                    jointProb = pmf[x] * W[x][y];
                    secondPart += W[x][y] * InfoTheory.log2(jointProb / InfoTheory.outputProb(y, pmf, W));
                }
                ++y;
            }
            secondPart = Math.pow(secondPart, 2.0);
            result += pmf[x] * (firstPart - secondPart);
            ++x;
        }
        return 1.0 / (double)sampleSize * result;
    }

    public static double VarianceOfEstimatedMIUnderKnownPrior(ProbDist pd, Channel channel, int sampleSize) {
        double[] pmf = pd != null ? pd.probDistToPMFArray(channel.getInputNames()) : ProbDist.uniformProbArray(channel.noOfInputs());
        double[][] matrix = channel.getMatrix();
        if (pmf != null) {
            return Estimate.VarianceOfEstimatedMIUnderKnownPrior(pmf, matrix, sampleSize);
        }
        return -1.0;
    }

    public static double getCorrectedMILowerBoundUnderKnownPrior(Observations obs, ProbDist pd) {
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderKnownPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        return lower;
    }

    public static double getOldCorrectedMILowerBoundUnderKnownPrior(Observations obs, ProbDist pd) {
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderKnownPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        return lower;
    }

    public static double getCorrectedMIUpperBoundUnderKnownPrior(Observations obs, ProbDist pd) {
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderKnownPrior(pd, channel, sampleSize);
        double upper = Stats.upperBoundNormal95(mean, variance);
        return upper;
    }

    public static double getOldCorrectedMIUpperBoundUnderKnownPrior(Observations obs, ProbDist pd) {
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderKnownPrior(pd, channel, sampleSize);
        double upper = Stats.upperBoundNormal95(mean, variance);
        return upper;
    }

    public static double getCorrectedMIConfidenceIntervalUnderKnownPrior(Observations obs, ProbDist pd) {
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)obs.getDegreeOfFreedomMI() / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderKnownPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        double upper = Stats.upperBoundNormal95(mean, variance);
        return Stats.round((upper - lower) / 2.0, 4);
    }

    public static double getOldCorrectedMIConfidenceIntervalUnderKnownPrior(Observations obs, ProbDist pd) {
        Channel channel = obs.generateChannel();
        double result = ShannonEntropy.mutualInformation(pd, channel);
        int sampleSize = obs.getSampleCount();
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        double variance = Estimate.VarianceOfEstimatedMIUnderKnownPrior(pd, channel, sampleSize);
        double lower = Math.max(0.0, Stats.lowerBoundNormal95(mean, variance));
        double upper = Stats.upperBoundNormal95(mean, variance);
        return Stats.round((upper - lower) / 2.0, 4);
    }

    public static double getCapacity(Observations obs) {
        Channel channel = obs.generateChannel();
        BlahutArimoto ba = new BlahutArimoto(channel, acceptableError, noOfIterations);
        ba.calculateCapacity();
        double possibleError = ba.getPossibleError();
        double acceptableError = ba.getAcceptableError();
        if (possibleError <= acceptableError) {
            return ba.getCapacity();
        }
        return -1.0;
    }

    public static double[] getInputDistYieldingCapacity(Observations obs) {
        Channel channel = obs.generateChannel();
        BlahutArimoto ba = new BlahutArimoto(channel, acceptableError, noOfIterations);
        ba.calculateCapacity();
        double possibleError = ba.getPossibleError();
        double acceptableError = ba.getAcceptableError();
        if (possibleError <= acceptableError) {
            return ba.getMaxInputDist();
        }
        return null;
    }

    public static double getPossibleErrorOfCapacity(Observations obs) {
        Channel channel = obs.generateChannel();
        BlahutArimoto ba = new BlahutArimoto(channel, acceptableError, noOfIterations);
        ba.calculateCapacity();
        return ba.getPossibleError();
    }

    public static double getCorrectedCapacity(Observations obs) {
        Channel channel = obs.generateChannel();
        BlahutArimoto ba = new BlahutArimoto(channel, acceptableError, noOfIterations);
        ba.calculateCapacity();
        double possibleError = ba.getPossibleError();
        double acceptableError = ba.getAcceptableError();
        if (possibleError <= acceptableError) {
            double correction = (double)((obs.getUniqueInputCount() - 1) * (obs.getUniqueOutputCount() - 1)) / (double)(2 * obs.getSampleCount()) * InfoTheory.log2(Math.E);
            return Math.max(0.0, ba.getCapacity() - correction);
        }
        return -1.0;
    }

    public static double getMinEntropyLeak(Observations obs) {
        return MinEntropy.minEntropyLeak(InfoTheory.uniformDist(obs.getChannelMatrix().length), obs.getChannelMatrix());
    }

    public static double getMinEntropyLeakLowerBound(Observations obs) {
        return MinEntropy.minEntropyLeakLowerBoundConfidenceIntervalChiSquare(obs);
    }

    public static double getMinEntropyLeakUpperBound(Observations obs) {
        return MinEntropy.minEntropyLeakUpperBoundConfidenceIntervalChiSquare(obs);
    }

    public static double getCondMinEntropy(Observations obs) {
        return MinEntropy.conditionalMinEntropy(InfoTheory.uniformDist(obs.getChannelMatrix().length), obs.getChannelMatrix());
    }

    public static double getCondMinEntropyLowerBound(Observations obs) {
        return MinEntropy.minConditionalEntropyLowerBoundConfidenceIntervalChiSquare(obs);
    }

    public static double getCondMinEntropyUpperBound(Observations obs) {
        return MinEntropy.minConditionalEntropyUpperBoundConfidenceIntervalChiSquare(obs);
    }

    public static double getMinCapacity(Observations obs) {
        return MinEntropy.minCapacity(obs.getChannelMatrix());
    }
}

