/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class State {
    private Map<String, String> map = new TreeMap<String, String>();
    private int verbose = 3;

    public State() {
        if (this.verbose >= 5) {
            System.out.println(" A state is created.");
        }
    }

    public State(String str) {
        this.map.put(str, "input");
        if (this.verbose >= 5) {
            System.out.println(" A state is created.");
        }
    }

    public State(String[] str, String[] vals) {
        if (str.length == vals.length) {
            int i = 0;
            while (i < str.length) {
                this.map.put(str[i], vals[i]);
                ++i;
            }
            if (this.verbose >= 5) {
                System.out.println(" A state is created.");
            }
        }
    }

    public int getStatesNum() {
        Iterator<String> it = this.map.keySet().iterator();
        int counter = 0;
        while (it.hasNext()) {
            ++counter;
            it.next();
        }
        return counter;
    }

    public String[] getVars() {
        String[] vars = new String[this.getStatesNum()];
        Iterator<Map.Entry<String, String>> it = this.map.entrySet().iterator();
        int index = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> itnext = it.next();
            vars[index] = itnext.getKey();
            ++index;
        }
        return vars;
    }

    public String getValue(String var) {
        return this.map.get(var);
    }

    public void updateValue(String var, String val) {
        this.map.put(var, val);
        if (this.verbose >= 5) {
            System.out.println(" Added [" + var + "=" + val + "]");
        }
    }

    public void removeValue(String var) {
        if (this.verbose >= 5) {
            System.out.println(" Removed [" + var + "=" + this.map.get(var) + "]");
        }
        this.map.remove(var);
    }

    public boolean isEqual(State st) {
        if (this.map.size() == st.map.size()) {
            boolean equiv = true;
            Iterator<Map.Entry<String, String>> it0 = this.map.entrySet().iterator();
            Iterator<Map.Entry<String, String>> it1 = st.map.entrySet().iterator();
            while (it0.hasNext() && it1.hasNext()) {
                Map.Entry<String, String> it0next = it0.next();
                Map.Entry<String, String> it1next = it1.next();
                if (it0next.getKey() == it1next.getKey() && it0next.getValue() == it1next.getValue()) continue;
                equiv = false;
            }
            return equiv;
        }
        return false;
    }

    public String stringValue(String var) {
        return String.format("{ %s = %d }", var, this.getValue(var));
    }

    public String stringState() {
        return String.format("%s", this.map.entrySet());
    }

    public String strAll(String var) {
        if (this.verbose >= 5) {
            System.out.println(" entry: " + this.map.entrySet());
        }
        return String.format("{ %s = %d }", var, this.getValue(var));
    }

    public void printState() {
        System.out.println(" State: " + this.map.entrySet());
    }

    public void printState2() {
        Iterator<String> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            System.out.println((Object)it.next());
        }
        System.out.println(" State: " + this.map.entrySet());
    }
}

