/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest.infotheory;

import bham.leakiest.Channel;
import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.infotheory.GainFunction;
import bham.leakiest.infotheory.InfoTheory;
import java.util.Set;

public class GLeakage {
    private static int verbose = TestInfoLeak.verbose;
    public static final int base_log = 2;
    private static final int ERROR = -1;

    public static double gEntropy(double[] pmf, State[] sts, GainFunction gf, Set<String> guessDomain, String[] inputDomain) {
        double maxProb = 0.0;
        try {
            for (String guess : guessDomain) {
                try {
                    String[] guessArray = guess.split(",", 0);
                    double sum = 0.0;
                    int ix = 0;
                    while (ix < sts.length) {
                        String input = sts[ix].getValue("input");
                        sum += pmf[ix] * gf.gain(guessArray, input, guessDomain, inputDomain);
                        ++ix;
                    }
                    maxProb = Math.max(maxProb, sum);
                }
                catch (Exception ex0) {
                    System.out.println("Error in parsing an element of the guess domain: " + ex0);
                    System.out.println("  The file does not follow a guess domain file (-guess) format.");
                    System.exit(1);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error in the prior or guess domain file.");
            return -1.0;
        }
        return -InfoTheory.log(Math.min(maxProb, 1.0), 2);
    }

    public static double gEntropy(ProbDist pd, GainFunction gf, Set<String> guessDomain) {
        double[] pmf = pd.getPMFArray();
        State[] sts = pd.getStatesArray();
        String[] inputDomain = new String[pmf.length];
        int ix = 0;
        while (ix < inputDomain.length) {
            inputDomain[ix] = sts[ix].getValue("input");
            ++ix;
        }
        return GLeakage.gEntropy(pmf, sts, gf, guessDomain, inputDomain);
    }

    public static double conditionalGEntropy(double[] pmf, State[] sts, Channel channel, GainFunction gf, Set<String> guessDomain, String[] inputDomain) {
        double[][] matrix = channel.getMatrix();
        double res = 0.0;
        try {
            int iy = 0;
            while (iy < channel.getOutputNames().length) {
                double maxProb = 0.0;
                for (String guess : guessDomain) {
                    try {
                        String[] guessArray = guess.split(",", 0);
                        double sum = 0.0;
                        int ix = 0;
                        while (ix < sts.length) {
                            String input = sts[ix].getValue("input");
                            sum += pmf[ix] * matrix[ix][iy] * gf.gain(guessArray, input, guessDomain, inputDomain);
                            ++ix;
                        }
                        maxProb = Math.max(maxProb, sum);
                    }
                    catch (Exception ex0) {
                        System.out.println("Error in parsing an element of the guess domain: " + ex0);
                        System.out.println("  The file does not follow a guess domain file (-guess) format.");
                        System.exit(1);
                    }
                }
                res += maxProb;
                ++iy;
            }
        }
        catch (Exception ex) {
            System.out.println("Error in the prior or guess domain file.");
            return -1.0;
        }
        return -InfoTheory.log(Math.min(res, 1.0), 2);
    }

    public static double conditionalGEntropy(ProbDist pd, Channel channel, GainFunction gf, Set<String> guessDomain) {
        String[] inputDomain = channel.getInputNames();
        double[] pmf = pd.probDistToPMFArray(inputDomain);
        State[] sts = pd.probDistToStatesArray(inputDomain);
        return GLeakage.conditionalGEntropy(pmf, sts, channel, gf, guessDomain, inputDomain);
    }

    public static double gLeakage(ProbDist pd, Channel channel, GainFunction gf, Set<String> guessDomain) {
        String[] inputDomain = channel.getInputNames();
        double[] pmf = pd.probDistToPMFArray(inputDomain);
        State[] sts = pd.probDistToStatesArray(inputDomain);
        double gPrior = GLeakage.gEntropy(pmf, sts, gf, guessDomain, inputDomain);
        double gPosterior = GLeakage.conditionalGEntropy(pmf, sts, channel, gf, guessDomain, inputDomain);
        if (gPrior != -1.0 && gPosterior != -1.0) {
            return gPrior - gPosterior;
        }
        return -1.0;
    }
}

