/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest.infotheory;

import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.TestInfoLeak;
import java.util.ArrayList;
import java.util.Set;

public class GainFunction {
    private static int verbose = TestInfoLeak.verbose;
    private int ERROR = 1;
    private String stringGainFunction = "";
    private int nameGainFunction = 1;
    private int optionNumber = 0;
    private final int GAIN_NOT_FOUND = -1;
    private final int GAIN_ID = 1;
    private final int GAIN_DISTANCE = 10;
    private final int GAIN_BIN_GENERAL = 20;
    private final int GAIN_BIN_TWO_BLOCKS = 21;
    private final int GAIN_BIN_HAPPY = 22;
    private final int GAIN_BIN_K_TRIES = 23;
    private final int GAIN_EG_PASSWORD = 30;
    private final int GAIN_EG_LOZERE = 31;
    private final int GAIN_EG_TIGER = 32;
    private final int DISTANCE_USUAL = 1;
    private final int DISTANCE_LOZERE = 2;
    private final int METRIC_NOT_FOUND = 3;

    public GainFunction(String nameFunction) {
        this.stringGainFunction = nameFunction;
        if (nameFunction.equalsIgnoreCase("id")) {
            this.nameGainFunction = 1;
        } else if (nameFunction.equalsIgnoreCase("distance")) {
            this.nameGainFunction = 10;
        } else if (nameFunction.equalsIgnoreCase("binary")) {
            this.nameGainFunction = 20;
        } else if (nameFunction.equalsIgnoreCase("two-blocks")) {
            this.nameGainFunction = 21;
        } else if (nameFunction.equalsIgnoreCase("happy")) {
            this.nameGainFunction = 22;
        } else if (nameFunction.endsWith("-tries")) {
            try {
                this.nameGainFunction = 23;
                String[] strs = nameFunction.split("-tries");
                this.optionNumber = Integer.parseInt(strs[0]);
            }
            catch (Exception ex) {
                System.out.println("Commandline error: The number of guessing attempts is not specified correctly.");
                System.exit(1);
            }
        } else if (nameFunction.equalsIgnoreCase("eg-password")) {
            this.nameGainFunction = 30;
        } else if (nameFunction.equalsIgnoreCase("eg-lozere")) {
            this.nameGainFunction = 31;
        } else if (nameFunction.equalsIgnoreCase("eg-tiger")) {
            this.nameGainFunction = 32;
        } else {
            this.nameGainFunction = -1;
            System.out.println("Commandline error: The specified gain function is not found in the list: " + nameFunction);
            System.exit(1);
        }
        if (verbose >= 5) {
            System.out.println(" A gain function is created.");
        }
    }

    public double gain(String[] guess, String input, Set<String> guessDomain, String[] inputDomain) {
        if (guess == null) {
            System.out.println("Error in an element of the guess domain.");
            this.printGainFunctionsList();
            System.exit(1);
        }
        switch (this.nameGainFunction) {
            case 1: {
                if (guess.length != 1) break;
                return this.identityGainFunction(guess[0], input);
            }
            case 20: {
                return this.binGeneralGainFunction(guess, input);
            }
            case 23: {
                return this.binKTriesGainFunction(guess, input, this.optionNumber, inputDomain);
            }
            case 10: {
                if (guess.length != 1) break;
                return this.distanceGainFunction(guess[0], input, guessDomain, 1);
            }
            case 22: {
                if (guess.length != 1) break;
                return this.binHappyGainFunction(guess[0], input);
            }
            case 31: {
                if (guess.length != 1) break;
                return this.distanceGainFunction(guess[0], input, guessDomain, 2);
            }
            case 32: {
                if (guess.length != 1) break;
                return this.egTigerGainFunction(guess[0], input);
            }
            case -1: {
                this.printGainFunctionsList();
                System.exit(1);
            }
            default: {
                this.printGainFunctionsList();
                System.exit(1);
            }
        }
        System.out.println("Error in the guess domain file: A guess consists of more than one guesses.");
        this.printGainFunctionsList();
        return this.ERROR;
    }

    public String getNameOfGainFunction() {
        return this.stringGainFunction;
    }

    public void printGainFunctionsList() {
        System.out.println("");
        System.out.println("-------------------------------------------------------------------------");
        System.out.println("List of the gain functions available in leakiEst");
        System.out.println("  id                      identity gain function");
        System.out.println("  distance                gain function induced from distance function");
        System.out.println("  binary <block list>     general binary gain function for W := <block list>");
        System.out.println("  happy                   happy gain function");
        System.out.println("  <number>-tries          <number>-tries gain function");
        System.out.println("                          for W = { w subseteq <domain> | |w| <= <number> }");
        System.out.println("  eg-lozere               gain function for the lozere example in CSF'12");
        System.out.println("  eg-tiger                gain function for the tiger example in CSF'12");
    }

    public static boolean checkConsistency(ProbDist pd, Set<String> guessDomain) {
        int n;
        State[] sts = pd.getStatesArray();
        ArrayList<String> allGuesses = new ArrayList<String>();
        for (String str : guessDomain) {
            String[] guessArray;
            String[] stringArray = guessArray = str.split(",", 0);
            n = guessArray.length;
            int n2 = 0;
            while (n2 < n) {
                String newGuess = stringArray[n2];
                if (!allGuesses.contains(newGuess)) {
                    allGuesses.add(newGuess);
                }
                ++n2;
            }
        }
        for (String guess : allGuesses) {
            boolean consistent = false;
            State tmp = new State();
            State[] stateArray = sts;
            int n3 = sts.length;
            n = 0;
            while (n < n3) {
                State st = stateArray[n];
                try {
                    if (guess.trim().equalsIgnoreCase(st.getValue("input"))) {
                        consistent = true;
                        break;
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error in the format of the prior or guess domain file.");
                    System.exit(1);
                }
                tmp = st;
                ++n;
            }
            if (consistent) continue;
            if (verbose >= 5) {
                System.out.println("Caution: The guess is " + guess);
                System.out.println("Caution: The input is " + tmp.getValue("input") + "while the state is ");
                tmp.printState();
            }
            return false;
        }
        return true;
    }

    public double identityGainFunction(String guess, String input) {
        if (guess.equals(input)) {
            return 1.0;
        }
        return 0.0;
    }

    private double distance(String guess, String input, int metric) {
        double res = 0.0;
        switch (metric) {
            case 1: {
                res = this.distance(guess, input);
            }
            case 2: {
                res = this.distanceLozere(guess, input);
            }
            case 3: {
                this.printGainFunctionsList();
                System.exit(1);
            }
        }
        this.printGainFunctionsList();
        System.exit(1);
        return res;
    }

    private double distance(String guess, String input) {
        double w = 0.0;
        double x = 0.0;
        try {
            w = Double.parseDouble(guess);
            x = Double.parseDouble(input);
        }
        catch (Exception ex) {
            System.out.println("Commandline error: A guess or an input is not a number.");
            System.exit(1);
        }
        return Math.abs(x - w);
    }

    private double distanceLozere(String guess, String input) {
        double w = 0.0;
        double x = 0.0;
        try {
            w = Double.parseDouble(guess);
            x = Double.parseDouble(input);
        }
        catch (Exception ex) {
            System.out.println("Commandline error: A guess or an input is not a number.");
            System.exit(1);
        }
        if (x - 60.0 < w && w <= x) {
            return (x - w) / 60.0;
        }
        return 1.0;
    }

    public double distanceGainFunction(String guess, String input, Set<String> guessDomain, int metric) {
        double maxDistance = 0.0;
        for (String w : guessDomain) {
            maxDistance = Math.max(maxDistance, this.distance(w, input, metric));
        }
        double normDistance = this.distance(guess, input, metric) / maxDistance;
        return 1.0 - normDistance;
    }

    public double binGeneralGainFunction(String[] guesses, String input) {
        String[] stringArray = guesses;
        int n = guesses.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (w == input) {
                return 1.0;
            }
            ++n2;
        }
        return 0.0;
    }

    public double binHappyGainFunction(String guess, String input) {
        return 1.0;
    }

    public double binKTriesGainFunction(String[] guesses, String input, int numOfTries, String[] inputDomain) {
        if (guesses.length != numOfTries) {
            System.out.println("Error: The number of tries is incorrectly specified.");
            System.out.println("  guesses.length: " + guesses.length);
            System.out.println("  numOfTries:     " + numOfTries);
            System.exit(1);
        }
        String[] stringArray = guesses;
        int n = guesses.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (w.equals(input)) {
                return 1.0;
            }
            ++n2;
        }
        return 0.0;
    }

    public double egTigerGainFunction(String guess, String input) {
        if (guess.equals(input)) {
            return 1.0;
        }
        if (guess.equals("")) {
            return 0.5;
        }
        return 0.0;
    }
}

