/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest.infotheory;

import bham.leakiest.Channel;
import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.infotheory.InfoTheory;

public class ShannonEntropy {
    private static int verbose = TestInfoLeak.verbose;
    public static final int base_log = 2;
    private static final int ERROR = -1;

    public static double entropy(double[] pmf) {
        double result = 0.0;
        int i = 0;
        while (i < pmf.length) {
            if (pmf[i] != 0.0) {
                result += pmf[i] * InfoTheory.log(pmf[i], 2);
            }
            ++i;
        }
        return -result;
    }

    public static double entropy(ProbDist pd) {
        double result = 0.0;
        for (State st : pd.getStatesCollection()) {
            double prob = pd.getProb(st);
            if (prob == 0.0) continue;
            result += prob * InfoTheory.log(prob, 2);
        }
        return -result;
    }

    public static double H(double[] pmf) {
        return ShannonEntropy.entropy(pmf);
    }

    public static double H(ProbDist pd) {
        return ShannonEntropy.entropy(pd);
    }

    public static double conditionalEntropy(double[] pmf, double[][] matrix_W) {
        double result = 0.0;
        int i = 0;
        while (i < pmf.length) {
            int j = 0;
            while (j < matrix_W[0].length) {
                if (pmf[i] != 0.0 && matrix_W[i][j] != 0.0) {
                    result += pmf[i] * matrix_W[i][j] * InfoTheory.log(pmf[i] * matrix_W[i][j] / InfoTheory.QW(j, pmf, matrix_W), 2);
                }
                ++j;
            }
            ++i;
        }
        return -result;
    }

    public static double H(double[] pmf, double[][] W) {
        return ShannonEntropy.conditionalEntropy(pmf, W);
    }

    public static double conditionalEntropy(ProbDist pd, Channel channel) {
        double[] pmf = pd.probDistToPMFArray(channel.getInputNames());
        double[][] W = channel.getMatrix();
        if (pmf != null) {
            return ShannonEntropy.conditionalEntropy(pmf, W);
        }
        return -1.0;
    }

    public static double H(ProbDist pd, Channel channel) {
        return ShannonEntropy.conditionalEntropy(pd, channel);
    }

    public static double jointEntropy(double[][] p) {
        double result = 0.0;
        int x = 0;
        while (x < p.length) {
            int y = 0;
            while (y < p[0].length) {
                if (p[x][y] != 0.0) {
                    result += p[x][y] * InfoTheory.log(p[x][y], 2);
                }
                ++y;
            }
            ++x;
        }
        return -result;
    }

    public static double mutualInformation(double[] Q, double[][] W) {
        return ShannonEntropy.H(Q) - ShannonEntropy.conditionalEntropy(Q, W);
    }

    public static double I(double[] Q, double[][] W) {
        return ShannonEntropy.mutualInformation(Q, W);
    }

    public static double mutualInformation(ProbDist pd, Channel channel) {
        double[] Q = pd.probDistToPMFArray(channel.getInputNames());
        double[][] W = channel.getMatrix();
        if (Q != null) {
            return ShannonEntropy.mutualInformation(Q, W);
        }
        return -1.0;
    }

    public static double I(ProbDist pd, Channel channel) {
        return ShannonEntropy.mutualInformation(pd, channel);
    }

    public static double MIuniformInput(double[][] W) {
        return ShannonEntropy.mutualInformation(InfoTheory.uniformDist(W.length), W);
    }

    public static double relativeEntropy(double[] p, double[] q) throws ArithmeticException {
        double result = 0.0;
        int x = 0;
        while (x < p.length) {
            if (p[x] != 0.0) {
                if (q[x] == 0.0) {
                    throw new ArithmeticException("The Relative Entropy equals infinite");
                }
                result += p[x] * InfoTheory.log(p[x] / q[x], 2);
            }
            ++x;
        }
        return result;
    }

    public static double D(double[] p, double[] q) throws ArithmeticException {
        return ShannonEntropy.relativeEntropy(p, q);
    }

    public static double KullbackLeibler(double[] p, double[] q) throws ArithmeticException {
        return ShannonEntropy.relativeEntropy(p, q);
    }
}

