/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.CSVFile;
import bham.leakiest.ContinuousData;
import bham.leakiest.Estimate;
import bham.leakiest.Observations;
import bham.leakiest.TestInfoLeak;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ARFFFile {
    public String[] attributes;
    public int noOfTests;
    private String relation;
    private String[] featureTypes;
    private String[][] samples;
    private String fileName;
    private int verbose;
    private int csvInterval;
    private CSVFile csvFile;
    private boolean terminateWhenStabilised = false;

    public ARFFFile(String fileName, int v) {
        this.fileName = !(!fileName.startsWith("\"") && !fileName.startsWith("'") && !fileName.startsWith("`") || !fileName.endsWith("\"") && !fileName.endsWith("'") && !fileName.startsWith("`")) ? fileName.substring(1, fileName.length() - 1) : fileName;
        this.verbose = v;
        this.readAndParse();
    }

    public ARFFFile(String fileName, int v, int csvInterval, CSVFile csvFile) {
        this.fileName = !(!fileName.startsWith("\"") && !fileName.startsWith("'") && !fileName.startsWith("`") || !fileName.endsWith("\"") && !fileName.endsWith("'") && !fileName.startsWith("`")) ? fileName.substring(1, fileName.length() - 1) : fileName;
        this.verbose = v;
        this.csvInterval = csvInterval;
        this.csvFile = csvFile;
        this.readAndParse();
    }

    public void setTerminateWhenStabilised(boolean flag) {
        this.terminateWhenStabilised = flag;
        if (flag && this.verbose > 3) {
            System.out.println("Samples will stop being read when the corrected leakage value stabilises.");
        }
    }

    private void setValues(String n, ArrayList<String> attributeNames, ArrayList<String> attributeTypes, ArrayList<String[]> data) {
        this.relation = n;
        this.attributes = new String[attributeNames.size()];
        attributeNames.toArray(this.attributes);
        this.featureTypes = new String[attributeTypes.size()];
        attributeTypes.toArray(this.featureTypes);
        this.samples = new String[data.size()][this.attributes.length];
        data.toArray((T[])this.samples);
    }

    private void readAndParse() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.fileName));
            if (this.verbose > 3) {
                System.out.println("Loading data (ARFF) from " + this.fileName + " ...");
            }
            String line = this.nextNonBlankLine(reader);
            while (line != null) {
                if (!line.trim().startsWith("//") && !line.trim().startsWith("%")) break;
                line = this.nextNonBlankLine(reader);
            }
            Pattern pattern = Pattern.compile("@relation ([\\S]+)");
            Matcher matcher = pattern.matcher(line);
            String name = null;
            if (matcher.find()) {
                name = matcher.group(1).trim();
            } else {
                System.err.println("Badly formed ARFF file. Excepted this to be the relation name:" + line);
                System.exit(-1);
            }
            while (line != null) {
                if (!line.trim().startsWith("%") && !line.trim().startsWith("//")) break;
                line = this.nextNonBlankLine(reader);
            }
            line = this.nextNonBlankLine(reader);
            boolean parsingAttributes = true;
            ArrayList<String> attributeNames = new ArrayList<String>();
            ArrayList<String> attributeTypes = new ArrayList<String>();
            while (parsingAttributes) {
                pattern = Pattern.compile("@attribute ([\\S]+) ([\\S]+)");
                matcher = pattern.matcher(line);
                if (matcher.find()) {
                    attributeNames.add(matcher.group(1).trim());
                    attributeTypes.add(matcher.group(2).trim());
                    line = this.nextNonBlankLine(reader);
                    continue;
                }
                parsingAttributes = false;
            }
            line = this.nextNonBlankLine(reader);
            ArrayList<String[]> data = new ArrayList<String[]>();
            int lineCounter = 1;
            while (line != null) {
                if (!(line.trim().equalsIgnoreCase("") || line.trim().startsWith("%") || line.trim().startsWith("//"))) {
                    String[] splitedLine = this.splitLineByCommas(line);
                    if (splitedLine.length == attributeNames.size()) {
                        data.add(splitedLine);
                    } else {
                        System.out.println("File format error: there are " + splitedLine.length + " attributes in line " + lineCounter + ":");
                        System.out.println(line);
                        System.exit(-1);
                    }
                }
                line = reader.readLine();
                ++lineCounter;
            }
            this.setValues(name, attributeNames, attributeTypes, data);
        }
        catch (FileNotFoundException ex) {
            System.out.println("File not found: " + this.fileName);
            System.out.println("Failed to read ARFF file.");
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println("Error reading ARFF file " + this.fileName + ": " + ex);
            System.exit(-1);
        }
    }

    public String[][] getSamples() {
        return this.samples;
    }

    private String nextNonBlankLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line.trim().equalsIgnoreCase("") || line.trim().startsWith("//")) {
            line = reader.readLine();
        }
        return line;
    }

    private String[] splitLineByCommas(String line) {
        char[] ch = line.trim().toCharArray();
        ArrayList<String> splitedLine = new ArrayList<String>();
        boolean insideQuote = false;
        String element = "";
        int i = 0;
        while (i < ch.length) {
            if (ch[i] == '\\') {
                element = String.valueOf(element) + ch[i];
                if (++i < ch.length) {
                    element = String.valueOf(element) + ch[i];
                }
            } else if (ch[i] == '\"') {
                insideQuote = !insideQuote;
            } else if (!insideQuote && ch[i] == ',') {
                splitedLine.add(element);
                element = "";
            } else if (!insideQuote && ch[i] == ' ') {
                splitedLine.add(element);
                element = "";
            } else {
                element = String.valueOf(element) + ch[i];
            }
            ++i;
        }
        splitedLine.add(element);
        return splitedLine.toArray(new String[splitedLine.size()]);
    }

    private String sprintPad0(String str, int md_i, int md_d) {
        try {
            double d = Double.parseDouble(str);
            int len_i = String.valueOf((int)d).length();
            int len_d = str.length() - len_i;
            if (str.indexOf(".") != -1) {
                --len_d;
            }
            String ret = "";
            int i = 0;
            while (i < md_i - len_i) {
                ret = String.valueOf(ret) + "0";
                ++i;
            }
            ret = String.valueOf(ret) + str;
            i = 0;
            while (i < md_d - len_d) {
                ret = String.valueOf(ret) + "0";
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            return str;
        }
    }

    private int maxDigitsInt(int j) {
        int maxlen = 0;
        try {
            int i = 0;
            while (i < this.samples.length) {
                String sample = this.samples[i][j];
                double d = Double.parseDouble(sample);
                int len = String.valueOf((int)d).length();
                maxlen = Math.max(maxlen, len);
                ++i;
            }
            return maxlen;
        }
        catch (Exception e) {
            return maxlen;
        }
    }

    private int maxDigits(int j) {
        int maxlen = 0;
        try {
            int i = 0;
            while (i < this.samples.length) {
                String sample = this.samples[i][j];
                int len = sample.length();
                if (sample.indexOf(".") != -1) {
                    --len;
                }
                maxlen = Math.max(maxlen, len);
                ++i;
            }
            return maxlen;
        }
        catch (Exception e) {
            return maxlen;
        }
    }

    public static Observations computeObservationsFromARFF(String fileName, TreeSet<String> highFeaturesSet, TreeSet<String> lowFeaturesSet) {
        ARFFFile file = new ARFFFile(fileName, 0);
        TreeSet<Integer> highFeatures = new TreeSet<Integer>();
        highFeatures = file.getFeatureIndices(highFeatures, highFeaturesSet);
        TreeSet<Integer> lowFeatures = new TreeSet<Integer>();
        lowFeatures = file.getFeatureIndices(lowFeatures, lowFeaturesSet);
        Observations obs = file.obsFromARFF(highFeatures, lowFeatures);
        return obs;
    }

    public Observations obsFromARFF(TreeSet<Integer> inputIndexes, TreeSet<Integer> outputIndexes) {
        if (inputIndexes.size() < 1) {
            System.out.println("Commandline option error: -high <numbers> is missing or badly specified");
            System.exit(1);
        }
        if (outputIndexes.size() < 1) {
            System.out.println("Commandline option error: -low <numbers> is missing or badly specified");
            System.exit(1);
        }
        Observations obs = new Observations();
        double correctedLeakageFirstInterval = Double.NaN;
        double correctedLeakageSecondInterval = Double.NaN;
        int nextLeakageInterval = 100;
        int i = 0;
        while (i < this.samples.length) {
            String input = "";
            for (int j : inputIndexes) {
                if (j < this.attributes.length) {
                    int mdi = this.maxDigitsInt(j);
                    int mdd = this.maxDigits(j) - mdi;
                    if (input.equalsIgnoreCase("")) {
                        input = this.sprintPad0(this.samples[i][j], mdi, mdd);
                        continue;
                    }
                    input = String.valueOf(input) + "_" + this.sprintPad0(this.samples[i][j], mdi, mdd);
                    continue;
                }
                System.out.println("Commandline option error: -low " + j);
                System.out.println("  " + j + " is greater than the number of attributes.");
                System.exit(1);
            }
            if (this.verbose >= 5) {
                System.out.println("input " + input);
            }
            String output = "";
            for (int j : outputIndexes) {
                int mdi = this.maxDigitsInt(j);
                int mdd = this.maxDigits(j) - mdi;
                output = output.equalsIgnoreCase("") ? this.sprintPad0(this.samples[i][j], mdi, mdd) : String.valueOf(output) + "_" + this.sprintPad0(this.samples[i][j], mdi, mdd);
            }
            if (this.verbose >= 5) {
                System.out.println("output " + output);
            }
            obs.addObservation(input, output);
            if (this.csvInterval != 0 && (i + 1) % this.csvInterval == 0) {
                this.csvFile.addLeakageData(obs, TestInfoLeak.taskType);
            }
            if (this.terminateWhenStabilised && i + 1 == nextLeakageInterval) {
                nextLeakageInterval += 2 * (obs.getUniqueInputCount() * obs.getUniqueOutputCount());
                if (Double.isNaN(correctedLeakageFirstInterval)) {
                    correctedLeakageFirstInterval = Estimate.getCorrectedMutualInformation(obs);
                    if (this.verbose > 3) {
                        System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by > %s, checking again after %d samples\n", i + 1, correctedLeakageFirstInterval, String.valueOf(0.01), nextLeakageInterval);
                    }
                } else {
                    correctedLeakageSecondInterval = Estimate.getCorrectedMutualInformation(obs);
                    if (Math.abs(correctedLeakageSecondInterval - correctedLeakageFirstInterval) <= 0.01) {
                        if (this.verbose <= 3) break;
                        System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by <= %s, not reading any more samples\n", i + 1, correctedLeakageSecondInterval, String.valueOf(0.01));
                        break;
                    }
                    if (this.verbose > 3) {
                        System.out.printf("After %d samples: corrected leakage = %.4f bits; leakage differs by > %s, checking again after %d samples\n", i + 1, correctedLeakageSecondInterval, String.valueOf(0.01), nextLeakageInterval);
                    }
                    correctedLeakageFirstInterval = correctedLeakageSecondInterval;
                }
            }
            ++i;
        }
        return obs;
    }

    /*
     * WARNING - void declaration
     */
    public ContinuousData cdataFromARFF(TreeSet<Integer> inputIndexes, TreeSet<Integer> outputIndexes, int verbose) {
        void var8_9;
        ContinuousData cdata = new ContinuousData();
        ArrayList tmpDataList = new ArrayList();
        int outputAttribute = outputIndexes.first();
        ArrayList<String> inputNames = new ArrayList<String>();
        boolean bl = false;
        while (var8_9 < this.samples.length) {
            String input = "";
            for (int j : inputIndexes) {
                if (j < this.attributes.length) {
                    int mdi = this.maxDigitsInt(j);
                    int mdd = this.maxDigits(j) - mdi;
                    if (input.equalsIgnoreCase("")) {
                        input = this.sprintPad0(this.samples[var8_9][j], mdi, mdd);
                        continue;
                    }
                    input = String.valueOf(input) + "_" + this.sprintPad0(this.samples[var8_9][j], mdi, mdd);
                    continue;
                }
                System.out.println("Commandline option error: -low " + j);
                System.out.println("  " + j + " is greater than the number of attributes.");
                System.exit(1);
            }
            int inputIndex = 0;
            boolean foundInput = false;
            while (inputIndex < inputNames.size() && !foundInput) {
                if (((String)inputNames.get(inputIndex)).equals(input)) {
                    foundInput = true;
                    try {
                        double output = Double.parseDouble(this.samples[var8_9][outputAttribute]);
                        if (Double.isNaN(output)) {
                            System.out.println("Ignoared data: NaN (" + (int)var8_9 + ", " + outputAttribute + ")");
                            continue;
                        }
                        ((ArrayList)tmpDataList.get(inputIndex)).add(output);
                        continue;
                    }
                    catch (Exception e) {
                        if (verbose > 3) {
                            System.out.println("Error in parsing data: " + e);
                        }
                        return null;
                    }
                }
                ++inputIndex;
            }
            if (!foundInput) {
                inputNames.add(input);
                try {
                    ArrayList<Double> list = new ArrayList<Double>();
                    list.add(Double.parseDouble(this.samples[var8_9][outputAttribute]));
                    tmpDataList.add(list);
                }
                catch (Exception e) {
                    if (verbose > 3) {
                        System.out.println("Error in parsing data: " + e);
                    }
                    if (verbose > 1) {
                        System.out.println("The specified feature may not be continuous.");
                    }
                    return null;
                }
            }
            ++this.noOfTests;
            ++var8_9;
        }
        for (ArrayList arrayList : tmpDataList) {
            double[] tmp = new double[arrayList.size()];
            int i2 = 0;
            while (i2 < arrayList.size()) {
                tmp[i2] = (Double)arrayList.get(i2);
                ++i2;
            }
            cdata.DataList.add(tmp);
        }
        return cdata;
    }

    public TreeSet<Integer> getFeatureIndices(TreeSet<Integer> features, TreeSet<String> featuresSet) {
        for (String fs : featuresSet) {
            int a = 0;
            while (a < this.attributes.length) {
                if (fs.equals(this.attributes[a])) {
                    features.add(a);
                }
                ++a;
            }
        }
        return features;
    }

    protected String getStringLowFeatures(TreeSet<Integer> lowFeatures, int verbose) {
        String str = "";
        for (int atr : lowFeatures) {
            if (atr >= this.attributes.length) {
                lowFeatures.remove(atr);
                System.out.println(" Ignored commandline option: -low " + atr);
                System.out.println(" There is no attribute for number " + atr + ".");
                continue;
            }
            str = String.valueOf(str) + "  " + String.format("%d ", atr) + this.attributes[atr];
            if (verbose <= 1) continue;
            System.out.println(" " + atr + " " + this.attributes[atr]);
        }
        return str;
    }

    public void printFeatures(TreeSet<Integer> highFeatures, TreeSet<Integer> lowFeatures, int verbose) {
        if (verbose > 1) {
            System.out.println("High features: ");
        }
        for (int atr : highFeatures) {
            if (atr >= this.attributes.length) {
                highFeatures.remove(atr);
                System.out.println(" Ignored commandline option: -high " + atr);
                System.out.println("Error: There is no attribute for number " + atr + ".");
                System.exit(1);
                continue;
            }
            if (verbose <= 1) continue;
            System.out.println(" " + atr + " " + this.attributes[atr]);
        }
        if (verbose > 1) {
            System.out.println("Low features:  ");
        }
        for (int atr : lowFeatures) {
            if (atr >= this.attributes.length) {
                lowFeatures.remove(atr);
                System.out.println(" Ignored commandline option: -low " + atr);
                System.out.println(" There is no attribute for number " + atr + ".");
                continue;
            }
            if (verbose <= 1) continue;
            System.out.println(" " + atr + " " + this.attributes[atr]);
        }
        if (verbose > 1) {
            System.out.println();
        }
    }
}

