/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.Channel;
import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.infotheory.InfoTheory;
import bham.leakiest.infotheory.MinEntropy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class ApproxPrior {
    private static int verbose = TestInfoLeak.verbose;
    private static final double ERROR = -1.0;
    private static final double accuracy = 1.0E-10;
    private static State stateMinimum;
    private static State stateMaximum;
    private static double MInfMin;
    private static double MInfMax;

    private static ProbDist MInfAux(ProbDist jpd, ProbDist[] marginals, double totalOfAddedValues, int numChannels) {
        System.out.println("Joint (prior) input distribution before the modification:");
        jpd.printProbDist();
        TreeSet<Double> MInf = new TreeSet<Double>();
        double minimum = 1.0;
        double maximum = 1.0;
        State[] stateArray = jpd.getStatesArray();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State jst = stateArray[n2];
            double jprob = jpd.getProb(jst);
            if (jprob != 0.0) {
                double product = 1.0;
                int i = 0;
                while (i < numChannels) {
                    String str = jpd.getProjectedState(jst, i);
                    product *= marginals[i].getProb(str);
                    ++i;
                }
                double frac = product / jprob;
                MInf.add(frac);
                double prevMinimum = minimum;
                minimum = Math.min(minimum, frac);
                if (minimum != prevMinimum) {
                    stateMinimum = jst;
                }
                double prevMaximum = maximum;
                if ((maximum = Math.max(maximum, frac)) != prevMaximum) {
                    stateMaximum = jst;
                }
            }
            ++n2;
        }
        MInfMin = minimum;
        MInfMax = maximum;
        if (verbose >= 5) {
            System.out.println("  minimum = " + minimum);
            System.out.println("  maximum = " + maximum);
            System.out.println("  totalOfAddedValues = " + totalOfAddedValues);
        }
        int sizeSampleSpace = jpd.sizeSampleSpace();
        int sizeModifiedPrior = 0;
        double minModifiedPrior = 0.0;
        double sum = 0.0;
        int count = 0;
        Iterator iterator = MInf.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            System.out.println("  pmf[" + count + "] = " + d);
            if (sum + d <= totalOfAddedValues) {
                sum += d;
                ++count;
                continue;
            }
            sizeModifiedPrior = sizeSampleSpace - count;
            minModifiedPrior = d;
            break;
        }
        if (verbose >= 5) {
            System.out.println("  size of ModifiedPrior =                " + sizeModifiedPrior);
            System.out.println("  minimum probability of ModifiedPrior = " + minModifiedPrior);
        }
        int numAdded = 0;
        double remainingAddedValues = totalOfAddedValues;
        State[] stateArray2 = jpd.getStatesArray();
        int n3 = stateArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            State jst = stateArray2[n4];
            double jprob = jpd.getProb(jst);
            if (jprob != 0.0) {
                double product = 1.0;
                int i = 0;
                while (i < numChannels) {
                    String str = jpd.getProjectedState(jst, i);
                    product *= marginals[i].getProb(str);
                    ++i;
                }
                double frac = product / jprob;
                if (frac <= minModifiedPrior && numAdded <= sizeSampleSpace - sizeModifiedPrior && remainingAddedValues > 0.0) {
                    double newProb = Math.min(product, remainingAddedValues);
                    jpd.updateProb(jst, newProb);
                    ++numAdded;
                    remainingAddedValues -= newProb;
                    System.out.println("   = " + jprob + " => " + newProb);
                }
            }
            ++n4;
        }
        return jpd;
    }

    protected static ProbDist approxPriorSmallProbsRemoved(ProbDist pd, double sumOfSmallProbs, boolean lock) {
        HashMap<State, Double> dist = new HashMap<State, Double>();
        double[] pmf = pd.getPMFArray();
        Arrays.sort(pmf);
        int sizeModifiedPrior = 0;
        double minModifiedPrior = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < pmf.length) {
            if (sum + pmf[i] <= sumOfSmallProbs) {
                sum += pmf[i];
            } else {
                sizeModifiedPrior = pmf.length - i;
                minModifiedPrior = pmf[i];
                break;
            }
            ++i;
        }
        if (verbose >= 5) {
            System.out.println("  size of ModifiedPrior =                " + sizeModifiedPrior);
            System.out.println("  minimum probability of ModifiedPrior = " + minModifiedPrior);
        }
        int numRemoved = 0;
        for (State st : pd.getStatesCollection()) {
            double prob = pd.getProb(st);
            if (prob < minModifiedPrior && numRemoved < pmf.length - sizeModifiedPrior) {
                prob = 0.0;
                ++numRemoved;
            }
            dist.put(st, prob);
        }
        ProbDist apd = new ProbDist(dist, lock);
        return apd;
    }

    protected static ProbDist approxPriorSmallProbsRemoved(ProbDist pd, boolean lock) {
        HashMap<State, Double> dist = new HashMap<State, Double>();
        double[] pmf = pd.getPMFArray();
        double maxProb = 0.0;
        int i = 0;
        while (i < pmf.length) {
            maxProb = Math.max(maxProb, pmf[i]);
            ++i;
        }
        for (State st : pd.getStatesCollection()) {
            double prob = pd.getProb(st);
            if (prob < maxProb) {
                prob = 0.0;
            }
            dist.put(st, prob);
        }
        ProbDist apd = new ProbDist(dist, lock);
        return apd;
    }

    public static double sumOfProbsRemoved(ProbDist apd) {
        double sumOfProbs = 0.0;
        double[] dArray = apd.getPMFArray();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sumOfProbs += d;
            ++n2;
        }
        return Math.max(0.0, 1.0 - sumOfProbs);
    }

    public static double[] errorMinEntropyLeakSmallProbsRemoved(ProbDist apd, Channel[] channels, double sumOfSmallProbs) {
        double[] error = new double[2];
        error[0] = 0.0;
        double maxV = 0.0;
        Channel[] channelArray = channels;
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            maxV = Math.max(maxV, MinEntropy.conditionalVulnerability(apd, ch));
            ++n2;
        }
        if (verbose >= 5) {
            System.out.println("  sumOfSmallProbs = " + sumOfSmallProbs);
        }
        error[1] = InfoTheory.log2(1.0 + sumOfSmallProbs / maxV);
        return error;
    }

    public static double[] errorMinEntropyLeakSmallProbsRemovedNoReexecutionWithJointInput(ProbDist pd, Channel[] channels, double sumOfSmallProbs) {
        double[] error = new double[2];
        double[] V = new double[channels.length];
        double maxV = 0.0;
        int num = 0;
        while (num < channels.length) {
            V[num] = MinEntropy.conditionalVulnerability(pd, channels[num]);
            maxV = Math.max(maxV, V[num]);
            ++num;
        }
        double sum = 0.0;
        int num2 = 0;
        while (num2 < channels.length) {
            sum += InfoTheory.log2(V[num2] / (V[num2] - sumOfSmallProbs));
            ++num2;
        }
        error[0] = -sum;
        error[1] = InfoTheory.log2(maxV / (maxV - sumOfSmallProbs));
        if (verbose >= 5) {
            System.out.println("  maxOfSmallProbs = " + sumOfSmallProbs);
        }
        return error;
    }

    public static double[] errorMinEntropyLeakSmallProbsRemovedNoReexecutionWithSharedInput(ProbDist pd, Channel[] channels, double sumOfSmallProbs) {
        double[] error = new double[2];
        error[0] = 0.0;
        double maxV = 0.0;
        Channel[] channelArray = channels;
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            maxV = Math.max(maxV, MinEntropy.conditionalVulnerability(pd, ch));
            if (verbose >= 5) {
                System.out.println("  maxV            = " + maxV);
            }
            ++n2;
        }
        if (verbose >= 5) {
            System.out.println("  sumOfSmallProbs = " + sumOfSmallProbs);
        }
        error[1] = InfoTheory.log2(maxV / (maxV - sumOfSmallProbs));
        return error;
    }
}

