/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.Estimate;
import bham.leakiest.Observations;
import bham.leakiest.infotheory.MinEntropy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class CSVFile {
    private PrintWriter printOut;

    public CSVFile(File out) throws FileNotFoundException {
        if (out == null) {
            throw new FileNotFoundException("Invalid path to CSV file");
        }
        this.printOut = new PrintWriter(new FileOutputStream(out));
        this.printOut.println("Observations,Uncorrected leakage,Corrected leakage,Confidence interval lower bound,Confidence interval upper bound,Upper bound for zero leakage");
    }

    public void addLeakageData(Observations observations, int leakageType) {
        double uncorrectedLeakage = Double.NaN;
        double correctedLeakage = Double.NaN;
        double confidenceIntervalLowerBound = Double.NaN;
        double confidenceIntervalUpperBound = Double.NaN;
        double upperBoundForZeroLeakage = Double.NaN;
        boolean canCalculateUpperBound = observations.generateChannel().noOfInputs() > 1 && observations.generateChannel().noOfOutputs() > 1;
        switch (leakageType) {
            case 1: {
                uncorrectedLeakage = Estimate.getMutualInformation(observations);
                correctedLeakage = Estimate.getCorrectedMutualInformation(observations);
                confidenceIntervalLowerBound = canCalculateUpperBound ? Estimate.getCorrectedMutualInformationLowerBound(observations) : Double.NaN;
                confidenceIntervalUpperBound = canCalculateUpperBound ? Estimate.getCorrectedMutualInformationUpperBound(observations) : Double.NaN;
                upperBoundForZeroLeakage = canCalculateUpperBound ? Estimate.getUpperBoundForZeroLeakage(observations) : Double.NaN;
                break;
            }
            case 2: {
                uncorrectedLeakage = Estimate.getCapacity(observations);
                correctedLeakage = Estimate.getCorrectedCapacity(observations);
                break;
            }
            case 3: {
                boolean sufficientSamples = observations.hasSufficientSamplesForMEL();
                uncorrectedLeakage = MinEntropy.minEntropyLeak(observations.getInputProbDist(), observations.generateChannel());
                confidenceIntervalLowerBound = sufficientSamples ? Estimate.getMinEntropyLeakLowerBound(observations) : Double.NaN;
                confidenceIntervalUpperBound = sufficientSamples ? Estimate.getMinEntropyLeakUpperBound(observations) : Double.NaN;
                break;
            }
            case 4: {
                uncorrectedLeakage = Estimate.getMinCapacity(observations);
            }
        }
        if (leakageType == 1) {
            boolean canCalculateConfidenceInterval;
            boolean bl = canCalculateConfidenceInterval = confidenceIntervalLowerBound != Double.NaN && confidenceIntervalUpperBound != Double.NaN && canCalculateUpperBound && uncorrectedLeakage > upperBoundForZeroLeakage && 4 * observations.getSampleCount() > observations.getUniqueInputCount() * observations.getUniqueOutputCount();
            if (!canCalculateConfidenceInterval) {
                confidenceIntervalLowerBound = Double.NaN;
                confidenceIntervalUpperBound = Double.NaN;
            }
        }
        this.addLeakageData(observations.getSampleCount(), uncorrectedLeakage, correctedLeakage, confidenceIntervalLowerBound, confidenceIntervalUpperBound, upperBoundForZeroLeakage);
    }

    public void addLeakageData(int observations, double uncorrectedLeakage, double correctedLeakage, double confidenceIntervalLowerBound, double confidenceIntervalUpperBound, double upperBoundForZeroLeakage) {
        this.printOut.println((Double.isNaN(observations) ? "" : Integer.valueOf(observations)) + "," + (Double.isNaN(uncorrectedLeakage) ? "" : Double.valueOf(uncorrectedLeakage)) + "," + (Double.isNaN(correctedLeakage) ? "" : Double.valueOf(correctedLeakage)) + "," + (Double.isNaN(confidenceIntervalLowerBound) ? "" : Double.valueOf(confidenceIntervalLowerBound)) + "," + (Double.isNaN(confidenceIntervalUpperBound) ? "" : Double.valueOf(confidenceIntervalUpperBound)) + "," + (Double.isNaN(upperBoundForZeroLeakage) ? "" : Double.valueOf(upperBoundForZeroLeakage)));
    }

    public void close() {
        this.printOut.flush();
        this.printOut.close();
    }
}

