/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.CSVFile;
import bham.leakiest.Channel;
import bham.leakiest.ProbDist;
import bham.leakiest.ReadFile;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.infotheory.GainFunction;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.TreeSet;

public class CommandLine {
    static String version = TestInfoLeak.version;
    static final int CLC_MUTUAL_INFO = 1;
    static final int CLC_CAPACITY = 2;
    static final int CLC_MIN_ENTROPY = 3;
    static final int CLC_MIN_CAPACITY = 4;
    static final int CLC_G_LEAK = 5;
    static final int READ_CFG = -2;
    static final int READ_ERROR = -1;
    static final int READ_ARFF = 0;
    static final int READ_CH = 1;
    static final int READ_OBS1 = 2;
    static final int READ_OBS2 = 3;
    static final int READ_PRIOR = 4;
    static final int READ_GUESS = 5;
    static final double ERROR = -1.0;
    static final double UNKNOWN = -2.0;
    static final double APPROX_OPTIMIZED = 10.0;
    TreeSet<Integer> highFeatures = TestInfoLeak.highFeatures;
    TreeSet<String> highFeaturesSet = TestInfoLeak.highFeaturesSet;
    TreeSet<Integer> lowFeatures = TestInfoLeak.lowFeatures;
    TreeSet<String> lowFeaturesSet = TestInfoLeak.lowFeaturesSet;
    boolean checkEachFeature = TestInfoLeak.checkEachFeature;
    boolean readFromChanFile = TestInfoLeak.readFromChanFile;
    boolean readFromCfgFile = TestInfoLeak.readFromCfgFile;
    boolean readFromObsFile = TestInfoLeak.readFromObsFile;
    boolean readFrom2ObsFiles = TestInfoLeak.readFrom2ObsFiles;
    boolean readFromARFFFile = TestInfoLeak.readFromARFFFile;
    boolean readFromPriorFile = TestInfoLeak.readFromPriorFile;
    boolean readFromGuessFile = TestInfoLeak.readFromGuessFile;
    boolean ignoreOptionDis = TestInfoLeak.ignoreOptionDis;
    boolean ignoreOptionCfg = TestInfoLeak.ignoreOptionCfg;
    boolean ignoreOptionDir = TestInfoLeak.ignoreOptionDir;
    boolean ignoreOptionIn = TestInfoLeak.ignoreOptionIn;
    boolean ignoreOptionOut = TestInfoLeak.ignoreOptionOut;
    boolean ignoreOptionPrior = TestInfoLeak.ignoreOptionPrior;
    boolean ignoreOptionGuess = TestInfoLeak.ignoreOptionGuess;
    boolean ignoreOptionNOCR = TestInfoLeak.ignoreOptionNOCR;
    boolean ignoreOptionAPPROX = TestInfoLeak.ignoreOptionAPPROX;
    boolean ignoreOptionAJS = TestInfoLeak.ignoreOptionAJS;
    boolean ignoreOptionPM = TestInfoLeak.ignoreOptionPM;
    boolean ignoreOptionPJ = TestInfoLeak.ignoreOptionPJ;
    boolean ignoreOptionCSV = TestInfoLeak.ignoreOptionCSV;
    boolean ignoreOptionTerminate = TestInfoLeak.ignoreOptionTerminate;
    int taskType = TestInfoLeak.taskType;
    boolean compositionalEstimate = TestInfoLeak.compositionalEstimate;
    boolean priorShared = TestInfoLeak.priorShared;
    boolean skipZLT = TestInfoLeak.skipZLT;
    boolean correctLeak = TestInfoLeak.correctLeak;
    boolean correctLeakNew = TestInfoLeak.correctLeakNew;
    double approxPriorLevel = TestInfoLeak.approxPriorLevel;
    boolean approxDoNotKnowChannels = TestInfoLeak.approxDoNotKnowChannels;
    boolean checkJointlySupported = TestInfoLeak.checkJointlySupported;
    int fileType = TestInfoLeak.fileType;
    boolean OBS_DISCRETE = TestInfoLeak.OBS_DISCRETE;
    boolean debugCode = TestInfoLeak.debugCode;
    boolean PRINT_CHANNELMATRIX = TestInfoLeak.PRINT_CHANNELMATRIX;
    boolean PRINT_JOINTMATRIX = TestInfoLeak.PRINT_JOINTMATRIX;
    public int verbose = TestInfoLeak.verbose;
    double acceptableError = TestInfoLeak.acceptableError;
    int noOfIterations = TestInfoLeak.noOfIterations;
    int noOfTestsContinuous = TestInfoLeak.noOfTestsContinuous;
    protected boolean fixMeanForPassportAnalyses = TestInfoLeak.fixMeanForPassportAnalyses;
    protected boolean fixMedianForPassportAnalyses = TestInfoLeak.fixMedianForPassportAnalyses;
    int numChannels = 1;
    Channel[] channels;
    int numPriors = 1;
    ProbDist[] pds;
    String nameGainFunction;
    GainFunction gf;
    String cfgFileName = "";
    String directoryName = "";
    String dataFileName = "";
    String dataFileName2 = "";
    String[] dataFileNames;
    String[] priorFileNames;
    String guessFileName = "";
    int csvEstimationInterval = 0;
    CSVFile csvFile;
    boolean terminateWhenStabilised = false;

    public CommandLine(String[] args) {
        this.parseCommandLine(args);
    }

    public void parseCommandLine(String[] args) {
        String[] options = new String[args.length];
        if (args.length == 0 || args.length > 0 && (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("h") || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help"))) {
            CommandLine.printUsage();
            System.exit(0);
        } else if (args.length > 0 && args[0].equalsIgnoreCase("-hcomp")) {
            CommandLine.printUsageForCompositional();
            System.exit(0);
        } else if (args.length > 0 && args[0].equalsIgnoreCase("-cfg") || args[0].equalsIgnoreCase("--cfg")) {
            this.readFromCfgFile = true;
            if (args.length > 1) {
                this.cfgFileName = args[1];
                ReadFile cfgReader = new ReadFile(this.cfgFileName, this.verbose, "config");
                options = cfgReader.readConfiguration();
                this.ignoreOptionCfg = true;
            }
        } else if (args.length > 0) {
            File fl = new File(args[0]);
            if (fl.exists()) {
                this.cfgFileName = args[0];
                ReadFile cfgReader = new ReadFile(this.cfgFileName, this.verbose, "config");
                if (cfgReader.decideFileType(args[0]) == -2) {
                    options = cfgReader.readConfiguration();
                    this.ignoreOptionCfg = true;
                } else {
                    options = args;
                }
            } else {
                options = args;
            }
        } else {
            options = args;
        }
        int clc = 0;
        while (clc < options.length) {
            int n;
            int n2;
            String[] stringArray;
            if (options[clc] == null || options[clc].equalsIgnoreCase("")) {
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-cfg")) {
                System.out.println("Ignored commandline option: " + options[clc]);
                System.out.println("  -cfg <fileName> must be specified as the first option.");
                clc += 2;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-dir")) {
                if (this.ignoreOptionDir) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                } else if (clc + 1 < options.length) {
                    this.directoryName = options[clc + 1];
                }
                clc += 2;
                this.ignoreOptionDir = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-parallel")) {
                try {
                    if (this.ignoreOptionIn) {
                        System.out.print("Ignored commandline option: " + options[clc]);
                    } else {
                        this.numChannels = Integer.parseInt(options[clc + 1]);
                        this.compositionalEstimate = true;
                    }
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("Commandline error in option " + options[clc] + ".");
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-parallel-ex") || options[clc].equalsIgnoreCase("-parallel-exact")) {
                try {
                    if (this.ignoreOptionIn) {
                        System.out.print("Ignored commandline option: " + options[clc]);
                    } else {
                        this.numChannels = Integer.parseInt(options[clc + 1]);
                        this.compositionalEstimate = false;
                    }
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("Commandline error in option " + options[clc] + ".");
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-o") || options[clc].equalsIgnoreCase("-obs")) {
                if (this.ignoreOptionIn) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + this.numChannels < options.length) {
                        System.out.print(" " + options[clc + this.numChannels]);
                    }
                    System.out.println();
                } else {
                    this.readFromObsFile = true;
                    if (clc + this.numChannels < options.length) {
                        this.dataFileName = String.valueOf(this.directoryName) + options[clc + this.numChannels];
                    }
                }
                clc = clc + 1 + this.numChannels;
                this.ignoreOptionIn = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-o2") || options[clc].equalsIgnoreCase("-obs2")) {
                if (this.ignoreOptionIn) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    if (clc + 2 < options.length) {
                        System.out.print(" " + options[clc + 2]);
                    }
                    System.out.println();
                } else {
                    this.readFrom2ObsFiles = true;
                    if (clc + 1 < options.length) {
                        this.dataFileName = String.valueOf(this.directoryName) + options[clc + 1];
                    }
                    if (clc + 2 < options.length) {
                        this.dataFileName2 = String.valueOf(this.directoryName) + options[clc + 2];
                    }
                }
                clc += 3;
                this.ignoreOptionIn = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-c") || options[clc].equalsIgnoreCase("-ch")) {
                int repeate = 0;
                if (this.ignoreOptionIn) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                } else {
                    this.readFromChanFile = true;
                    this.dataFileNames = new String[this.numChannels];
                    this.channels = new Channel[this.numChannels];
                    int ic = 0;
                    while (ic < this.numChannels) {
                        if (repeate == 0 && clc + 1 + ic < options.length && !options[clc + 1 + ic].startsWith("-")) {
                            this.dataFileNames[ic] = String.valueOf(this.directoryName) + options[clc + 1 + ic];
                        } else if (ic > 0) {
                            this.dataFileNames[ic] = this.dataFileNames[ic - 1];
                            ++repeate;
                        }
                        ++ic;
                    }
                }
                clc = clc + 1 + this.numChannels - repeate;
                this.ignoreOptionIn = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-a") || options[clc].equalsIgnoreCase("-arff")) {
                if (this.ignoreOptionIn) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                } else {
                    this.readFromARFFFile = true;
                    if (clc + 1 < options.length) {
                        this.dataFileName = String.valueOf(this.directoryName) + options[clc + 1];
                    }
                }
                clc += 2;
                this.ignoreOptionIn = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-high")) {
                try {
                    String[] highFeaturesStr;
                    stringArray = highFeaturesStr = options[clc + 1].split(",");
                    n2 = highFeaturesStr.length;
                    n = 0;
                    while (n < n2) {
                        String hfs = stringArray[n];
                        try {
                            this.highFeatures.add(Integer.parseInt(hfs));
                        }
                        catch (Exception e) {
                            this.highFeaturesSet.add(hfs);
                        }
                        ++n;
                    }
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.print("Commandline error in option " + options[clc] + ".");
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-low")) {
                try {
                    String[] lowFeaturesStr;
                    stringArray = lowFeaturesStr = options[clc + 1].split(",");
                    n2 = lowFeaturesStr.length;
                    n = 0;
                    while (n < n2) {
                        String lfs = stringArray[n];
                        try {
                            if (lfs.equalsIgnoreCase("@each")) {
                                this.checkEachFeature = true;
                                break;
                            }
                            this.lowFeatures.add(Integer.parseInt(lfs));
                        }
                        catch (Exception e) {
                            this.lowFeaturesSet.add(lfs);
                        }
                        ++n;
                    }
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.print("Commandline error in option " + options[clc] + ".");
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-prior") || options[clc].equalsIgnoreCase("-prior-shared")) {
                if (this.ignoreOptionPrior) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                } else {
                    this.readFromPriorFile = true;
                    this.priorFileNames = new String[this.numPriors];
                    this.pds = new ProbDist[this.numPriors];
                    if (clc + 1 < options.length) {
                        this.priorFileNames[0] = String.valueOf(this.directoryName) + options[clc + 1];
                    }
                    if (options[clc].equalsIgnoreCase("-prior-shared")) {
                        this.priorShared = true;
                    }
                }
                clc += 2;
                this.ignoreOptionPrior = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-priors")) {
                int repeate = 0;
                if (this.ignoreOptionPrior) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                } else {
                    this.readFromPriorFile = true;
                    this.numPriors = this.numChannels;
                    this.priorFileNames = new String[this.numPriors];
                    this.pds = new ProbDist[this.numPriors];
                    int ic = 0;
                    while (ic < this.numPriors) {
                        if (repeate == 0 && clc + 1 + ic < options.length && !options[clc + 1 + ic].startsWith("-")) {
                            this.priorFileNames[ic] = String.valueOf(this.directoryName) + options[clc + 1 + ic];
                        } else if (ic > 0) {
                            this.priorFileNames[ic] = this.priorFileNames[ic - 1];
                            ++repeate;
                        }
                        ++ic;
                    }
                }
                clc = clc + 1 + this.numChannels - repeate;
                this.ignoreOptionPrior = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-guess")) {
                if (this.ignoreOptionGuess) {
                    System.out.print("Ignored commandline option: " + options[clc]);
                    if (clc + 1 < options.length) {
                        System.out.print(" " + options[clc + 1]);
                    }
                    System.out.println();
                } else {
                    this.readFromGuessFile = true;
                    if (clc + 1 < options.length) {
                        this.guessFileName = String.valueOf(this.directoryName) + options[clc + 1];
                    }
                }
                clc += 2;
                this.ignoreOptionGuess = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-ignore-hereafter")) {
                clc = options.length;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-di")) {
                if (this.ignoreOptionDis) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.OBS_DISCRETE = true;
                }
                ++clc;
                this.ignoreOptionDis = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-co")) {
                if (this.ignoreOptionDis) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.OBS_DISCRETE = false;
                }
                ++clc;
                this.ignoreOptionDis = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-mi")) {
                if (this.ignoreOptionOut) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.taskType = 1;
                }
                ++clc;
                this.ignoreOptionOut = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-cp")) {
                if (this.ignoreOptionOut) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.taskType = 2;
                }
                ++clc;
                this.ignoreOptionOut = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-me")) {
                if (this.ignoreOptionOut) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.taskType = 3;
                }
                ++clc;
                this.ignoreOptionOut = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-mc")) {
                if (this.ignoreOptionOut) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.taskType = 4;
                }
                ++clc;
                this.ignoreOptionOut = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-gl")) {
                if (this.ignoreOptionOut) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.taskType = 5;
                    if (clc + 1 < options.length) {
                        this.nameGainFunction = options[clc + 1];
                        this.gf = new GainFunction(this.nameGainFunction);
                    }
                }
                clc += 2;
                this.ignoreOptionOut = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-skipZLT")) {
                if (this.ignoreOptionNOCR) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.skipZLT = true;
                }
                ++clc;
                this.ignoreOptionNOCR = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-nocr")) {
                if (this.ignoreOptionNOCR) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.correctLeak = false;
                }
                ++clc;
                this.ignoreOptionNOCR = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-oldcr")) {
                if (this.ignoreOptionNOCR) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.correctLeak = true;
                    this.correctLeakNew = false;
                }
                ++clc;
                this.ignoreOptionNOCR = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-approx")) {
                try {
                    this.approxPriorLevel = Double.parseDouble(options[clc + 1]);
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("Commandline error in option " + options[clc] + ".");
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-approx-max")) {
                this.approxPriorLevel = 1.0;
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-approx-opt")) {
                this.approxPriorLevel = 10.0;
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-do-not-know-channel")) {
                this.approxDoNotKnowChannels = true;
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-ajs")) {
                if (this.ignoreOptionAJS) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.checkJointlySupported = false;
                }
                ++clc;
                this.ignoreOptionAJS = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-e")) {
                try {
                    this.acceptableError = Double.parseDouble(options[clc + 1]);
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("Commandline error in option " + options[clc] + ".");
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-i")) {
                try {
                    this.noOfIterations = Integer.parseInt(options[clc + 1]);
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("Commandline error in option " + options[clc] + ".");
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-testco")) {
                try {
                    this.noOfTestsContinuous = Integer.parseInt(options[clc + 1]);
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("Commandline error in option " + options[clc] + ".");
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-fixMean")) {
                this.fixMeanForPassportAnalyses = true;
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-fixMedian")) {
                this.fixMedianForPassportAnalyses = true;
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-csv")) {
                if (this.ignoreOptionCSV) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                    ++clc;
                } else {
                    try {
                        this.csvEstimationInterval = Integer.parseInt(options[clc + 1]);
                        this.csvFile = new CSVFile(new File(String.valueOf(this.directoryName) + options[clc + 2]));
                        clc += 3;
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Could not write to CSV file '" + this.directoryName + options[clc + 2] + "'.");
                        System.exit(1);
                    }
                    catch (Exception e) {
                        System.out.println("Commandline error in option " + options[clc] + ".");
                        CommandLine.printUsage();
                        System.exit(1);
                    }
                }
                this.ignoreOptionCSV = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-t")) {
                if (this.ignoreOptionTerminate) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.terminateWhenStabilised = true;
                }
                this.ignoreOptionTerminate = true;
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-p") || options[clc].equalsIgnoreCase("-pc")) {
                if (this.ignoreOptionPM) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.PRINT_CHANNELMATRIX = true;
                }
                ++clc;
                this.ignoreOptionPM = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-pj")) {
                if (this.ignoreOptionPJ) {
                    System.out.println("Ignored commandline option: " + options[clc]);
                } else {
                    this.PRINT_JOINTMATRIX = true;
                }
                ++clc;
                this.ignoreOptionPJ = true;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-v")) {
                try {
                    this.verbose = Integer.parseInt(options[clc + 1]);
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("Commandline error in option " + options[clc] + ".");
                    CommandLine.printUsage();
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-version")) {
                try {
                    this.verbose = Integer.parseInt(options[clc + 1]);
                    clc += 2;
                }
                catch (Exception e) {
                    System.out.println("leakiEst version " + version + ".");
                    System.exit(1);
                }
                continue;
            }
            if (options[clc].equalsIgnoreCase("-debug")) {
                this.debugCode = true;
                ++clc;
                continue;
            }
            if (options[clc].equalsIgnoreCase("-debug-overwrite-options")) {
                this.ignoreOptionDis = false;
                this.ignoreOptionCfg = false;
                this.ignoreOptionDir = false;
                this.ignoreOptionIn = false;
                this.ignoreOptionOut = false;
                this.ignoreOptionPrior = false;
                this.ignoreOptionGuess = false;
                this.ignoreOptionNOCR = false;
                this.ignoreOptionAPPROX = false;
                this.ignoreOptionAJS = false;
                this.ignoreOptionPM = false;
                this.ignoreOptionPJ = false;
                this.ignoreOptionCSV = false;
                this.ignoreOptionTerminate = false;
                ++clc;
                continue;
            }
            File fl = new File(options[clc]);
            if (!this.ignoreOptionIn && fl.exists()) {
                ReadFile testReader = new ReadFile(options[clc], this.verbose, "unknown");
                this.fileType = testReader.decideFileType(options[clc]);
                if ((double)this.fileType == -1.0) {
                    System.out.println("Unrecognised commandline option: " + options[clc]);
                    System.out.println("  Skipping it. Use -h or help for a list of options");
                } else {
                    this.dataFileName = options[clc];
                    this.dataFileNames = new String[1];
                    this.dataFileNames[0] = this.dataFileName;
                    this.channels = new Channel[1];
                    this.ignoreOptionIn = true;
                }
                ++clc;
                continue;
            }
            System.out.println("Unrecognised commandline option: " + options[clc]);
            System.out.println("  Skipping it. Use -h or help for a list of options");
            ++clc;
        }
        if (!(this.readFromChanFile || this.readFromObsFile || this.readFrom2ObsFiles || this.readFromARFFFile || this.dataFileName.equals(""))) {
            switch (this.fileType) {
                case 0: {
                    this.readFromARFFFile = true;
                    System.out.println("\"" + this.dataFileName + "\" is recognised as an ARFF file.");
                    break;
                }
                case 1: {
                    this.readFromChanFile = true;
                    System.out.println("\"" + this.dataFileName + "\" is recognised as a channel file.");
                    break;
                }
                case 2: {
                    this.readFromObsFile = true;
                    System.out.println("\"" + this.dataFileName + "\" is recognised as an observation file.");
                    break;
                }
                case 3: {
                    this.readFrom2ObsFiles = true;
                    System.out.println("\"" + this.dataFileName + "\" is recognised as two observation files.");
                    break;
                }
                case -1: {
                    System.out.println("Commandline error: File name is not specified.");
                    CommandLine.printUsage();
                    System.exit(1);
                }
            }
        }
        if (!this.OBS_DISCRETE && (this.taskType != 1 || this.readFromChanFile)) {
            this.OBS_DISCRETE = true;
            System.out.println("Ignored commandline option: -co");
            System.out.println("  Continuous option is valid only for mutual information");
            System.out.println("  and only with either an observation file or ARFF file.");
            System.out.println("Set commandline option: -di");
        }
        if (!this.OBS_DISCRETE) {
            this.PRINT_CHANNELMATRIX = false;
            this.PRINT_JOINTMATRIX = false;
        }
        if (!this.readFromARFFFile) {
            this.checkEachFeature = false;
        }
        if (this.readFromChanFile) {
            this.correctLeak = false;
        }
        if (this.compositionalEstimate && this.numChannels > 1 && (this.readFrom2ObsFiles || this.readFromARFFFile)) {
            System.out.println("Commandline error: Prallel composition is not supported for the options -a and -o2.");
            System.exit(1);
        }
        if (!this.compositionalEstimate && this.numPriors > 1) {
            this.compositionalEstimate = true;
            if (this.verbose >= 5) {
                System.out.println("A compositionalility result is used to obtain the exact leakage.");
            }
        }
        if (!(!this.dataFileName.equals("") || this.readFromChanFile && this.OBS_DISCRETE)) {
            System.out.println("Commandline error: File name is not specified.");
            CommandLine.printUsage();
            System.exit(1);
        }
        if (!(this.csvFile == null || this.OBS_DISCRETE && this.readFromObsFile || this.OBS_DISCRETE && this.readFrom2ObsFiles || this.OBS_DISCRETE && this.readFromARFFFile && !this.checkEachFeature)) {
            System.out.println("Incremental estimations of leakage can only be calculated when reading the following file types:");
            System.out.println("* Observations file containing discrete data");
            System.out.println("* 2 observations files containing discrete data");
            System.out.println("* ARFF file containing discrete data, with value of -low other than @each");
            CommandLine.printUsage();
            System.exit(1);
        }
        if (!(!this.terminateWhenStabilised || this.taskType == 1 && this.OBS_DISCRETE && this.readFromObsFile || this.taskType == 1 && this.OBS_DISCRETE && this.readFrom2ObsFiles || this.taskType == 1 && this.OBS_DISCRETE && this.readFromARFFFile && !this.checkEachFeature)) {
            System.out.println("Can only automatically terminate when calculating mutual information and when reading the following file types:");
            System.out.println("* Observations file containing discrete data");
            System.out.println("* 2 observations files containing discrete data");
            System.out.println("* ARFF file containing discrete data, with value of -low other than @each");
            CommandLine.printUsage();
            System.exit(1);
        }
    }

    public static void printUsage() {
        System.out.println("");
        System.out.println("-------------------------------------------------------------------------");
        System.out.println("LeakiEst");
        System.out.println("  This is a program to calculate the information leakage of a system from");
        System.out.println("  either a matrix relating the inputs and outputs, a list of observations");
        System.out.println("  of the systems, or an ARFF file.");
        System.out.println("To run type: java -jar leakiest-" + version + ".jar <configuration file name>");
        System.out.println("         or  java -jar leakiest-" + version + ".jar <options>");
        System.out.println("");
        System.out.println("[Options]");
        System.out.println("  -h, -help             output usage information");
        System.out.println("  -hcomp                output usage information on an extension to compositional reasoning");
        System.out.println("  -cfg <fileName>       read input from a configuration file <fileName>");
        System.out.println("");
        System.out.println("for inputs to the tool:");
        System.out.println("  -o, -obs <fileName>   read input from an observations file <fileName>");
        System.out.println("  -o2, -obs2 <fileName1> <fileName2>");
        System.out.println("                        read input from two observations files <fileName1> and");
        System.out.println("                        <fileName2> each recording the observation of one attribute.");
        System.out.println("  -c, -ch <fileName>    read input from a channel file <fileName>");
        System.out.println("  -a, -arff <fileName>  read input from an ARFF file <fileName>");
        System.out.println("  -high <numbers>       specify high value features");
        System.out.println("                            e.g. -high 1,3,4 -high Intent");
        System.out.println("  -low <numbers>        specify low value features");
        System.out.println("                            e.g. -low 12,13 -low @each -low 6 Total_Bytes_Allocated");
        System.out.println("  -prior <fileName>     specify an input distribution (or use uniform distribution)");
        System.out.println("  -ignore-hereafter     ignoring the rest of all options hereafter");
        System.out.println("");
        System.out.println("for leakage measures:");
        System.out.println("  -di                   use discrete data");
        System.out.println("  -co                   use continuous data");
        System.out.println("  -mi                   calculate mutual information");
        System.out.println("  -cp                   calculate capacity");
        System.out.println("  -me                   calculate min-entropy leakage");
        System.out.println("  -mc                   calculate min-capacity");
        System.out.println("");
        System.out.println("for accuracy of results:");
        System.out.println("  -skipZLT              skip the zero leakage test (only for -co -mi)");
        System.out.println("  -nocr                 do not correct the leakage value");
        System.out.println("  -oldcr                use old correction method");
        System.out.println("  -e <level>            set the acceptable error level for Blahut-Arimoto Algorithm");
        System.out.println("                            e.g. -e 0.0000001");
        System.out.println("  -i <number>           set the maximum number of interations  e.g. -i 500");
        System.out.println("  -testco <number>      set the number of zero leak tests for continuous MI  e.g. -testco 100");
        System.out.println("");
        System.out.println("for outputs of results:");
        System.out.println("  -csv <i> <fileName>   write a CSV file <fileName> containing intermediate estimations");
        System.out.println("                            of leakage, calculating the estimations at intervals of <i>");
        System.out.println("                            observations (requires one of -o, -o2, or -a with a value");
        System.out.println("                            of -low other than @each)");
        System.out.println("  -t                    terminate when the corrected leakage value stabilises (requires");
        System.out.println("                            -di, -mi, and one of -o, -o2, or -a with a value of -low");
        System.out.println("                            other than @each, and does not give an optimal result.)");
        System.out.println("  -p, -pc               print a channel matrix");
        System.out.println("  -pj                   print a joint distribution matrix");
        System.out.println("  -v <level>            set the level of information shown (0 to 5)  e.g. -v 4");
        System.out.println("  -version              print the version of this tool");
    }

    public static void printUsageForCompositional() {
        System.out.println("");
        System.out.println("-------------------------------------------------------------------------");
        System.out.println("Extension of LeakiEst to compositional reasoning");
        System.out.println("(These options are not maintained since version 1.3.0)");
        System.out.println("");
        System.out.println("[Options]");
        System.out.println("for inputs to the tool:");
        System.out.println("  -parallel <number>    calculate the leakage bounds on the parallel");
        System.out.println("                            composition of <number> channels");
        System.out.println("  -parallel-ex <number> calculate the exact leakage of the parallel");
        System.out.println("                            composition of <number> channels");
        System.out.println("  -priors <fileNames>   specify any number of independent input distributions");
        System.out.println("                            (or use uniform distribution)");
        System.out.println("  -prior-shared <fileName>  specify an input distribution (or use uniform");
        System.out.println("                            distribution) whose identical input value is shared");
        System.out.println("                            among all channels");
        System.out.println("  -approx               approximate the input distribution to calulcate a measure");
        System.out.println("  -do-not-know-channel  calculate the leakage bounds that the analyzer can obtain");
        System.out.println("                            by a compositional reasoning using the given input");
        System.out.println("                            distribution, without knowing the channels");
        System.out.println("  -ajs                  assume the input distribution is jointly supported and do");
        System.out.println("                        not check it");
        System.out.println("");
        System.out.println("for g-leakage calculation (only partially supported):");
        System.out.println("  -gl                   calculate g-leakage");
        System.out.println("  -guess <fileName>     specify a set of all possible guesses on inputs");
    }
}

