/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.ApproxPrior;
import bham.leakiest.Channel;
import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.infotheory.GLeakage;
import bham.leakiest.infotheory.GainFunction;
import bham.leakiest.infotheory.InfoTheory;
import bham.leakiest.infotheory.MinEntropy;
import java.util.ArrayList;
import java.util.Set;

public class CompositionalEstimate {
    private static final int CLC_MUTUAL_INFO = 1;
    private static final int CLC_CAPACITY = 2;
    private static final int CLC_MIN_ENTROPY = 3;
    private static final int CLC_MIN_CAPACITY = 4;
    private static final int CLC_G_LEAK = 5;
    private static final double ERROR = -1.0;
    private static final double UNKNOWN = -2.0;
    private static final double APPROX_OPTIMIZED = 10.0;
    private static final boolean readFromPriorFile = TestInfoLeak.readFromPriorFile;
    private static int verbose = TestInfoLeak.verbose;
    private static boolean PRINT_CHANNELMATRIX = TestInfoLeak.PRINT_CHANNELMATRIX;
    private static boolean PRINT_JOINTMATRIX = TestInfoLeak.PRINT_JOINTMATRIX;
    private static boolean correctLeak = TestInfoLeak.correctLeak;
    private static boolean correctLeakNew = TestInfoLeak.correctLeakNew;
    private static boolean checkJointlySupported = TestInfoLeak.checkJointlySupported;
    private static ArrayList<Double> leakage = new ArrayList();
    private static ArrayList<Double> zeroLimit = new ArrayList();
    private static ArrayList<Double> lowerLimit = new ArrayList();
    private static ArrayList<Double> upperLimit = new ArrayList();
    private static ArrayList<String> confidence = new ArrayList();
    private static int[] composedInputIndex;
    private static int[] composedOutputIndex;

    public static double HMinInf(ProbDist pd) {
        double[] pmf = pd.getPMFArray();
        double minimum = 1.0;
        double[] dArray = pmf;
        int n = pmf.length;
        int n2 = 0;
        while (n2 < n) {
            double prob = dArray[n2];
            if (prob != 0.0) {
                minimum = Math.min(minimum, prob);
            }
            ++n2;
        }
        return -InfoTheory.log2(minimum);
    }

    public static double[] MInf(ProbDist jpd, int numChannels) {
        ProbDist[] marginals = jpd.getAllMarginals();
        double minimum = 1.0;
        double maximum = 1.0;
        State[] stateArray = jpd.getStatesArray();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State jst = stateArray[n2];
            double jprob = jpd.getProb(jst);
            if (jprob != 0.0) {
                double product = 1.0;
                int i = 0;
                while (i < numChannels) {
                    String str = jpd.getProjectedState(jst, i);
                    product *= marginals[i].getProb(str);
                    ++i;
                }
                double frac = product / jprob;
                minimum = Math.min(minimum, frac);
                maximum = Math.max(maximum, frac);
            }
            ++n2;
        }
        double[] result = new double[]{Math.max(0.0, minimum), Math.max(0.0, maximum)};
        return result;
    }

    private static void initializeIndex(int size) {
        composedInputIndex = new int[size];
        composedOutputIndex = new int[size];
        int i = 0;
        while (i < composedInputIndex.length) {
            CompositionalEstimate.composedInputIndex[i] = 0;
            ++i;
        }
        i = 0;
        while (i < composedOutputIndex.length) {
            CompositionalEstimate.composedOutputIndex[i] = 0;
            ++i;
        }
    }

    private static void incrementComposedInputIndex(Channel[] channels) {
        int i = composedInputIndex.length - 1;
        while (i >= 0) {
            if (composedInputIndex[i] < channels[i].noOfInputs() - 1) {
                int n = i;
                composedInputIndex[n] = composedInputIndex[n] + 1;
                break;
            }
            CompositionalEstimate.composedInputIndex[i] = 0;
            --i;
        }
    }

    private static void incrementComposedOutputIndex(Channel[] channels) {
        int i = composedOutputIndex.length - 1;
        while (i >= 0) {
            if (composedOutputIndex[i] < channels[i].noOfOutputs() - 1) {
                int n = i;
                composedOutputIndex[n] = composedOutputIndex[n] + 1;
                break;
            }
            CompositionalEstimate.composedOutputIndex[i] = 0;
            --i;
        }
    }

    public static double HgMin(ProbDist pd, GainFunction gf, Set<String> guessDomain) {
        double[] pmf = pd.getPMFArray();
        State[] sts = pd.getStatesArray();
        String[] inputDomain = new String[pmf.length];
        int ix = 0;
        while (ix < inputDomain.length) {
            inputDomain[ix] = sts[ix].getValue("input");
            ++ix;
        }
        double minimum = 1.0;
        for (String guess : guessDomain) {
            try {
                String[] guessArray = guess.split(",", 0);
                int ix2 = 0;
                while (ix2 < sts.length) {
                    String input = sts[ix2].getValue("input");
                    double product = pmf[ix2] * gf.gain(guessArray, input, guessDomain, inputDomain);
                    if (product != 0.0) {
                        minimum = Math.min(minimum, product);
                    }
                    ++ix2;
                }
            }
            catch (Exception ex0) {
                System.out.println("Error in parsing an element of the guess domain: " + ex0);
                System.out.println("  The file does not follow a guess domain file (-guess) format.");
                System.exit(1);
            }
        }
        return -InfoTheory.log2(minimum);
    }

    public static double exactParallelMinEntropyLeak(ProbDist jpd, Channel[] channels) {
        int numRowsComposedMatrix = 1;
        int numColsComposedMatrix = 1;
        int num = 0;
        while (num < channels.length) {
            numRowsComposedMatrix *= channels[num].noOfInputs();
            numColsComposedMatrix *= channels[num].noOfOutputs();
            ++num;
        }
        String[] composedInputNames = new String[numRowsComposedMatrix];
        int i = 0;
        while (i < channels[0].noOfInputs()) {
            composedInputNames[i] = channels[0].getInputNames()[i];
            ++i;
        }
        int tmpNumRows = 1;
        int num2 = 0;
        while (num2 < channels.length - 1) {
            composedInputNames = Channel.parallelComposition(composedInputNames, channels[num2].getInputNames(), tmpNumRows *= channels[num2].noOfInputs(), channels[num2 + 1].noOfInputs(), numRowsComposedMatrix);
            ++num2;
        }
        int i2 = 0;
        while (i2 < composedInputNames.length) {
            composedInputNames[i2] = "(" + composedInputNames[i2] + ")";
            ++i2;
        }
        double[] pmf = jpd.probDistToPMFArray(composedInputNames);
        CompositionalEstimate.initializeIndex(channels.length);
        double[] maxJointCol = new double[numColsComposedMatrix];
        int colComposed = 0;
        while (colComposed < numColsComposedMatrix) {
            maxJointCol[colComposed] = 0.0;
            ++colComposed;
        }
        int rowComposed = 0;
        while (rowComposed < pmf.length) {
            int colComposed2 = 0;
            while (colComposed2 < numColsComposedMatrix) {
                double condProb = 1.0;
                int num3 = 0;
                while (num3 < channels.length) {
                    int row = composedInputIndex[num3];
                    int col = composedOutputIndex[num3];
                    condProb *= channels[num3].getMatrix()[row][col];
                    ++num3;
                }
                double jointProb = pmf[rowComposed] * condProb;
                maxJointCol[colComposed2] = Math.max(maxJointCol[colComposed2], jointProb);
                CompositionalEstimate.incrementComposedOutputIndex(channels);
                ++colComposed2;
            }
            CompositionalEstimate.incrementComposedInputIndex(channels);
            ++rowComposed;
        }
        double conditionalMinEntropy = 0.0;
        int colComposed3 = 0;
        while (colComposed3 < numColsComposedMatrix) {
            conditionalMinEntropy += maxJointCol[colComposed3];
            ++colComposed3;
        }
        conditionalMinEntropy = -InfoTheory.log2(conditionalMinEntropy);
        double result = MinEntropy.minEntropy(pmf) - conditionalMinEntropy;
        return result;
    }

    public static double exactParallelMinEntropyLeakWithSharedInput(ProbDist jpd, Channel[] channels) {
        int numColsComposedMatrix = 1;
        int num = 0;
        while (num < channels.length) {
            numColsComposedMatrix *= channels[num].noOfOutputs();
            ++num;
        }
        double[] pmf = jpd.probDistToPMFArray(channels[0].getInputNames());
        CompositionalEstimate.initializeIndex(channels.length);
        double[] maxJointCol = new double[numColsComposedMatrix];
        int colComposed = 0;
        while (colComposed < numColsComposedMatrix) {
            maxJointCol[colComposed] = 0.0;
            ++colComposed;
        }
        int row = 0;
        while (row < pmf.length) {
            int colComposed2 = 0;
            while (colComposed2 < numColsComposedMatrix) {
                double condProb = 1.0;
                int num2 = 0;
                while (num2 < channels.length) {
                    int col = composedOutputIndex[num2];
                    condProb *= channels[num2].getMatrix()[row][col];
                    ++num2;
                }
                double jointProb = pmf[row] * condProb;
                maxJointCol[colComposed2] = Math.max(maxJointCol[colComposed2], jointProb);
                CompositionalEstimate.incrementComposedOutputIndex(channels);
                ++colComposed2;
            }
            ++row;
        }
        double conditionalMinEntropy = 0.0;
        int colComposed3 = 0;
        while (colComposed3 < numColsComposedMatrix) {
            conditionalMinEntropy += maxJointCol[colComposed3];
            ++colComposed3;
        }
        conditionalMinEntropy = -InfoTheory.log2(conditionalMinEntropy);
        double result = MinEntropy.minEntropy(pmf) - conditionalMinEntropy;
        return result;
    }

    public static double[] estimateParallelMinEntropyLeak(ProbDist jpd, ProbDist apd, Channel[] channels) {
        jpd.consistentChannelsAndPrior(channels.length);
        if (channels.length == 1) {
            double MEL = MinEntropy.minEntropyLeak(jpd, channels[0]);
            double[] result = new double[]{MEL, MEL};
            return result;
        }
        if (checkJointlySupported && !jpd.isJointlySupported()) {
            System.out.println("This tool cannot estimate the measure when the input distrbution is not jointly supported.");
            System.exit(1);
        }
        double[] MInf = CompositionalEstimate.MInf(apd, channels.length);
        double MMinInf = MInf[0];
        double MMaxInf = MInf[1];
        if (verbose >= 5) {
            System.out.print("  MMinInf = " + CompositionalEstimate.toString(MMinInf));
            System.out.print("  MMaxInf = " + CompositionalEstimate.toString(MMaxInf));
        }
        double sum = 0.0;
        int size = jpd.getNumJoint();
        double[] MEL = new double[size];
        int i = 0;
        while (i < size) {
            MEL[i] = MinEntropy.minEntropyLeak(jpd.getMarginal(i), channels[i]);
            sum += MEL[i];
            ++i;
        }
        double MELMin = sum - InfoTheory.log2(MMaxInf / MMinInf);
        double MELMax = sum + InfoTheory.log2(MMaxInf / MMinInf);
        if (verbose >= 5) {
            System.out.println("  sum = " + CompositionalEstimate.toString(sum));
            System.out.print("  MMaxInf/MMinInf = " + CompositionalEstimate.toString(MMaxInf / MMinInf));
            System.out.println("  log2(MMaxInf/MMinInf) = " + CompositionalEstimate.toString(InfoTheory.log2(MMaxInf / MMinInf)));
        }
        double[] result = new double[]{Math.max(0.0, MELMin), Math.max(0.0, MELMax)};
        return result;
    }

    private static double[] estimateParallelMinEntropyLeakWithIndependentInput(ProbDist[] pds, Channel[] channels) {
        int numPriors = pds.length;
        if (numPriors == 1) {
            double MEL = MinEntropy.minEntropyLeak(pds[0], channels[0]);
            double[] result = new double[]{MEL, MEL};
            return result;
        }
        double sum = 0.0;
        int i = 0;
        while (i < numPriors) {
            sum += MinEntropy.minEntropyLeak(pds[i], channels[i]);
            ++i;
        }
        double[] result = new double[]{Math.max(0.0, sum), Math.max(0.0, sum)};
        return result;
    }

    public static double[] estimateParallelMinEntropyLeakWithSharedInput(ProbDist jpd, ProbDist apd, Channel[] channels) {
        jpd.consistentChannelsAndPrior(1);
        if (channels.length == 1) {
            double MEL = MinEntropy.minEntropyLeak(jpd, channels[0]);
            double[] result = new double[]{MEL, MEL};
            return result;
        }
        double hmin = CompositionalEstimate.HMinInf(apd);
        double hmax = MinEntropy.minEntropy(apd);
        int size = channels.length;
        double[] MEL = new double[size];
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            MEL[i] = MinEntropy.minEntropyLeak(jpd, channels[i]);
            if (verbose >= 3) {
                System.out.println("  MEL[" + i + "] = " + MEL[i]);
            }
            sum += MEL[i];
            ++i;
        }
        double MELMax = sum + (double)(channels.length - 1) * (hmin - hmax);
        if (verbose >= 5) {
            System.out.print("  sum = " + CompositionalEstimate.toString(sum));
            System.out.print("  channels.length-1 = " + (channels.length - 1));
            System.out.print("  HMinInf = " + CompositionalEstimate.toString(hmin));
            System.out.println("  Min-entropy = " + CompositionalEstimate.toString(hmax));
        }
        double[] result = new double[]{-2.0, Math.max(0.0, MELMax)};
        return result;
    }

    private static double[] estimateParallelMinEntropyLeakConfidenceIntervalVajda(double[] pmf, double[][] matrix, int noOfTests, int[] sampleSizeGivenOutput, int noOfOutputs) {
        double MELMin = 0.0;
        double MELMax = 0.0;
        double[] result = new double[]{Math.max(0.0, MELMin), Math.max(0.0, MELMax)};
        return result;
    }

    private static double[] estimateParallelMinEntropyLeakConfidenceIntervalBinomial(double[] pmf, double[][] matrix, int[] sampleSizeGivenInput) {
        double MELMin = 0.0;
        double MELMax = 0.0;
        double[] result = new double[]{Math.max(0.0, MELMin), Math.max(0.0, MELMax)};
        return result;
    }

    public static double[] estimateParallelMinCapacityWithSharedInput(Channel[] channels) {
        if (channels.length == 1) {
            double MEL = MinEntropy.minCapacity(channels[0]);
            double[] result = new double[]{MEL, MEL};
            return result;
        }
        int size = channels.length;
        double[] MC = new double[size];
        double MCMax = 0.0;
        int i = 0;
        while (i < size) {
            MC[i] = MinEntropy.minCapacity(channels[i]);
            if (verbose >= 7) {
                System.out.println("  MC[" + i + "] = " + MC[i]);
            }
            MCMax += MC[i];
            ++i;
        }
        double[] result = new double[]{-2.0, Math.max(0.0, MCMax)};
        return result;
    }

    public static double[] estimateParallelGLeakWithSharedInput(ProbDist jpd, ProbDist apd, Channel[] channels, GainFunction gf, Set<String> guessDomain) {
        jpd.consistentChannelsAndPrior(1);
        if (channels.length == 1) {
            double GL = GLeakage.gLeakage(jpd, channels[0], gf, guessDomain);
            double[] result = new double[]{GL, GL};
            return result;
        }
        double hgmin = CompositionalEstimate.HgMin(apd, gf, guessDomain);
        double hgmax = GLeakage.gEntropy(apd, gf, guessDomain);
        int size = channels.length;
        double[] GL = new double[size];
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            GL[i] = GLeakage.gLeakage(jpd, channels[i], gf, guessDomain);
            if (verbose >= 3) {
                System.out.println("  GL[" + i + "] = " + GL[i]);
            }
            sum += GL[i];
            ++i;
        }
        double GLMax = sum + (double)(channels.length - 1) * (hgmin - hgmax);
        if (verbose >= 5) {
            System.out.print("  sum = " + CompositionalEstimate.toString(sum));
            System.out.print("  channels.length-1 = " + (channels.length - 1));
            System.out.print("  HgMin = " + CompositionalEstimate.toString(hgmin));
            System.out.println("  g-entropy = " + CompositionalEstimate.toString(hgmax));
        }
        double[] result = new double[]{-2.0, Math.max(0.0, GLMax)};
        return result;
    }

    private static String toString(double d) {
        String str = new String();
        if (d == -2.0) {
            str = "UNKNOWN";
        } else if (d == -1.0) {
            str = "ERROR";
        } else {
            try {
                str = String.format("%1$6.4g", d);
            }
            catch (Exception ex) {
                System.out.println("Error in reading elements of an input to calculate a projection of a state: " + ex);
                ex.printStackTrace();
                System.out.println("  The file does not follow a prior file (-prior) format.");
                System.exit(1);
            }
        }
        return str;
    }

    public static void printEstimatedMeasure(int taskType, ProbDist[] pds, Channel[] channels, int numChannels, int sampleSize, boolean priorShared, GainFunction gf, Set<String> guessDomain, boolean compositionalEstimate, double approxPriorLevel, boolean approxDoNotKnowChannels) {
        int num = 0;
        while (num < channels.length) {
            if (PRINT_CHANNELMATRIX) {
                System.out.println("Channel [" + num + "]:");
                channels[num].printChannel();
                if (verbose > 3) {
                    System.out.println(String.valueOf(channels[num].noOfInputs()) + " inputs, " + channels[num].noOfOutputs() + " outputs and " + sampleSize + " samples.\n");
                }
            }
            if (PRINT_JOINTMATRIX) {
                if (priorShared) {
                    System.out.println("Joint distribution [" + num + "]:");
                    channels[num].printJointMatrix(pds[0]);
                    if (verbose > 3) {
                        System.out.println(String.valueOf(channels[num].noOfInputs()) + " inputs, " + channels[num].noOfOutputs() + " outputs and " + sampleSize + " samples.\n");
                    }
                } else if (channels.length == pds.length) {
                    System.out.println("Joint distribution [" + num + "]:");
                    channels[num].printJointMatrix(pds[num]);
                    if (verbose > 3) {
                        System.out.println(String.valueOf(channels[num].noOfInputs()) + " inputs, " + channels[num].noOfOutputs() + " outputs and " + sampleSize + " samples.\n");
                    }
                }
            }
            ++num;
        }
        switch (taskType) {
            case 1: {
                if (correctLeak) {
                    CompositionalEstimate.printToBeSupported("mutual information with correction");
                    break;
                }
                CompositionalEstimate.printToBeSupported("mutual information");
                break;
            }
            case 2: {
                if (correctLeak) {
                    CompositionalEstimate.printToBeSupported("capacity with correction");
                    break;
                }
                CompositionalEstimate.printToBeSupported("capacity");
                break;
            }
            case 3: {
                if (correctLeak) {
                    if (correctLeakNew) {
                        System.out.println("Using new correction method...");
                        CompositionalEstimate.printToBeSupported("min-entropy leakage with a confidence interval");
                        break;
                    }
                    System.out.println("Using old correction method...");
                    CompositionalEstimate.printToBeSupported("min-entropy leakage with a confidence interval");
                    break;
                }
                CompositionalEstimate.printEstimatedDiscreteMinEntropyLeakOnly(pds, channels, priorShared, compositionalEstimate, approxPriorLevel, approxDoNotKnowChannels);
                break;
            }
            case 4: {
                if (correctLeak) {
                    CompositionalEstimate.printToBeSupported("min-capacity with correction");
                    break;
                }
                CompositionalEstimate.printDiscreteMinCapacityOnly(channels, priorShared);
                break;
            }
            case 5: {
                CompositionalEstimate.printDiscreteGLeakageOnly(pds, channels, gf, guessDomain, priorShared, compositionalEstimate, approxPriorLevel, approxDoNotKnowChannels);
            }
        }
    }

    public static void printExactDiscreteMinEntropyLeakOnly(ProbDist[] pds, Channel[] channels, boolean priorShared) {
        double result = 0.0;
        if (readFromPriorFile) {
            result = priorShared ? CompositionalEstimate.exactParallelMinEntropyLeakWithSharedInput(pds[0], channels) : CompositionalEstimate.exactParallelMinEntropyLeak(pds[0], channels);
            if (result == -1.0) {
                System.out.printf("Error: Failed to calculate min-entropy leakage.", new Object[0]);
                return;
            }
            if (verbose == -1) {
                System.out.print(CompositionalEstimate.toString(result));
                return;
            }
            System.out.printf("Min-entropy leakage: %s", CompositionalEstimate.toString(result));
            if (verbose > 1) {
                double sum = 0.0;
                if (priorShared) {
                    sum = InfoTheory.log2(pds[0].sizeSampleSpace());
                } else {
                    ProbDist[] probDistArray = pds;
                    int n = pds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProbDist pd = probDistArray[n2];
                        sum += InfoTheory.log2(pd.sizeSampleSpace());
                        ++n2;
                    }
                }
                System.out.printf(" (out of possible %6.4g bits)\n", sum);
            }
            System.out.println();
        } else {
            int jsize = 1;
            Channel[] channelArray = channels;
            int n = channels.length;
            int pd = 0;
            while (pd < n) {
                Channel channel = channelArray[pd];
                jsize *= channel.noOfInputs();
                ++pd;
            }
            String[] jointInputNames = new String[jsize];
            int i = 0;
            while (i < jsize / channels[0].noOfInputs()) {
                int j = 0;
                while (j < channels[0].noOfInputs()) {
                    jointInputNames[i * channels[0].noOfInputs() + j] = channels[0].getInputNames()[j];
                    ++j;
                }
                ++i;
            }
            int numChannels = channels.length;
            int tmpNumRows = 1;
            int num = 0;
            while (num < numChannels - 1) {
                jointInputNames = Channel.parallelComposition(jointInputNames, channels[num + 1].getInputNames(), tmpNumRows *= channels[num].noOfInputs(), channels[num + 1].noOfInputs(), jsize);
                ++num;
            }
            int i2 = 0;
            while (i2 < jointInputNames.length) {
                jointInputNames[i2] = "(" + jointInputNames[i2] + ")";
                ++i2;
            }
            ProbDist unipd = ProbDist.uniformProbDist(jointInputNames, true);
            result = CompositionalEstimate.exactParallelMinEntropyLeak(unipd, channels);
            if (verbose == -1) {
                System.out.print(CompositionalEstimate.toString(result));
                return;
            }
            System.out.printf("Min-entropy leakage: %s ", CompositionalEstimate.toString(result));
            if (verbose > 1) {
                double sum = 0.0;
                if (priorShared) {
                    sum = InfoTheory.log2(unipd.sizeSampleSpace());
                } else {
                    ProbDist[] probDistArray = pds;
                    int n3 = pds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ProbDist pd2 = probDistArray[n4];
                        sum += InfoTheory.log2(unipd.sizeSampleSpace());
                        ++n4;
                    }
                }
                System.out.printf(" (out of possible %6.4g bits)\n", sum);
                System.out.println("  Calculated with the uniform input distribution.");
            }
            System.out.println();
        }
        leakage.add(result);
        zeroLimit.add(-1.0);
        lowerLimit.add(-2.0);
        upperLimit.add(-2.0);
        confidence.add("NOT SURE   ");
    }

    private static void printEstimatedDiscreteMinEntropyLeakOnly(ProbDist[] pds, Channel[] channels, boolean priorShared, boolean compositionalEstimate, double approxPriorLevel, boolean approxDoNotKnowChannels) {
        ProbDist apd;
        if (approxPriorLevel == 10.0) {
            double maxV = 0.0;
            Channel[] channelArray = channels;
            int n = channels.length;
            int n2 = 0;
            while (n2 < n) {
                Channel ch = channelArray[n2];
                maxV = Math.max(maxV, MinEntropy.conditionalVulnerability(pds[0], ch));
                ++n2;
            }
            approxPriorLevel = maxV / 3.0;
            if (verbose >= 5) {
                System.out.println("  approxPriorLevel (maxV/3) = " + approxPriorLevel);
            }
        }
        if (compositionalEstimate && approxPriorLevel >= 1.0) {
            apd = ApproxPrior.approxPriorSmallProbsRemoved(pds[0], true);
            approxPriorLevel = ApproxPrior.sumOfProbsRemoved(apd);
        } else if (compositionalEstimate && approxPriorLevel > 0.0) {
            apd = ApproxPrior.approxPriorSmallProbsRemoved(pds[0], approxPriorLevel, true);
            approxPriorLevel = ApproxPrior.sumOfProbsRemoved(apd);
        } else {
            apd = pds[0];
            approxPriorLevel = 0.0;
        }
        if (verbose >= 5) {
            System.out.println("  approxPriorLevel = " + approxPriorLevel);
        }
        if (!approxDoNotKnowChannels) {
            pds[0] = apd;
        }
        double[] errorApproxMeasure = new double[2];
        if (compositionalEstimate && approxPriorLevel > 0.0) {
            errorApproxMeasure = approxDoNotKnowChannels ? (priorShared ? ApproxPrior.errorMinEntropyLeakSmallProbsRemovedNoReexecutionWithSharedInput(pds[0], channels, approxPriorLevel) : ApproxPrior.errorMinEntropyLeakSmallProbsRemovedNoReexecutionWithJointInput(pds[0], channels, approxPriorLevel)) : ApproxPrior.errorMinEntropyLeakSmallProbsRemoved(pds[0], channels, approxPriorLevel);
        } else {
            errorApproxMeasure[0] = 0.0;
            errorApproxMeasure[1] = 0.0;
        }
        if (verbose >= 5) {
            System.out.printf("  errorApproxMeasure = [ %s, %s ]", CompositionalEstimate.toString(errorApproxMeasure[0]), CompositionalEstimate.toString(errorApproxMeasure[1]));
            System.out.println();
        }
        int numPrior = pds.length;
        double[] result = new double[2];
        double MELMin = 0.0;
        double MELMax = 0.0;
        if (readFromPriorFile) {
            result = priorShared ? CompositionalEstimate.estimateParallelMinEntropyLeakWithSharedInput(pds[0], apd, channels) : (numPrior > 1 ? CompositionalEstimate.estimateParallelMinEntropyLeakWithIndependentInput(pds, channels) : CompositionalEstimate.estimateParallelMinEntropyLeak(pds[0], apd, channels));
            MELMin = result[0];
            MELMax = result[1];
            if (result[0] == -1.0 || result[1] == -1.0) {
                System.out.printf("Error: Failed to calculate min-entropy leakage.", new Object[0]);
                return;
            }
            if (verbose == -1) {
                System.out.print(CompositionalEstimate.toString(MELMax + errorApproxMeasure[1]));
                return;
            }
            if (verbose >= 5) {
                System.out.println("  MELMin = " + MELMin);
                System.out.println("  MELMax = " + MELMax);
                System.out.println();
            }
            System.out.printf("Min-entropy leakage: [ %s, %s ] ", CompositionalEstimate.toString(Math.max(0.0, MELMin + errorApproxMeasure[0])), CompositionalEstimate.toString(Math.max(0.0, MELMax + errorApproxMeasure[1])));
            if (verbose > 1) {
                double sum = 0.0;
                if (priorShared) {
                    sum = InfoTheory.log2(pds[0].sizeSampleSpace());
                } else {
                    ProbDist[] probDistArray = pds;
                    int n = pds.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ProbDist pd = probDistArray[n3];
                        sum += InfoTheory.log2(pd.sizeSampleSpace());
                        ++n3;
                    }
                }
                System.out.printf(" (out of possible %6.4g bits)\n", sum);
            }
            System.out.println();
        } else {
            int jsize = 1;
            Channel[] channelArray = channels;
            int n = channels.length;
            int pd = 0;
            while (pd < n) {
                Channel channel = channelArray[pd];
                jsize *= channel.noOfInputs();
                ++pd;
            }
            String[] jointInputNames = new String[jsize];
            int i = 0;
            while (i < jsize / channels[0].noOfInputs()) {
                int j = 0;
                while (j < channels[0].noOfInputs()) {
                    jointInputNames[i * channels[0].noOfInputs() + j] = channels[0].getInputNames()[j];
                    ++j;
                }
                ++i;
            }
            int numChannels = channels.length;
            int tmpNumRows = 1;
            int num = 0;
            while (num < numChannels - 1) {
                jointInputNames = Channel.parallelComposition(jointInputNames, channels[num + 1].getInputNames(), tmpNumRows *= channels[num].noOfInputs(), channels[num + 1].noOfInputs(), jsize);
                ++num;
            }
            int i2 = 0;
            while (i2 < jointInputNames.length) {
                jointInputNames[i2] = "(" + jointInputNames[i2] + ")";
                ++i2;
            }
            ProbDist unipd = ProbDist.uniformProbDist(jointInputNames, true);
            result = CompositionalEstimate.estimateParallelMinEntropyLeak(unipd, unipd, channels);
            MELMin = result[0];
            MELMax = result[1];
            if (verbose == -1) {
                System.out.print(CompositionalEstimate.toString(MELMax));
                return;
            }
            System.out.printf("Min-entropy leakage: [ %s, %s ] ", CompositionalEstimate.toString(MELMin), CompositionalEstimate.toString(MELMax));
            if (verbose > 1) {
                double sum = 0.0;
                sum = priorShared ? InfoTheory.log2(channels[0].noOfInputs()) : InfoTheory.log2(unipd.sizeSampleSpace());
                System.out.printf(" (out of possible %6.4g bits)\n", sum);
                System.out.println("  Calculated with the uniform input distribution.");
            }
            System.out.println();
        }
        leakage.add(-2.0);
        zeroLimit.add(-1.0);
        lowerLimit.add(MELMin);
        upperLimit.add(MELMax);
        confidence.add("NOT SURE   ");
    }

    private static void printDiscreteMinCapacityOnly(Channel[] channels, boolean priorShared) {
        double[] result = new double[2];
        double MCMin = 0.0;
        double MCMax = 0.0;
        if (priorShared) {
            result = CompositionalEstimate.estimateParallelMinCapacityWithSharedInput(channels);
        }
        MCMin = result[0];
        MCMax = result[1];
        if (result[0] == -1.0 || result[1] == -1.0) {
            System.out.printf("Error: Failed to calculate min-capacity.", new Object[0]);
            return;
        }
        if (verbose == -1) {
            System.out.print(CompositionalEstimate.toString(result[1]));
            return;
        }
        System.out.printf("Min-capacity: [ %s, %s ] ", CompositionalEstimate.toString(MCMin), CompositionalEstimate.toString(MCMax));
        if (verbose > 1) {
            double sum = 0.0;
            if (priorShared) {
                sum = InfoTheory.log2(channels[0].noOfInputs());
            } else {
                Channel[] channelArray = channels;
                int n = channels.length;
                int n2 = 0;
                while (n2 < n) {
                    Channel ch = channelArray[n2];
                    sum += InfoTheory.log2(ch.noOfInputs());
                    ++n2;
                }
            }
            System.out.printf(" (out of possible %6.4g bits)\n", sum);
        }
        System.out.println();
        leakage.add(-2.0);
        zeroLimit.add(-1.0);
        lowerLimit.add(-2.0);
        upperLimit.add(MCMax);
        confidence.add("NOT SURE   ");
    }

    private static void printDiscreteGLeakageOnly(ProbDist[] pds, Channel[] channels, GainFunction gf, Set<String> guessDomain, boolean priorShared, boolean compositionalEstimate, double approxPriorLevel, boolean approxDoNotKnowChannels) {
        ProbDist apd = pds[0];
        double[] errorApproxMeasure = new double[]{0.0, 0.0};
        int numPrior = pds.length;
        Object result = new double[2];
        double GLMin = 0.0;
        double GLMax = 0.0;
        if (readFromPriorFile) {
            result = priorShared ? CompositionalEstimate.estimateParallelGLeakWithSharedInput(pds[0], apd, channels, gf, guessDomain) : (numPrior > 1 ? null : null);
            GLMin = result[0];
            GLMax = result[1];
            if (result == null || result[0] == -1.0 || result[1] == -1.0) {
                System.out.printf("Error: Failed to calculate g-leakage.", new Object[0]);
                return;
            }
            if (verbose == -1) {
                System.out.print(CompositionalEstimate.toString(GLMax + errorApproxMeasure[1]));
                return;
            }
            if (verbose >= 5) {
                System.out.println("  GLMin = " + GLMin);
                System.out.println("  GLMax = " + GLMax);
                System.out.println();
            }
            System.out.printf("g-leakage: [ %s, %s ] ", CompositionalEstimate.toString(Math.max(0.0, GLMin + errorApproxMeasure[0])), CompositionalEstimate.toString(Math.max(0.0, GLMax + errorApproxMeasure[1])));
            if (verbose > 1) {
                double sum = 0.0;
                if (priorShared) {
                    sum = InfoTheory.log2(pds[0].sizeSampleSpace());
                } else {
                    ProbDist[] probDistArray = pds;
                    int n = pds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProbDist pd = probDistArray[n2];
                        sum += InfoTheory.log2(pd.sizeSampleSpace());
                        ++n2;
                    }
                }
                System.out.printf(" (out of possible %6.4g bits)\n", sum);
            }
            System.out.println();
        } else {
            int jsize = 1;
            Channel[] channelArray = channels;
            int n = channels.length;
            int pd = 0;
            while (pd < n) {
                Channel channel = channelArray[pd];
                jsize *= channel.noOfInputs();
                ++pd;
            }
            String[] jointInputNames = new String[jsize];
            int i = 0;
            while (i < jsize / channels[0].noOfInputs()) {
                int j = 0;
                while (j < channels[0].noOfInputs()) {
                    jointInputNames[i * channels[0].noOfInputs() + j] = channels[0].getInputNames()[j];
                    ++j;
                }
                ++i;
            }
            int numChannels = channels.length;
            int tmpNumRows = 1;
            int num = 0;
            while (num < numChannels - 1) {
                jointInputNames = Channel.parallelComposition(jointInputNames, channels[num + 1].getInputNames(), tmpNumRows *= channels[num].noOfInputs(), channels[num + 1].noOfInputs(), jsize);
                ++num;
            }
            int i2 = 0;
            while (i2 < jointInputNames.length) {
                jointInputNames[i2] = "(" + jointInputNames[i2] + ")";
                ++i2;
            }
            ProbDist unipd = ProbDist.uniformProbDist(jointInputNames, true);
            result = CompositionalEstimate.estimateParallelMinEntropyLeak(unipd, unipd, channels);
            GLMin = result[0];
            GLMax = result[1];
            if (verbose == -1) {
                System.out.print(CompositionalEstimate.toString(GLMax));
                return;
            }
            System.out.printf("g-leakage: [ %s, %s ] ", CompositionalEstimate.toString(GLMin), CompositionalEstimate.toString(GLMax));
            if (verbose > 1) {
                System.out.printf(" (out of possible %6.4g bits)\n", InfoTheory.log2(unipd.sizeSampleSpace()));
                System.out.println("  Calculated with the uniform input distribution.");
            }
            System.out.println();
        }
        leakage.add(-2.0);
        zeroLimit.add(-1.0);
        lowerLimit.add(GLMin);
        upperLimit.add(GLMax);
        confidence.add("NOT SURE   ");
    }

    private static void printToBeSupported(String comment) {
        System.out.print("This functionality is not supported.");
        System.out.println("  (" + comment + ")");
    }
}

