/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.TestInfoLeak;
import bham.leakiest.infotheory.InfoTheory;
import bham.leakiest.infotheory.RandomSample;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class ContinuousData {
    public ArrayList<double[]> DataList = new ArrayList();
    public int testSize = TestInfoLeak.noOfTestsContinuous;
    String obsFile1;
    String obsFile2;
    private int verbose = 5;

    public ContinuousData(String dataFileName1, String dataFileName2) {
        this.obsFile1 = dataFileName1;
        this.obsFile2 = dataFileName2;
    }

    public ContinuousData() {
    }

    public void setVerbose(int v) {
        this.verbose = v;
    }

    public double[] loadData(String fileName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = reader.readLine();
        Vector<Double> fileData = new Vector<Double>();
        while (line != null) {
            fileData.add(Double.parseDouble(line));
            line = reader.readLine();
        }
        int Count = fileData.size();
        double[] Data = new double[Count];
        int i = 0;
        while (i < Count) {
            Data[i] = (Double)fileData.get(i);
            ++i;
        }
        reader.close();
        return Data;
    }

    public ArrayList<double[]> selectShuffled(double[] inputDist) {
        ArrayList shuffledDataLists = new ArrayList();
        int x = 0;
        while (x < this.DataList.size()) {
            ArrayList ald = new ArrayList();
            shuffledDataLists.add(ald);
            ++x;
        }
        if (inputDist.length != this.DataList.size()) {
            System.out.println("ERROR: The sizes of the input distribution and the data lists  are different:");
            System.out.println("  inputDist.length = " + inputDist.length);
            System.out.println("  DataList.size()  = " + this.DataList.size());
            System.exit(1);
        }
        RandomSample rs = new RandomSample(inputDist);
        int x2 = 0;
        while (x2 < this.DataList.size()) {
            int j = 0;
            while (j < this.DataList.get(x2).length) {
                int highValue = rs.indexOfValueDrawnFrom();
                ((ArrayList)shuffledDataLists.get(highValue)).add(this.DataList.get(x2)[j]);
                ++j;
            }
            ++x2;
        }
        ArrayList<double[]> result = new ArrayList<double[]>();
        int x3 = 0;
        while (x3 < this.DataList.size()) {
            double[] data = new double[((ArrayList)shuffledDataLists.get(x3)).size()];
            int j = 0;
            while (j < ((ArrayList)shuffledDataLists.get(x3)).size()) {
                data[j] = (Double)((ArrayList)shuffledDataLists.get(x3)).get(j);
                ++j;
            }
            result.add(data);
            ++x3;
        }
        return result;
    }

    public void fixedMeans(double[] Data1, double[] Data2) {
        double mean2;
        double mean1 = InfoTheory.mean(Data1);
        if (mean1 - (mean2 = InfoTheory.mean(Data2)) > 0.0) {
            double difference = mean1 - mean2;
            int i = 0;
            while (i < Data2.length) {
                int n = i++;
                Data2[n] = Data2[n] + difference;
            }
        } else {
            double difference = mean2 - mean1;
            int i = 0;
            while (i < Data1.length) {
                int n = i++;
                Data1[n] = Data1[n] + difference;
            }
        }
    }

    public void fixedMedians(double[] Data1, double[] Data2) {
        double median2;
        double median1 = InfoTheory.median(Data1);
        if (median1 - (median2 = InfoTheory.median(Data2)) > 0.0) {
            double difference = median1 - median2;
            int i = 0;
            while (i < Data2.length) {
                int n = i++;
                Data2[n] = Data2[n] + difference;
            }
        } else {
            double difference = median2 - median1;
            int i = 0;
            while (i < Data1.length) {
                int n = i++;
                Data1[n] = Data1[n] + difference;
            }
        }
    }

    public void printData() {
        int i = 0;
        while (i < this.DataList.size()) {
            System.out.println(" i = " + i);
            int j = 0;
            while (j < this.DataList.get(i).length) {
                System.out.println(String.valueOf(j) + " " + this.DataList.get(i)[j]);
                ++j;
            }
            System.out.println("-----------");
            ++i;
        }
    }
}

