/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.Channel;
import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.Stats;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.comparator.ComparatorStringWithInt;
import bham.leakiest.comparator.Pair;
import bham.leakiest.infotheory.MinEntropy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class Observations {
    private double Z = 2.34;
    private static int verbose = TestInfoLeak.verbose;
    double certainty = 0.999;
    private int noOfInputs = 0;
    private int noOfOutputs = 0;
    private LinkedHashMap<String, Integer> inputsSeen = new LinkedHashMap();
    private LinkedHashMap<String, Integer> outputsSeen = new LinkedHashMap();
    private int noOfSamples = 0;
    private int noOfSamplesCached = 0;
    int[] sampleCountGivenInput;
    int[] sampleCountGivenOutput;
    private LinkedHashMap<String, LinkedHashMap<String, Integer>> matrixMap = new LinkedHashMap();
    private int[][] observationsMatrix;
    private int[] inputObservationsArray;
    private int[] outputObservationsArray;
    private double[][] channelMatrix = new double[0][0];
    private ArrayList<Pair<String, Integer>> outputNamesSorted = new ArrayList();
    private final boolean sortOutputsDouble = true;
    private boolean sortOutputsDoubleDone = false;

    public void addObservation(String input, String output) {
        ++this.noOfSamples;
        Integer currentInputsSeen = this.inputsSeen.get(input);
        if (currentInputsSeen == null) {
            ++this.noOfInputs;
            this.inputsSeen.put(input, 1);
            LinkedHashMap<String, Integer> newOutputMap = new LinkedHashMap<String, Integer>();
            newOutputMap.put(output, 1);
            this.matrixMap.put(input, newOutputMap);
        } else {
            this.inputsSeen.put(input, currentInputsSeen + 1);
            LinkedHashMap<String, Integer> matrixMapForInput = this.matrixMap.get(input);
            Integer currentOutputsForInput = matrixMapForInput.get(output);
            if (currentOutputsForInput == null) {
                matrixMapForInput.put(output, 1);
            } else {
                matrixMapForInput.put(output, currentOutputsForInput + 1);
            }
        }
        Integer currentOutputsSeen = this.outputsSeen.get(output);
        if (currentOutputsSeen == null) {
            this.outputsSeen.put(output, 1);
            ++this.noOfOutputs;
        } else {
            this.outputsSeen.put(output, currentOutputsSeen + 1);
        }
    }

    public double[][] getChannelMatrix() {
        if (this.noOfSamplesCached == this.noOfSamples) {
            return this.channelMatrix;
        }
        this.generateMatrix();
        this.noOfSamplesCached = this.noOfSamples;
        return this.channelMatrix;
    }

    public int getSampleCount() {
        return this.noOfSamples;
    }

    public int[] getSampleCountGivenInput() {
        return this.sampleCountGivenInput;
    }

    public int[] getSampleCountGivenOutput() {
        return this.sampleCountGivenOutput;
    }

    public int getDegreeOfFreedomMI() {
        int col;
        if (this.observationsMatrix == null) {
            this.observationsMatrix = this.getObservationsMatrix();
        }
        int counterJoint = 0;
        int row = 0;
        while (row < this.observationsMatrix.length) {
            int col2 = 0;
            while (col2 < this.observationsMatrix[0].length) {
                if (this.observationsMatrix[row][col2] != 0) {
                    ++counterJoint;
                }
                ++col2;
            }
            ++row;
        }
        int counterInput = 0;
        int row2 = 0;
        while (row2 < this.observationsMatrix.length) {
            col = 0;
            while (col < this.observationsMatrix[0].length) {
                if (this.observationsMatrix[row2][col] != 0) {
                    ++counterInput;
                    break;
                }
                ++col;
            }
            ++row2;
        }
        int counterOutput = 0;
        col = 0;
        while (col < this.observationsMatrix[0].length) {
            int row3 = 0;
            while (row3 < this.observationsMatrix.length) {
                if (this.observationsMatrix[row3][col] != 0) {
                    ++counterOutput;
                    break;
                }
                ++row3;
            }
            ++col;
        }
        return counterJoint - counterInput - counterOutput + 1;
    }

    public int getUniqueInputCount() {
        return this.noOfInputs;
    }

    public int getUniqueOutputCount() {
        return this.noOfOutputs;
    }

    public String[] getInputNames() {
        return this.inputsSeen.keySet().toArray(new String[0]);
    }

    public String[] getOutputNames() {
        return this.outputsSeen.keySet().toArray(new String[0]);
    }

    private double calculateConfidence(String input, String output) {
        double n = this.inputsSeen.get(input).doubleValue();
        double p = this.matrixMap.get(input).get(output).doubleValue() / this.inputsSeen.get(input).doubleValue();
        double possError = this.Z * Math.sqrt(p * (1.0 - p) / n);
        return possError;
    }

    public double largestInterval() {
        double maxInterval = 0.0;
        for (String input : this.inputsSeen.keySet()) {
            for (String output : this.matrixMap.get(input).keySet()) {
                maxInterval = Math.max(maxInterval, this.calculateConfidence(input, output));
            }
        }
        return maxInterval;
    }

    public boolean hasSufficientInputs() {
        return this.noOfInputs > 1;
    }

    public boolean hasSufficientOutputs() {
        return this.noOfOutputs > 1;
    }

    public boolean hasSufficientSamplesForMI() {
        return this.noOfSamples > this.noOfInputs * this.noOfOutputs * 4;
    }

    public boolean hasSufficientSamplesForMEL() {
        int threshold = 5;
        if (this.noOfSamples < 5 * this.noOfInputs * this.noOfOutputs) {
            return false;
        }
        int countSmallFrequencies = 0;
        int numCells = 0;
        for (String input : this.inputsSeen.keySet()) {
            for (String output : this.outputsSeen.keySet()) {
                Integer frequency = this.matrixMap.get(input).get(output);
                if (frequency != null && frequency != 0 && frequency < 5) {
                    ++countSmallFrequencies;
                }
                ++numCells;
            }
        }
        if ((double)countSmallFrequencies > (double)numCells * 0.2) {
            return false;
        }
        return MinEntropy.hasSufficientSamplesForMEL(this, numCells);
    }

    private void generateMatrix() {
        this.channelMatrix = new double[this.noOfInputs][this.noOfOutputs];
        int inputIndex = 0;
        for (String input : this.inputsSeen.keySet()) {
            int outputIndex = 0;
            for (String output : this.outputsSeen.keySet()) {
                Integer observationCount = this.matrixMap.get(input).get(output);
                double d = this.channelMatrix[inputIndex][outputIndex++] = observationCount != null ? this.matrixMap.get(input).get(output).doubleValue() / this.inputsSeen.get(input).doubleValue() : 0.0;
            }
            ++inputIndex;
        }
        this.sampleCountGivenInput = new int[this.noOfInputs];
        String[] inputNames = this.getInputNames();
        int i = 0;
        while (i < this.noOfInputs) {
            String input = inputNames[i];
            this.sampleCountGivenInput[i] = 0;
            for (String output : this.outputsSeen.keySet()) {
                if (this.matrixMap.get(input).get(output) == null) continue;
                int n = i;
                this.sampleCountGivenInput[n] = this.sampleCountGivenInput[n] + this.matrixMap.get(input).get(output);
            }
            ++i;
        }
        this.sampleCountGivenOutput = new int[this.noOfOutputs];
        String[] outputNames = this.getOutputNames();
        int i2 = 0;
        while (i2 < this.noOfOutputs) {
            String output;
            output = outputNames[i2];
            this.sampleCountGivenOutput[i2] = 0;
            for (String input : this.inputsSeen.keySet()) {
                if (this.matrixMap.get(input).get(output) == null) continue;
                int n = i2;
                this.sampleCountGivenOutput[n] = this.sampleCountGivenOutput[n] + this.matrixMap.get(input).get(output);
            }
            ++i2;
        }
    }

    public int[][] getObservationsMatrix() {
        this.observationsMatrix = new int[this.noOfInputs][this.noOfOutputs];
        int inputIndex = 0;
        for (String input : this.inputsSeen.keySet()) {
            int outputIndex = 0;
            for (String output : this.outputsSeen.keySet()) {
                Integer observationCount = this.matrixMap.get(input).get(output);
                int n = this.observationsMatrix[inputIndex][outputIndex++] = observationCount != null ? observationCount : 0;
            }
            ++inputIndex;
        }
        return this.observationsMatrix;
    }

    public int[][] getSortedObservationsMatrix(String[] sortedInputNames, String[] sortedOutputNames) {
        if (this.observationsMatrix == null) {
            this.observationsMatrix = this.getObservationsMatrix();
        }
        int numRows = this.observationsMatrix.length;
        int numCols = this.observationsMatrix[0].length;
        if (this.observationsMatrix.length != sortedInputNames.length || this.observationsMatrix[0].length != sortedOutputNames.length) {
            System.out.print("Error: the length of the inputNames or outputNames does not match the size of the observation matrix:");
            System.out.println("  observationsMatrix.length    = " + this.observationsMatrix.length);
            System.out.println("  sortedInputNames.length      = " + sortedInputNames.length);
            System.out.println("  observationsMatrix[0].length = " + this.observationsMatrix[0].length);
            System.out.println("  sortedOutputNames.length     = " + sortedOutputNames.length);
            System.exit(1);
        }
        int[][] sortedObservationsMatrix = new int[numRows][numCols];
        String[] inputNames = this.getInputNames();
        String[] outputNames = this.getOutputNames();
        int row = 0;
        while (row < numRows) {
            int sortedRow = this.getIndex(sortedInputNames, inputNames[row]);
            int col = 0;
            while (col < numCols) {
                int sortedCol = this.getIndex(sortedOutputNames, outputNames[col]);
                sortedObservationsMatrix[sortedRow][sortedCol] = this.observationsMatrix[row][col];
                ++col;
            }
            ++row;
        }
        return sortedObservationsMatrix;
    }

    public LinkedHashMap<String, LinkedHashMap<String, Integer>> getObservationsMatrixMap() {
        return this.matrixMap;
    }

    private int getIndex(String[] labels, String name) {
        int i = 0;
        while (i < labels.length) {
            if (name.equals(labels[i])) {
                return i;
            }
            ++i;
        }
        System.out.print("Error: the name " + name + " was not found in the array:");
        System.exit(1);
        return -1;
    }

    public ProbDist getInputProbDist() {
        double[] inputProbs = new double[this.noOfInputs];
        String[] inputNames = new String[this.noOfInputs];
        int inputIndex = 0;
        for (String input : this.inputsSeen.keySet()) {
            int sum = 0;
            for (String output : this.outputsSeen.keySet()) {
                Integer observationCount = this.matrixMap.get(input).get(output);
                sum += observationCount != null ? observationCount : 0;
            }
            inputProbs[inputIndex] = (double)sum / (double)this.noOfSamples;
            inputNames[inputIndex] = input;
            ++inputIndex;
        }
        HashMap<State, Double> dist = new HashMap<State, Double>();
        int i = 0;
        while (i < this.noOfInputs) {
            State st = new State();
            st.updateValue("input", inputNames[i]);
            double prob = inputProbs[i];
            dist.put(st, prob);
            ++i;
        }
        ProbDist pd = new ProbDist(dist, true);
        return pd;
    }

    public int[] getInputObservationsArray() {
        this.inputObservationsArray = new int[this.noOfInputs];
        int inputIndex = 0;
        for (String input : this.inputsSeen.keySet()) {
            int sum = 0;
            for (String output : this.outputsSeen.keySet()) {
                Integer observationCount = this.matrixMap.get(input).get(output);
                sum += observationCount != null ? observationCount : 0;
            }
            this.inputObservationsArray[inputIndex] = sum;
            ++inputIndex;
        }
        return this.inputObservationsArray;
    }

    public int[] getOutputObservationsArray() {
        this.outputObservationsArray = new int[this.noOfOutputs];
        int outputIndex = 0;
        for (String output : this.outputsSeen.keySet()) {
            int sum = 0;
            for (String input : this.inputsSeen.keySet()) {
                Integer observationCount = this.matrixMap.get(input).get(output);
                sum += observationCount != null ? observationCount : 0;
            }
            this.outputObservationsArray[outputIndex] = sum;
            ++outputIndex;
        }
        return this.outputObservationsArray;
    }

    public Channel generateChannel() {
        return new Channel(1, this.getInputNames(), this.getOutputNames(), this.getChannelMatrix());
    }

    public static double[] observationsToPMF(int[] observedCounts) {
        int size = observedCounts.length;
        int sum = 0;
        int i = 0;
        while (i < size) {
            sum += observedCounts[i];
            ++i;
        }
        double[] pmf = new double[size];
        int i2 = 0;
        while (i2 < size) {
            pmf[i2] = (double)observedCounts[i2] / (double)sum;
            ++i2;
        }
        return pmf;
    }

    public static double[][] observationsToJPMF(int[][] observationsMatrix) {
        int noOfInputs = observationsMatrix.length;
        int noOfOutputs = observationsMatrix[0].length;
        int sum = 0;
        int i = 0;
        while (i < noOfInputs) {
            int j = 0;
            while (j < noOfOutputs) {
                sum += observationsMatrix[i][j];
                ++j;
            }
            ++i;
        }
        double[][] jointMatrix = new double[noOfInputs][noOfOutputs];
        int i2 = 0;
        while (i2 < noOfInputs) {
            int j = 0;
            while (j < noOfOutputs) {
                jointMatrix[i2][j] = (double)observationsMatrix[i2][j] / (double)sum;
                ++j;
            }
            ++i2;
        }
        return jointMatrix;
    }

    public void printObservationsMatrix() {
        System.out.println("Observations matrix for the observations file:");
        int[][] observationsMatrix = this.getObservationsMatrix();
        String[] inputNames = this.getInputNames();
        String[] outputNames = this.getOutputNames();
        int i = 0;
        while (i < observationsMatrix.length) {
            System.out.print(String.valueOf(inputNames[i]) + " -> ");
            int o = 0;
            while (o < observationsMatrix[i].length) {
                System.out.print(String.valueOf(outputNames[o]) + "=" + observationsMatrix[i][o] + " ");
                ++o;
            }
            System.out.println();
            ++i;
        }
    }

    public void printJointFrequencyMatrix() {
        System.out.println("Joint probability matrix for the observations file:");
        this.getObservationsMatrix();
        String[] inputNames = this.getInputNames();
        String[] outputNames = this.getOutputNames();
        int i = 0;
        while (i < this.observationsMatrix.length) {
            int o = 0;
            while (o < this.observationsMatrix[i].length) {
                double d = (double)this.observationsMatrix[i][o] / (double)this.noOfSamples;
                ++o;
            }
            ++i;
        }
        if (!this.sortOutputsDoubleDone) {
            try {
                i = 0;
                while (i < outputNames.length) {
                    Pair<String, Integer> swsi = new Pair<String, Integer>(outputNames[i], i);
                    this.outputNamesSorted.add(swsi);
                    ++i;
                }
                ComparatorStringWithInt comparator = new ComparatorStringWithInt();
                Collections.sort(this.outputNamesSorted, comparator);
            }
            catch (Exception e) {
                System.out.println("Error: failed to sort outputs in sortByOutputValue(): " + e);
                System.exit(1);
            }
            this.sortOutputsDoubleDone = true;
        }
        int maxOutLength = 0;
        int i2 = 0;
        while (i2 < outputNames.length) {
            maxOutLength = Math.max(maxOutLength, outputNames[i2].length());
            ++i2;
        }
        maxOutLength = Math.max(maxOutLength, 6);
        int maxInLength = 0;
        int i3 = 0;
        while (i3 < inputNames.length) {
            maxInLength = Math.max(maxInLength, inputNames[i3].length());
            ++i3;
        }
        Channel.addspaces((maxInLength += 2) + 2);
        i3 = 0;
        while (i3 < outputNames.length) {
            System.out.print("| ");
            Channel.printToLength(this.outputNamesSorted.get(i3).getElement1(), maxOutLength);
            ++i3;
        }
        System.out.println("");
        i3 = 0;
        while (i3 < inputNames.length) {
            this.printRowJoint(i3, maxInLength, maxOutLength, inputNames, outputNames);
            ++i3;
        }
        System.out.println("");
        if (verbose >= 6) {
            this.printJointProbDist(inputNames, outputNames);
        }
    }

    private void printRowJoint(int RowNo, int maxInLength, int maxOutLength, String[] inputNames, String[] outputNames) {
        System.out.print(" ");
        Channel.printToLength(inputNames[RowNo], maxInLength + 1);
        int j = 0;
        while (j < outputNames.length) {
            System.out.print("| ");
            int k = this.outputNamesSorted.get(j).getElement2();
            double prob = (double)this.observationsMatrix[RowNo][k] / (double)this.noOfSamples;
            Channel.printToLength(Double.toString(Stats.round(prob, Math.max(4, maxOutLength - 2))), maxOutLength);
            ++j;
        }
        System.out.println("");
    }

    private void printJointProbDist(String[] inputNames, String[] outputNames) {
        System.out.println("Joint probability distribution for the observations in the -prior format:");
        int RowNo = 0;
        while (RowNo < inputNames.length) {
            int ColNo = 0;
            while (ColNo < outputNames.length) {
                int k = this.outputNamesSorted.get(ColNo).getElement2();
                double prob = (double)this.observationsMatrix[RowNo][k] / (double)this.noOfSamples;
                System.out.print("(" + prob + ", (" + inputNames[RowNo]);
                System.out.print(", " + this.outputNamesSorted.get(ColNo).getElement1());
                System.out.println(")) ");
                ++ColNo;
            }
            ++RowNo;
        }
    }

    static void printDist(double[] array, String message) {
        int size = array.length;
        System.out.println(String.valueOf(message) + ":");
        System.out.print("{ ");
        int i = 0;
        while (i < size - 1) {
            System.out.println(String.valueOf(array[i]) + ",");
            System.out.print("  ");
            ++i;
        }
        System.out.println(String.valueOf(array[size - 1]) + " }");
    }

    public static void printDist(int[] array, String message) {
        int size = array.length;
        System.out.println(String.valueOf(message) + ":");
        System.out.print("{  ");
        int i = 0;
        while (i < size - 1) {
            System.out.println(String.valueOf(array[i]) + ",");
            System.out.print("   ");
            ++i;
        }
        System.out.println(String.valueOf(array[size - 1]) + "  }");
    }

    static void printDist(ArrayList array, String message) {
        int size = array.size();
        System.out.println(String.valueOf(message) + ":");
        System.out.print("{  ");
        int i = 0;
        while (i < size - 1) {
            System.out.println(array.get(i) + ",");
            System.out.print("   ");
            ++i;
        }
        System.out.println(array.get(size - 1) + "  }");
    }
}

