/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest;

import bham.leakiest.Channel;
import bham.leakiest.ContinuousData;
import bham.leakiest.Estimate;
import bham.leakiest.Observations;
import bham.leakiest.ProbDist;
import bham.leakiest.Stats;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.comparator.ComparatorStringWithInt;
import bham.leakiest.comparator.Pair;
import bham.leakiest.infotheory.BlahutArimoto;
import bham.leakiest.infotheory.GLeakage;
import bham.leakiest.infotheory.GainFunction;
import bham.leakiest.infotheory.InfoTheory;
import bham.leakiest.infotheory.KernelFunction;
import bham.leakiest.infotheory.MinEntropy;
import bham.leakiest.infotheory.ShannonEntropy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class PrintLeakageValue {
    private ArrayList<Double> leakage = new ArrayList();
    private ArrayList<Double> zeroLimit = new ArrayList();
    private ArrayList<Double> lowerLimit = new ArrayList();
    private ArrayList<Double> upperLimit = new ArrayList();
    private ArrayList<String> confidence = new ArrayList();
    private static double[] inputDist;
    private boolean PRINT_CHANNELMATRIX = false;
    private boolean PRINT_JOINTMATRIX = false;
    private int verbose = 0;
    private double acceptableError = 1.0E-12;
    private int noOfIterations = 10000;
    private boolean OBS_DISCRETE = true;
    private boolean readFromChanFile = false;
    private boolean priorNonUniform = false;
    private boolean checkEachFeature = false;
    private boolean skipZLT = false;
    private boolean correctLeak = true;
    private boolean correctLeakNew = true;
    static final int CLC_MUTUAL_INFO = 1;
    static final int CLC_CAPACITY = 2;
    static final int CLC_MIN_ENTROPY = 3;
    static final int CLC_MIN_CAPACITY = 4;
    static final int CLC_G_LEAK = 5;
    static final double ERROR = -1.0;
    static final double UNKNOWN = -2.0;
    static final double APPROX_OPTIMIZED = 10.0;

    public PrintLeakageValue(boolean PRINT_CHANNELMATRIXin, boolean PRINT_JOINTMATRIXin, int verboseIn, double acceptableErrorIn, int noOfIterationsIn, boolean OBS_DISCRETEin, boolean readFromChanFileIn, boolean skipZLTin, boolean correctLeakIn, boolean correctLeakNewIn) {
        this.PRINT_CHANNELMATRIX = PRINT_CHANNELMATRIXin;
        this.PRINT_JOINTMATRIX = PRINT_JOINTMATRIXin;
        this.verbose = verboseIn;
        this.acceptableError = acceptableErrorIn;
        this.noOfIterations = noOfIterationsIn;
        this.OBS_DISCRETE = OBS_DISCRETEin;
        this.readFromChanFile = readFromChanFileIn;
        this.skipZLT = skipZLTin;
        this.correctLeak = correctLeakIn;
        this.correctLeakNew = correctLeakNewIn;
    }

    protected void printMeasure(int taskType, ProbDist pd, Channel channel, Observations obs, boolean priorNonUniformIn, boolean checkEachFeatureIn) {
        this.priorNonUniform = priorNonUniformIn;
        this.checkEachFeature = checkEachFeatureIn;
        int sampleSize = 0;
        if (obs != null) {
            sampleSize = obs.getSampleCount();
        }
        if (this.PRINT_CHANNELMATRIX) {
            channel.printChannel();
            if (this.verbose > 3) {
                System.out.println(String.valueOf(channel.noOfInputs()) + " inputs, " + channel.noOfOutputs() + " outputs and " + sampleSize + " samples.\n");
            }
        }
        if (this.PRINT_JOINTMATRIX) {
            if (this.readFromChanFile) {
                channel.printJointMatrix(pd);
            } else if (obs != null) {
                obs.printJointFrequencyMatrix();
            }
            if (this.verbose > 3) {
                System.out.println(String.valueOf(channel.noOfInputs()) + " inputs, " + channel.noOfOutputs() + " outputs and " + sampleSize + " samples.\n");
            }
        }
        switch (taskType) {
            case 1: {
                if (this.correctLeak) {
                    this.printDiscreteCorrectedMI(pd, channel, sampleSize);
                    break;
                }
                this.printDiscreteNonCorrectedMI(pd, channel);
                break;
            }
            case 2: {
                if (this.correctLeak) {
                    this.printDiscreteCorrectedChannelCapacity(channel, sampleSize);
                    break;
                }
                this.printDiscreteNonCorrectedChannelCapacity(channel);
                break;
            }
            case 3: {
                if (this.correctLeak) {
                    if (this.correctLeakNew) {
                        if (this.verbose >= 1) {
                            System.out.println("The confidence interval estimation is based on Chi-square test...");
                        }
                        this.printDiscreteMinEntropyLeakWithNewInterval(pd, channel, sampleSize, obs);
                        break;
                    }
                    if (this.verbose >= 1) {
                        System.out.println("The confidence interval estimation is based on [Vajda'02] & [Dutta, Goswami'10].");
                    }
                    int[] sampleSizeGivenOutput = obs.getSampleCountGivenOutput();
                    this.printDiscreteMinEntropyLeakWithInterval(pd, channel, sampleSize, sampleSizeGivenOutput);
                    break;
                }
                this.printDiscreteMinEntropyLeakOnly(pd, channel);
                break;
            }
            case 4: {
                this.printDiscreteMinCapacity(channel);
                break;
            }
            case 5: {
                this.printDiscreteGLeakageOnly(pd, channel, TestInfoLeak.gf, TestInfoLeak.guessDomain);
            }
        }
        if (!this.checkEachFeature && this.verbose > 1) {
            System.out.println("");
        }
    }

    protected void printMeasure(int taskType, ContinuousData cdata, boolean priorNonUniformIn, boolean checkEachFeatureIn) {
        this.priorNonUniform = priorNonUniformIn;
        this.checkEachFeature = checkEachFeatureIn;
        switch (taskType) {
            case 1: {
                this.printContinuousMutualInformation(cdata);
            }
        }
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.println("");
        }
    }

    private void printDiscreteNonCorrectedMI(ProbDist pd, Channel channel) {
        double result;
        if (this.priorNonUniform) {
            result = ShannonEntropy.mutualInformation(pd, channel);
            System.out.printf("Mutual information: %1$6.4g \n", result);
        } else {
            result = ShannonEntropy.MIuniformInput(channel.getMatrix());
            System.out.printf("Mutual information: %1$6.4g  ", result);
            System.out.println(" Calculated with the uniform input distribution.");
        }
        if (result <= -1.0) {
            System.out.printf("Error: Failed to calculate mutual information.", new Object[0]);
            return;
        }
        System.out.printf("The attacker learns %6.4g bits", result);
        if (this.priorNonUniform) {
            System.out.printf(", out of a possible %6.4g bits, about the input events.", ShannonEntropy.entropy(pd));
        } else {
            System.out.printf(", out of a possible %6.4g bits, about the input events.", InfoTheory.log2(channel.noOfInputs()));
        }
        System.out.println();
        this.leakage.add(result);
        this.zeroLimit.add(-1.0);
        this.lowerLimit.add(-1.0);
        this.upperLimit.add(-1.0);
        this.confidence.add("NOT SURE   ");
    }

    private void printDiscreteCorrectedMI(ProbDist pd, Channel channel, int sampleSize) {
        double result = this.priorNonUniform ? ShannonEntropy.mutualInformation(pd, channel) : ShannonEntropy.MIuniformInput(channel.getMatrix());
        if (result <= -1.0) {
            System.out.printf("Error: Failed to calculate mutual information.", new Object[0]);
            return;
        }
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.print("Estimated mutual information: ");
            System.out.print(Stats.round(mean, 4));
            if (this.priorNonUniform) {
                System.out.printf(" (out of possible %6.4g bits)\n", ShannonEntropy.entropy(pd));
            } else {
                System.out.printf(" (out of possible %6.4g bits)\n", InfoTheory.log2(channel.noOfInputs()));
            }
            if (!this.priorNonUniform) {
                System.out.println("  Calculated with the uniform input distribution.");
            }
            if (this.verbose > 2) {
                System.out.println("  noOfInputs: " + channel.noOfInputs() + "  noOfOutputs " + channel.noOfOutputs());
            }
        }
        if (channel.noOfInputs() <= 1 || channel.noOfOutputs() <= 1) {
            if (!this.checkEachFeature || this.verbose > 1) {
                System.out.println("It is impossible to calculate zero information leakage.");
            }
            if (this.verbose > 2) {
                System.out.println("  The numbers of inputs =  " + channel.noOfInputs());
                System.out.println("  The numbers of outputs = " + channel.noOfOutputs());
                System.out.println("  These values must not be 1.");
            }
            this.leakage.add(mean);
            this.zeroLimit.add(-1.0);
            this.lowerLimit.add(-1.0);
            this.upperLimit.add(-1.0);
            this.confidence.add("NOT SURE   ");
        } else {
            double zeroUpperBound = Stats.upperBoundForZero((channel.noOfInputs() - 1) * (channel.noOfOutputs() - 1), sampleSize);
            double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(pd, channel, sampleSize);
            double lower = Stats.round(Math.max(0.0, Stats.lowerBoundNormal95(mean, variance)), 4);
            double upper = Stats.round(Stats.upperBoundNormal95(mean, variance), 4);
            if (this.verbose > 2) {
                System.out.println("  Correction = log_2(e).(noOfInputs-1)(noOfOutputs-1)/2.sampleSize = " + Stats.round(correction, 4));
                System.out.printf("  Mean:     " + Stats.round(mean, 4) + " (= " + Stats.round(result, 4) + " - " + Stats.round(correction, 4) + ")\n", new Object[0]);
                System.out.printf("  Variance: %1$6.4g \n", variance);
            }
            if (!this.checkEachFeature || this.verbose > 1) {
                System.out.println("  Between " + lower + " and " + upper + " with 95% confidence");
                System.out.println("  With 95% confidence, if leakage (w/o correction) < " + Stats.round(zeroUpperBound, 4) + ", we may consider no information is leaked.");
                if (result <= zeroUpperBound) {
                    System.out.println("No leak detected.");
                } else {
                    System.out.println("There is a leak.");
                }
            }
            this.leakage.add(mean);
            this.zeroLimit.add(zeroUpperBound);
            this.lowerLimit.add(lower);
            this.upperLimit.add(upper);
            if (zeroUpperBound == -1.0) {
                this.confidence.add("NOT SURE   ");
            } else if (result <= zeroUpperBound) {
                this.confidence.add("ZERO LEAK  ");
            } else {
                this.confidence.add("LEAK       ");
            }
        }
    }

    private void printDiscreteNonCorrectedChannelCapacity(Channel channel) {
        BlahutArimoto ba = new BlahutArimoto(channel, this.acceptableError, this.noOfIterations);
        ba.calculateCapacity();
        double result = ba.getCapacity();
        inputDist = ba.getMaxInputDist();
        if (this.verbose > 1) {
            System.out.println("Maximising input distribution estimated to be:");
            InfoTheory.printPMF(channel.getInputNames(), ba.getMaxInputDist());
            System.out.println();
        }
        if (this.verbose > 1) {
            double possibleError = ba.getPossibleError();
            double acceptableError = ba.getAcceptableError();
            int iteration = ba.getIterationCount();
            if (possibleError == 0.0) {
                System.out.println("  Blahut-Arimoto Algorithm terminated after " + iteration + " iterations.");
            } else if (possibleError <= acceptableError) {
                System.out.println("  Capacity calculated to within acceptable error, in " + iteration + " iterations.");
            } else if (possibleError > acceptableError) {
                System.out.println("  NOT COMPLETE: Performed the maximum number of iterations: " + iteration);
                System.out.println("  Possible error rate " + possibleError + " is still bigger than ");
                System.out.println("  the acceptable error rate " + acceptableError + ".");
                System.out.println("  Increase the maximum number of iterations (with option -i <int>)");
                System.out.println("  or increase the acceptable error (with option -e <double>).");
            }
        }
        this.leakage.add(result);
        System.out.printf("Capacity: %1$6.4g \n", result);
        if (this.verbose > 3) {
            System.out.println("  Acceptable error level for Blahut-Arimoto Algorithm: " + this.acceptableError);
        }
        System.out.printf("The attacker learns %6.4g bits", result);
        System.out.printf(", out of a possible %6.4g bits, about the input events.", InfoTheory.log2(channel.noOfInputs()));
        System.out.println();
        this.leakage.add(result);
        this.zeroLimit.add(-1.0);
        this.lowerLimit.add(-1.0);
        this.upperLimit.add(-1.0);
        this.confidence.add("USEFUL     ");
    }

    private void printDiscreteCorrectedChannelCapacity(Channel channel, int sampleSize) {
        BlahutArimoto ba = new BlahutArimoto(channel, this.acceptableError, this.noOfIterations);
        ba.calculateCapacity();
        double result = ba.getCapacity();
        inputDist = ba.getMaxInputDist();
        double correction = (double)(channel.noOfInputs() - 1) * (double)(channel.noOfOutputs() - 1) / (double)(2 * sampleSize) * InfoTheory.log2(Math.E);
        double mean = Math.max(0.0, result - correction);
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.print("Estimated capacity: ");
            System.out.print(Stats.round(mean, 4));
            System.out.printf(" (out of possible %6.4g bits)\n", InfoTheory.log2(channel.noOfInputs()));
            if (this.verbose > 3) {
                System.out.println("  Acceptable error level for Blahut-Arimoto Algorithm: " + this.acceptableError);
            }
            if (this.verbose > 2) {
                System.out.println("  noOfInputs: " + channel.noOfInputs() + "  noOfOutputs " + channel.noOfOutputs());
            }
        }
        if (channel.noOfInputs() <= 1 || channel.noOfOutputs() <= 1) {
            if (!this.checkEachFeature || this.verbose > 1) {
                System.out.println("It is impossible to calculate zero information leakage.");
            }
            if (this.verbose > 2) {
                System.out.println("  The numbers of inputs =  " + channel.noOfInputs());
                System.out.println("  The numbers of outputs = " + channel.noOfOutputs());
                System.out.println("  These values must not be 1.");
            }
            this.leakage.add(mean);
            this.zeroLimit.add(-1.0);
            this.lowerLimit.add(-1.0);
            this.upperLimit.add(-1.0);
            this.confidence.add("NOT SURE   ");
        } else {
            double zeroUpperBound = Stats.upperBoundForZero((channel.noOfInputs() - 1) * (channel.noOfOutputs() - 1), sampleSize);
            double variance = Estimate.VarianceOfEstimatedMIUnderEstimatedPrior(inputDist, channel.getMatrix(), sampleSize);
            double lower = Stats.round(Math.max(0.0, Stats.lowerBoundNormal95(mean, variance)), 4);
            double upper = Stats.round(Stats.upperBoundNormal95(mean, variance), 4);
            if (this.verbose > 2) {
                System.out.println("  Correction = log_2(e).(noOfInputs-1)(noOfOutputs-1)/2.sampleSize = " + Stats.round(correction, 4));
                System.out.printf("  Mean:     " + Stats.round(mean, 4) + " (= " + Stats.round(result, 4) + " - " + Stats.round(correction, 4) + ")\n", new Object[0]);
                System.out.printf("  Variance: %1$6.4g \n", variance);
            }
            if (!this.checkEachFeature || this.verbose > 1) {
                System.out.println("  Between " + lower + " and " + upper + " with 95% confidence");
                System.out.println("  With 95% confidence, if leakage (w/o correction) < " + Stats.round(zeroUpperBound, 4) + ", we may consider no information is leaked.");
                if (result <= zeroUpperBound) {
                    System.out.println("No leak detected.");
                } else {
                    System.out.println("There is a leak.");
                }
            }
            this.leakage.add(mean);
            this.zeroLimit.add(zeroUpperBound);
            this.lowerLimit.add(lower);
            this.upperLimit.add(upper);
            if (zeroUpperBound == -1.0) {
                this.confidence.add("NOT SURE   ");
            } else if (result <= zeroUpperBound) {
                this.confidence.add("ZERO LEAK  ");
            } else {
                this.confidence.add("LEAK       ");
            }
        }
    }

    private void printDiscreteMinEntropyLeakOnly(ProbDist pd, Channel channel) {
        double result;
        if (this.priorNonUniform) {
            result = MinEntropy.minEntropyLeak(pd, channel);
            if (result == -1.0) {
                System.out.println("Error: Failed to calculate min-entropy leakage.");
                return;
            }
            if (this.verbose == -1) {
                System.out.printf("%1$6.4g", result);
                return;
            }
            if (!this.checkEachFeature || this.verbose > 1) {
                System.out.printf("Min-entropy leakage: %1$6.4g  ", result);
                System.out.printf(" (out of possible %6.4g bits)\n", MinEntropy.minEntropy(pd));
                if (this.verbose > 4) {
                    System.out.println("  -log(a priori vulnerability):     " + MinEntropy.minEntropy(pd));
                    System.out.println("  -log(a posteriori vulnerability): " + MinEntropy.conditionalMinEntropy(pd, channel));
                }
                System.out.println();
            }
        } else {
            double[] dist = InfoTheory.uniformDist(channel.getMatrix().length);
            result = MinEntropy.minEntropyLeak(dist, channel.getMatrix());
            if (this.verbose == -1) {
                System.out.printf("%1$6.4g", result);
                return;
            }
            if (!this.checkEachFeature || this.verbose > 1) {
                System.out.printf("Min-entropy leakage: %1$6.4g  ", result);
                System.out.printf(" (out of possible %6.4g bits)\n", InfoTheory.log2(channel.noOfInputs()));
                System.out.println("  Calculated with the uniform input distribution.");
                if (this.verbose > 4) {
                    System.out.println("  -log(a priori vulnerability):     " + MinEntropy.minEntropy(dist));
                    System.out.println("  -log(a posteriori vulnerability): " + MinEntropy.conditionalMinEntropy(dist, channel.getMatrix()));
                }
                System.out.println();
            }
        }
        this.leakage.add(result);
        this.zeroLimit.add(-1.0);
        this.lowerLimit.add(-1.0);
        this.upperLimit.add(-1.0);
        this.confidence.add("NOT SURE   ");
    }

    private void printDiscreteMinEntropyLeakWithInterval(ProbDist pd, Channel channel, int sampleSize, int[] sampleSizeGivenOutput) {
        double[] dist = this.priorNonUniform ? pd.probDistToPMFArray(channel.getInputNames()) : InfoTheory.uniformDist(channel.getMatrix().length);
        double result = MinEntropy.minEntropyLeak(dist, channel.getMatrix());
        if (result <= -1.0) {
            System.out.printf("Error: Failed to calculate min-entropy leakage.", new Object[0]);
            return;
        }
        double possibleErrorOld = MinEntropy.minEntropyLeakError20130114(dist, channel.getMatrix(), sampleSize, channel.noOfOutputs());
        double lower = Math.max(0.0, result - possibleErrorOld);
        double upper = Math.min(InfoTheory.log2(channel.noOfInputs()), result + possibleErrorOld);
        System.out.println("  old confidence interval = [" + lower + ", " + upper + "]");
        double[] MELintervalNew = MinEntropy.minEntropyLeakConfidenceIntervalVajda(dist, channel.getMatrix(), sampleSize, sampleSizeGivenOutput, channel.noOfOutputs());
        double MELlower = MELintervalNew[0];
        double MELupper = MELintervalNew[1];
        double possibleError = Math.max(result - MELlower, MELupper - result);
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.print("Estimated min-entropy leakage: ");
            System.out.print(Stats.round(result, 4));
            if (this.priorNonUniform) {
                System.out.printf(" (out of possible %6.4g bits)\n", MinEntropy.minEntropy(pd));
            } else {
                System.out.printf(" (out of possible %6.4g bits)\n", InfoTheory.log2(channel.noOfInputs()));
                System.out.println("  Calculated with the uniform input distribution.");
            }
            if (this.verbose > 4) {
                System.out.println("  -log(a priori vulnerability):     " + MinEntropy.minEntropy(dist));
                System.out.println("  -log(a posteriori vulnerability): " + MinEntropy.conditionalMinEntropy(dist, channel.getMatrix()));
            }
            System.out.println("  Possible error: " + Stats.round(possibleError, 4));
            if (this.verbose >= 7) {
                System.out.println("Old wrong version 14/01/2013: ");
                System.out.println("* Between " + Stats.round(lower, 4) + " and " + Stats.round(upper, 4) + " with 95% confidence");
            }
            System.out.println("  Between " + Stats.round(MELlower, 4) + " and " + Stats.round(MELupper, 4) + " with 95% confidence");
            if (MELlower > 0.0) {
                System.out.print("There is a leak.");
            } else if (Double.isNaN(MELlower)) {
                System.out.println("Too small sample size");
            } else {
                System.out.println("No leak detected.");
            }
            System.out.println();
        }
        this.leakage.add(result);
        this.zeroLimit.add(-1.0);
        this.lowerLimit.add(MELlower);
        this.upperLimit.add(MELupper);
        if (MELlower > 0.0) {
            this.confidence.add("INFO LEAK  ");
        } else {
            this.confidence.add("NOT SURE   ");
        }
    }

    private void printDiscreteMinEntropyLeakWithNewInterval(ProbDist pd, Channel channel, int sampleSize, Observations obs) {
        double[][] condProb;
        double minConfidenceLevel = 0.95;
        double[] dist = this.priorNonUniform ? pd.probDistToPMFArray(channel.getInputNames()) : InfoTheory.uniformDist(condProb.length);
        double result = MinEntropy.minEntropyLeak(dist, condProb = channel.getMatrix());
        if (result <= -1.0) {
            System.out.printf("Error: Failed to calculate min-entropy leakage.", new Object[0]);
            return;
        }
        double[] interval = MinEntropy.minEntropyLeakConfidenceIntervalChiSquare(obs);
        double lowerBoundInterval = interval[0];
        double upperBoundInterval = interval[1];
        double possibleError = Math.max(result - lowerBoundInterval, upperBoundInterval - result);
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.print("Estimated min-entropy leakage: ");
            System.out.print(Stats.round(result, 4));
            if (this.priorNonUniform) {
                System.out.printf(" (out of possible %6.4g bits)\n", MinEntropy.minEntropy(pd));
            } else {
                System.out.printf(" (out of possible %6.4g bits)\n", InfoTheory.log2(channel.noOfInputs()));
                System.out.println("  Calculated with the uniform input distribution.");
            }
            if (this.verbose > 4) {
                System.out.println("  -log(a priori vulnerability):     " + MinEntropy.minEntropy(dist));
                System.out.println("  -log(a posteriori vulnerability): " + MinEntropy.conditionalMinEntropy(dist, channel.getMatrix()));
            }
            System.out.println("  Possible error: " + Stats.round(possibleError, 4));
            System.out.println("  Between " + Stats.round(lowerBoundInterval, 4) + " and " + Stats.round(upperBoundInterval, 4) + " with " + 95.0 + "% confidence");
            if (lowerBoundInterval > 0.0) {
                System.out.print("There is a leak.");
            } else if (Double.isNaN(lowerBoundInterval)) {
                System.out.println("Too small sample size.");
            } else {
                System.out.println("No leak detected.");
            }
            System.out.println();
        }
        this.leakage.add(result);
        this.zeroLimit.add(-1.0);
        this.lowerLimit.add(lowerBoundInterval);
        this.upperLimit.add(upperBoundInterval);
        if (lowerBoundInterval > 0.0) {
            this.confidence.add("INFO LEAK  ");
        } else {
            this.confidence.add("NOT SURE   ");
        }
    }

    private void printDiscreteMinCapacity(Channel channel) {
        double result = MinEntropy.minCapacity(channel.getMatrix());
        if (this.verbose == -1) {
            System.out.printf("%1$6.4g", result);
            return;
        }
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.printf("Min-capacity: %1$6.4g", result);
            System.out.printf(" (out of possible %6.4g bits)\n", InfoTheory.log2(channel.noOfInputs()));
            System.out.printf("  Note that this result does not take account of confidence interval.", new Object[0]);
            System.out.println();
        }
        this.leakage.add(result);
        this.zeroLimit.add(-1.0);
        this.lowerLimit.add(-1.0);
        this.upperLimit.add(-1.0);
        this.confidence.add("NOT SURE   ");
    }

    private void printDiscreteGLeakageOnly(ProbDist pd, Channel channel, GainFunction gf, Set<String> guessDomain) {
        double result;
        if (!this.priorNonUniform) {
            pd = ProbDist.uniformProbDist(channel.getInputNames(), true);
            if (this.verbose >= 5) {
                System.out.println("The uniform distribution is assumed.");
            }
        }
        if (!GainFunction.checkConsistency(pd, guessDomain)) {
            System.out.println("Error: There is a guess not found in the prior.");
            System.exit(1);
        }
        if ((result = GLeakage.gLeakage(pd, channel, gf, guessDomain)) <= -1.0) {
            System.out.printf("Error: Failed to calculate g-leakage.", new Object[0]);
            return;
        }
        if (this.verbose == -1) {
            System.out.printf("%1$6.4g", result);
            return;
        }
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.printf("g-leakage: %1$6.4g  ", result);
            System.out.printf(" (out of possible %6.4g bits)\n", GLeakage.gEntropy(pd, gf, guessDomain));
            if (!this.priorNonUniform) {
                System.out.println("  Calculated with the uniform input distribution.");
            }
            if (this.verbose > 4) {
                System.out.println("  -log(a priori g-vulnerability):     " + GLeakage.gEntropy(pd, gf, guessDomain));
                System.out.println("  -log(a posteriori g-vulnerability): " + GLeakage.conditionalGEntropy(pd, channel, gf, guessDomain));
            }
            System.out.println();
        }
        this.leakage.add(result);
        this.zeroLimit.add(-1.0);
        this.lowerLimit.add(-1.0);
        this.upperLimit.add(-1.0);
        this.confidence.add("NOT SURE   ");
    }

    private int printContinuousMutualInformation(ContinuousData cdata) {
        ArrayList<double[]> DataList = cdata.DataList;
        int noOfTestsContinuous = cdata.testSize;
        KernelFunction kernel = new KernelFunction(DataList);
        double[] inputDist = kernel.probInputDist(DataList);
        double realMI = kernel.calcContinuousApproxMI(inputDist, cdata.DataList);
        if (realMI == -1.0) {
            System.out.print("We cannot estimate the mutual information. ");
            System.out.println("The ammount of observations is not enough.");
            return -1;
        }
        if (!this.checkEachFeature || this.verbose > 1) {
            System.out.print("Estimated mutual information: " + Stats.round(realMI, 4));
            System.out.printf(" (out of possible %6.4g bits)\n", ShannonEntropy.entropy(inputDist));
        }
        if (this.skipZLT) {
            this.leakage.add(realMI);
            this.zeroLimit.add(-1.0);
            this.lowerLimit.add(-1.0);
            this.upperLimit.add(-1.0);
            this.confidence.add("NOT SURE   ");
            return 0;
        }
        double[] miResultsZ = new double[noOfTestsContinuous];
        double miTotalZ = 0.0;
        int i = 0;
        while (i < noOfTestsContinuous) {
            double continuousApproxMI;
            ArrayList<double[]> shuffledDataList = cdata.selectShuffled(inputDist);
            if (shuffledDataList == null) {
                return -1;
            }
            kernel = new KernelFunction(shuffledDataList);
            miResultsZ[i] = continuousApproxMI = kernel.calcContinuousApproxMI(inputDist, shuffledDataList);
            miTotalZ += continuousApproxMI;
            ++i;
        }
        Arrays.sort(miResultsZ);
        double percentileValue = miResultsZ[(int)((double)miResultsZ.length * 0.95)];
        if (!this.checkEachFeature || this.verbose > 1) {
            if (realMI < percentileValue) {
                System.out.println("No leak detected.");
                System.out.println("  Estimate is below " + Stats.round(percentileValue, 4) + "(the 95 percentile for shuffled values).");
            } else {
                System.out.println("There is a leak.");
                System.out.println("  Estimate is NOT below " + Stats.round(percentileValue, 4) + "(the 95 percentile for shuffled values).");
            }
        }
        if (!(this.checkEachFeature && this.verbose <= 1 || this.verbose <= 2)) {
            double averageZero = miTotalZ / (double)noOfTestsContinuous;
            double stdDevZero = Stats.sdtDevSampled(miResultsZ, miTotalZ);
            double upperbound = Stats.upperBoundNormal95Upper(averageZero, stdDevZero * stdDevZero);
            System.out.print("In zero leakage tests, ");
            System.out.println("the mutual information for " + noOfTestsContinuous + " SHUFFLED samples has");
            System.out.println("  Average:                         " + Stats.round(averageZero, 4));
            System.out.println("  Standard devation:               " + Stats.round(stdDevZero, 4));
            System.out.println("  Upper 95% limit for normal dist: " + Stats.round(upperbound, 4));
        }
        this.leakage.add(realMI);
        this.zeroLimit.add(percentileValue);
        this.lowerLimit.add(-1.0);
        this.upperLimit.add(-1.0);
        if (realMI < percentileValue) {
            this.confidence.add("ZERO LEAK  ");
        } else {
            this.confidence.add("LEAK       ");
        }
        return 0;
    }

    protected void printAllResults(int taskType, ArrayList<String> name) {
        ArrayList<Pair<String, Integer>> sortIndex = new ArrayList<Pair<String, Integer>>();
        int maxlen = 0;
        int i = 0;
        while (i < this.leakage.size()) {
            Pair<String, Integer> swsi = new Pair<String, Integer>(this.leakage.get(i).toString(), i);
            sortIndex.add(swsi);
            if (name != null && name.size() > i) {
                maxlen = Math.max(maxlen, name.get(i).length());
            }
            ++i;
        }
        ComparatorStringWithInt comparator = new ComparatorStringWithInt();
        Collections.sort(sortIndex, comparator);
        System.out.println("");
        System.out.println("--------------------------------------------------------------------------------");
        System.out.print("  Information leakage from the ");
        if (this.OBS_DISCRETE) {
            System.out.print("discrete outputs ");
        } else {
            System.out.print("continuous outputs ");
        }
        System.out.println("about the inputs, measured by");
        switch (taskType) {
            case 1: {
                System.out.println("  mutual information (calculated with the uniform input distribution):");
                break;
            }
            case 2: {
                System.out.println("  capacity:");
                break;
            }
            case 3: {
                System.out.println("  min-entropy leakage (calculated with the uniform input distribution):");
                break;
            }
            case 4: {
                System.out.println("  min-capacity:");
            }
        }
        System.out.println("--------------------------------------------------------------------------------");
        System.out.print("Confidence Result     Attributions");
        int j = 0;
        while (j < maxlen) {
            System.out.print(" ");
            ++j;
        }
        System.out.println("          Range (with 95% confidence)");
        int i2 = this.leakage.size() - 1;
        while (i2 >= 0) {
            int j2 = (Integer)((Pair)sortIndex.get(i2)).getElement2();
            System.out.print(this.confidence.get(j2));
            if (this.leakage.get(j2) != -1.0) {
                System.out.format("%.3f for%s", this.leakage.get(j2), name.get(j2));
            } else {
                System.out.format("ERROR for%s", name.get(j2));
            }
            int k = 0;
            while (k < maxlen - name.get(j2).length()) {
                System.out.print(" ");
                ++k;
            }
            if (this.zeroLimit.get(j2) != -1.0) {
                System.out.format("  zero leakage < %.3f", this.zeroLimit.get(j2));
            } else {
                System.out.format("                      ", new Object[0]);
            }
            if (this.lowerLimit.get(j2) != -1.0 || this.upperLimit.get(j2) != -1.0) {
                if (this.lowerLimit.get(j2) != -1.0) {
                    System.out.format("  [%.3f, ", Math.max(0.0, this.lowerLimit.get(j2)));
                } else {
                    System.out.format("  [  ?  , ", new Object[0]);
                }
                if (this.upperLimit.get(j2) != -1.0) {
                    System.out.format("%.3f]", this.upperLimit.get(j2));
                } else {
                    System.out.format("   ? ]", new Object[0]);
                }
            }
            System.out.println("");
            --i2;
        }
    }
}

