/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest.infotheory;

import bham.leakiest.Stats;
import bham.leakiest.infotheory.InfoTheory;
import java.util.ArrayList;
import java.util.Iterator;

public class KernelFunction {
    private ArrayList<double[]> DataList;
    private double startPoint;
    private double endPoint;
    private double stepSizeForMI;
    private double[] diffRange;
    private double[] h;
    private static final double ERROR = -1.0;
    public static int resolutionForMI = 250;

    public KernelFunction(ArrayList<double[]> observedDataList) {
        this.DataList = observedDataList;
        this.diffRange = new double[this.DataList.size()];
        this.h = new double[this.DataList.size()];
        Iterator<double[]> it = this.DataList.iterator();
        int i = 0;
        while (it.hasNext()) {
            double[] Data = it.next();
            double Max = this.maxData(Data);
            double Min = this.minData(Data);
            this.diffRange[i] = Max - Min;
            this.h[i] = this.bandWidth(Data, this.diffRange[i]);
            this.startPoint = i == 0 ? Min - 3.0 * this.h[i] : Math.min(this.startPoint, Min - 3.0 * this.h[i]);
            this.endPoint = Math.max(this.endPoint, Max + 3.0 * this.h[i]);
            ++i;
        }
        this.stepSizeForMI = (this.endPoint - this.startPoint) / (double)resolutionForMI;
    }

    private double maxData(double[] Data) {
        double Max = 0.0;
        boolean initialize = true;
        double[] dArray = Data;
        int n = Data.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (initialize) {
                if (!Double.isNaN(value)) {
                    Max = value;
                }
                initialize = false;
            } else if (!Double.isNaN(value)) {
                Max = Math.max(value, Max);
            }
            ++n2;
        }
        return Max;
    }

    private double minData(double[] Data) {
        double Min = 0.0;
        boolean initialize = true;
        double[] dArray = Data;
        int n = Data.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (initialize) {
                if (!Double.isNaN(value)) {
                    Min = value;
                }
                initialize = false;
            } else if (!Double.isNaN(value)) {
                Min = Math.min(value, Min);
            }
            ++n2;
        }
        return Min;
    }

    private double bandWidth(double[] Data, double diffRange) {
        double sdtDev = Stats.sdtDevSampled(Data);
        double h = Double.isNaN(sdtDev) ? 1.06 * diffRange * (double)Data.length : 1.06 * Math.min(sdtDev, diffRange * (double)Data.length);
        return h;
    }

    private double probEstimate(double output, double[] Data, double diffRange) {
        double h = this.bandWidth(Data, diffRange);
        double sum = 0.0;
        int i = 0;
        while (i < Data.length) {
            sum += this.kernelFunction((output - Data[i]) / h);
            ++i;
        }
        if (h <= 0.0 || Data.length == 0) {
            return -1.0;
        }
        return sum / ((double)Data.length * h);
    }

    public double[] probInputDist(ArrayList<double[]> DataList) {
        int Total = 0;
        for (double[] dl : DataList) {
            Total += dl.length;
        }
        double[] dist = new double[DataList.size()];
        int i = 0;
        while (i < DataList.size()) {
            dist[i] = (double)DataList.get(i).length / (double)Total;
            ++i;
        }
        return dist;
    }

    private double kernelFunction(double x) {
        return this.epanechnikov(x);
    }

    private double epanechnikov(double x) {
        if (Math.abs(x) <= 1.0) {
            return 3.0 * (1.0 - x * x) / 4.0;
        }
        return 0.0;
    }

    public double calcContinuousApproxMI(double[] inputDist, ArrayList<double[]> Datalist) {
        double currentPoint = this.startPoint;
        double MIsum = 0.0;
        double[] probOoutputGivenInput = new double[Datalist.size()];
        int i = 0;
        while (i < resolutionForMI) {
            double probOutput = 0.0;
            int x = 0;
            while (x < Datalist.size()) {
                probOoutputGivenInput[x] = this.probEstimate(currentPoint, Datalist.get(x), this.diffRange[x]);
                if (probOoutputGivenInput[x] != -1.0) {
                    probOutput += inputDist[x] * probOoutputGivenInput[x];
                } else {
                    return -1.0;
                }
                ++x;
            }
            if (probOutput != 0.0) {
                x = 0;
                while (x < Datalist.size()) {
                    double inner = probOoutputGivenInput[x] / probOutput;
                    if (probOoutputGivenInput[x] != 0.0) {
                        double term = probOoutputGivenInput[x] * InfoTheory.log2(inner);
                        double area = term * this.stepSizeForMI;
                        MIsum += inputDist[x] * area;
                    }
                    ++x;
                }
            }
            currentPoint += this.stepSizeForMI;
            ++i;
        }
        return MIsum;
    }
}

