/*
 * Decompiled with CFR 0.152.
 */
package bham.leakiest.infotheory;

import bham.leakiest.Channel;
import bham.leakiest.Observations;
import bham.leakiest.ProbDist;
import bham.leakiest.State;
import bham.leakiest.Stats;
import bham.leakiest.TestInfoLeak;
import bham.leakiest.comparator.ComparatorIntegers;
import bham.leakiest.comparator.Pair;
import bham.leakiest.infotheory.InfoTheory;
import java.util.ArrayList;
import java.util.Collections;

public class MinEntropy {
    private static int verbose = TestInfoLeak.verbose;
    public static final int base_log = 2;
    private static final int ERROR = -1;
    public static final int threshold = 5;
    private static final int maxNumIterate = 1000;
    private static final double accuracy = 0.05;

    public static double vulnerability(double[] pmf) {
        double maxProb = 0.0;
        int i = 0;
        while (i < pmf.length) {
            maxProb = Math.max(maxProb, pmf[i]);
            ++i;
        }
        return Math.min(maxProb, 1.0);
    }

    public static double minEntropy(double[] pmf) {
        return -InfoTheory.log(MinEntropy.vulnerability(pmf), 2);
    }

    public static double vulnerability(ProbDist pd) {
        double maxProb = 0.0;
        for (State st : pd.getStatesCollection()) {
            double prob = pd.getProb(st);
            maxProb = Math.max(maxProb, prob);
        }
        return Math.min(maxProb, 1.0);
    }

    public static double minEntropy(ProbDist pd) {
        return -InfoTheory.log(MinEntropy.vulnerability(pd), 2);
    }

    private static double conditionalVulnerability(double[][] jointProbMatrix) {
        double posteriori = 0.0;
        int j = 0;
        while (j < jointProbMatrix[0].length) {
            double maxProb = 0.0;
            int i = 0;
            while (i < jointProbMatrix.length) {
                maxProb = Math.max(maxProb, jointProbMatrix[i][j]);
                ++i;
            }
            posteriori += maxProb;
            ++j;
        }
        return posteriori;
    }

    public static double conditionalVulnerability(double[] pmf, double[][] matrix) {
        double posteriori = 0.0;
        int j = 0;
        while (j < matrix[0].length) {
            double maxProb = 0.0;
            int i = 0;
            while (i < pmf.length) {
                maxProb = Math.max(maxProb, pmf[i] * matrix[i][j]);
                ++i;
            }
            posteriori += maxProb;
            ++j;
        }
        return posteriori;
    }

    public static double conditionalVulnerability(ProbDist pd, Channel channel) {
        double[] pmf = pd.probDistToPMFArray(channel.getInputNames());
        double[][] matrix = channel.getMatrix();
        if (pmf != null) {
            return MinEntropy.conditionalVulnerability(pmf, matrix);
        }
        return -1.0;
    }

    public static double conditionalMinEntropy(double[] pmf, double[][] matrix) {
        double posteriori = MinEntropy.conditionalVulnerability(pmf, matrix);
        return -InfoTheory.log(Math.min(posteriori, 1.0), 2);
    }

    public static double conditionalMinEntropy(ProbDist pd, Channel channel) {
        double[] pmf = pd.probDistToPMFArray(channel.getInputNames());
        double[][] matrix = channel.getMatrix();
        if (pmf != null) {
            return MinEntropy.conditionalMinEntropy(pmf, matrix);
        }
        return -1.0;
    }

    public static double minEntropyLeak(double[] pmf, double[][] matrix) {
        return Math.max(0.0, MinEntropy.minEntropy(pmf) - MinEntropy.conditionalMinEntropy(pmf, matrix));
    }

    public static double minEntropyLeak(ProbDist pd, Channel channel) {
        double[] pmf = pd.probDistToPMFArray(channel.getInputNames());
        double[][] matrix = channel.getMatrix();
        if (pmf != null) {
            return MinEntropy.minEntropyLeak(pmf, matrix);
        }
        return -1.0;
    }

    public static double minEntropyLeakError20130114(double[] pmf, double[][] matrix, int noOfTests, int noOfOutputs) {
        double S = 0.05;
        double e0 = Math.sqrt(2.0 * (1.0 - InfoTheory.log2(S)) / ((double)noOfTests * InfoTheory.log2(Math.E)));
        double vx = 0.0;
        int i = 0;
        while (i < pmf.length) {
            vx = Math.max(vx, pmf[i]);
            ++i;
        }
        double e1 = (vx = Math.min(vx, 1.0)) > e0 ? Math.max(InfoTheory.log2(1.0 + e0 / vx), -InfoTheory.log2(1.0 - e0 / vx)) : InfoTheory.log2(1.0 + e0 / vx);
        double e2 = (double)noOfOutputs * Math.sqrt(2.0 * (1.0 - InfoTheory.log2(S)) / ((double)noOfTests * InfoTheory.log2(Math.E)));
        double vxy = 0.0;
        int j = 0;
        while (j < matrix[0].length) {
            double maxProb = 0.0;
            int i2 = 0;
            while (i2 < pmf.length) {
                maxProb = Math.max(maxProb, pmf[i2] * matrix[i2][j]);
                ++i2;
            }
            vxy += maxProb;
            ++j;
        }
        double e3 = (vxy = Math.min(vxy, 1.0)) > e2 ? Math.max(InfoTheory.log2(1.0 + e2 / vxy), -InfoTheory.log2(1.0 - e2 / vxy)) : InfoTheory.log2(1.0 + e2 / vxy);
        return e3;
    }

    public static double[] minEntropyLeakConfidenceIntervalVajda(double[] pmf, double[][] matrix, int noOfTests, int[] sampleSizeGivenOutput, int noOfOutputs) {
        double confidenceLevel = 0.975;
        double confidenceLevelGivenOutput = Math.pow(0.975, 1.0 / (double)matrix[0].length);
        double cl1 = Math.sqrt(confidenceLevelGivenOutput);
        double tmp1 = Math.log(2.0 / (1.0 - cl1));
        double Ly = (double)noOfTests / (double)matrix[0].length;
        double error1 = Math.sqrt(2.0 / Ly * tmp1);
        if (InfoTheory.verbose >= 7) {
            System.out.println("noTest" + noOfTests);
            System.out.println("mat   " + matrix[0].length);
            System.out.println("Ly =  " + Ly);
        }
        double cl2 = confidenceLevelGivenOutput / cl1;
        double tmp2 = Math.log(2.0 / (1.0 - cl2));
        double error2 = (4.0 * tmp2 + Math.sqrt(16.0 * tmp2 * tmp2 + (double)(72 * noOfTests) * tmp2)) / (double)(12 * noOfTests);
        double accuracy = 0.01;
        double productOfcl = 1.0;
        int loop = 0;
        while (Math.abs(productOfcl - 0.975) > 0.01) {
            productOfcl = 1.0;
            int sign = -1;
            ++loop;
            int j = 0;
            while (j < matrix[0].length) {
                double cy1 = 1.0 - 2.0 * Math.exp((double)(-sampleSizeGivenOutput[j]) * error1 * error1 / 2.0);
                double cy2 = 1.0 - 2.0 * Math.exp((double)(-6 * noOfTests) * error2 * error2 / (3.0 + 4.0 * error2));
                productOfcl *= cy1 * cy2;
                ++j;
            }
            if (productOfcl < 0.975) {
                error1 += 0.01;
                if (sign == 0) break;
                sign = 1;
                continue;
            }
            error1 -= 0.01;
            if (sign == 1) break;
            sign = 0;
        }
        double[] outputdist = InfoTheory.outputDist(pmf, matrix);
        double[] max_xy = new double[matrix[0].length];
        int j = 0;
        while (j < matrix[0].length) {
            max_xy[j] = 0.0;
            int i = 0;
            while (i < pmf.length) {
                max_xy[j] = Math.max(max_xy[j], pmf[i] * matrix[i][j] / outputdist[j]);
                ++i;
            }
            ++j;
        }
        double lower = 0.0;
        int j2 = 0;
        while (j2 < matrix[0].length) {
            lower += Math.max(0.0, max_xy[j2] - error1) * Math.max(0.0, outputdist[j2] - error2);
            ++j2;
        }
        double MELMin = Math.max(0.0, MinEntropy.minEntropy(pmf) + InfoTheory.log2(lower));
        if (Double.isNaN(MELMin)) {
            MELMin = 0.0;
        }
        double upper = 0.0;
        int j3 = 0;
        while (j3 < matrix[0].length) {
            upper += Math.min(1.0, max_xy[j3] + error1) * Math.min(1.0, outputdist[j3] + error2);
            ++j3;
        }
        double MELMax = MinEntropy.minEntropy(pmf) + InfoTheory.log2(Math.min(upper, 1.0));
        double[] result = new double[]{MELMin, MELMax};
        return result;
    }

    private static double minEntropyLeakLowerBoundConfidenceIntervalChiSquare(Observations obs, ArrayList<Integer> priorCountsMerged, double chiSquarePrior) {
        int[] odMax = MinEntropy.obsMaximizingVulnerability(priorCountsMerged, chiSquarePrior);
        if (odMax == null) {
            return Double.NaN;
        }
        double[] pmfMax = Observations.observationsToPMF(odMax);
        double condMELupper = MinEntropy.minConditionalEntropyUpperBoundConfidenceIntervalChiSquare(obs);
        double lower = MinEntropy.minEntropy(pmfMax) - condMELupper;
        return Math.max(0.0, lower);
    }

    public static double minEntropyLeakLowerBoundConfidenceIntervalChiSquare(Observations obs) {
        int[] od;
        ArrayList<Integer> priorCountsMerged;
        int freedomPrior;
        if (InfoTheory.verbose >= 1 && !obs.hasSufficientSamplesForMEL()) {
            System.out.println("Caution: The sample size is not large enough to estimate the confidence interval.");
            if (InfoTheory.verbose >= 3) {
                obs.printObservationsMatrix();
            }
        }
        if ((freedomPrior = MinEntropy.degreeOfFreedomPrior(priorCountsMerged = MinEntropy.mergedData(od = obs.getInputObservationsArray(), 5))) <= 0) {
            if (InfoTheory.verbose >= 1) {
                System.out.println("Error: Cannot estimate the confidence interval.");
                System.out.println("  The sample size is too small.");
            }
            return Double.NaN;
        }
        double chiSquarePrior = Stats.chiSqu95Interval(freedomPrior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  Degree of freedom (Prior)     = %3d", freedomPrior);
            System.out.println("  chi-square = " + chiSquarePrior);
        }
        return MinEntropy.minEntropyLeakLowerBoundConfidenceIntervalChiSquare(obs, priorCountsMerged, chiSquarePrior);
    }

    private static double minEntropyLeakUpperBoundConfidenceIntervalChiSquare(Observations obs, ArrayList<Integer> priorCountsMerged, double chiSquarePrior) {
        int[] odMin = MinEntropy.obsMinimizingVulnerability(priorCountsMerged, chiSquarePrior);
        if (odMin == null) {
            return Double.NaN;
        }
        double[] pmfMin = Observations.observationsToPMF(odMin);
        double condMELlower = MinEntropy.minConditionalEntropyLowerBoundConfidenceIntervalChiSquare(obs);
        double upper = MinEntropy.minEntropy(pmfMin) - condMELlower;
        return upper;
    }

    public static double minEntropyLeakUpperBoundConfidenceIntervalChiSquare(Observations obs) {
        int[] od;
        ArrayList<Integer> priorCountsMerged;
        int freedomPrior;
        if (InfoTheory.verbose >= 1 && !obs.hasSufficientSamplesForMEL()) {
            System.out.println("Caution: The sample size is not large enough to estimate the confidence interval.");
            if (InfoTheory.verbose >= 3) {
                obs.printObservationsMatrix();
            }
        }
        if ((freedomPrior = MinEntropy.degreeOfFreedomPrior(priorCountsMerged = MinEntropy.mergedData(od = obs.getInputObservationsArray(), 5))) <= 0) {
            if (InfoTheory.verbose >= 1) {
                System.out.println("Error: Cannot estimate the confidence interval.");
                System.out.println("  The sample size is too small.");
            }
            return Double.NaN;
        }
        double chiSquarePrior = Stats.chiSqu95Interval(freedomPrior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  Degree of freedom (Prior)     = %3d", freedomPrior);
            System.out.println("  chi-square = " + chiSquarePrior);
        }
        return MinEntropy.minEntropyLeakUpperBoundConfidenceIntervalChiSquare(obs, priorCountsMerged, chiSquarePrior);
    }

    public static double[] minEntropyLeakConfidenceIntervalChiSquare(Observations obs) {
        int[][] jodMax;
        int[] od;
        ArrayList<Integer> priorCountsMerged;
        int freedomPrior;
        if (InfoTheory.verbose >= 1 && !obs.hasSufficientSamplesForMEL()) {
            System.out.println("Caution: The sample size is not large enough to estimate the confidence interval.");
            if (InfoTheory.verbose >= 3) {
                obs.printObservationsMatrix();
            }
        }
        if ((freedomPrior = MinEntropy.degreeOfFreedomPrior(priorCountsMerged = MinEntropy.mergedData(od = obs.getInputObservationsArray(), 5))) <= 0) {
            if (InfoTheory.verbose >= 1) {
                System.out.println("Error: Cannot estimate the confidence interval.");
                System.out.println("  The sample size is too small.");
            }
            double[] result = new double[]{Double.NaN, Double.NaN};
            return result;
        }
        double chiSquarePrior = Stats.chiSqu95Interval(freedomPrior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  Degree of freedom (Prior)     = %3d", freedomPrior);
            System.out.println("  chi-square = " + chiSquarePrior);
        }
        int noOfInputs = obs.getUniqueInputCount();
        int noOfOutputs = obs.getUniqueOutputCount();
        int[] odMax = MinEntropy.obsMaximizingVulnerability(priorCountsMerged, chiSquarePrior);
        if (odMax == null) {
            double[] result = new double[]{Double.NaN, Double.NaN};
            return result;
        }
        double[] pmfMax = Observations.observationsToPMF(odMax);
        int[] odMin = MinEntropy.obsMinimizingVulnerability(priorCountsMerged, chiSquarePrior);
        if (odMin == null) {
            double[] result = new double[]{Double.NaN, Double.NaN};
            return result;
        }
        double[] pmfMin = Observations.observationsToPMF(odMin);
        int[][] jod = obs.getObservationsMatrix();
        ArrayList<ArrayList<Integer>> list = MinEntropy.mergedData(jod, 5);
        int freedomPosterior = MinEntropy.degreeOfFreedomPosterior(list);
        double chiSquarePosterior = Stats.chiSqu95Interval(freedomPosterior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  Degree of freedom (Posterior) = %3d", freedomPosterior);
            System.out.println("  chi-square = " + chiSquarePosterior);
        }
        if ((jodMax = MinEntropy.obsMaximizingCondVulnerability(list, chiSquarePosterior, noOfInputs, noOfOutputs)) == null) {
            double[] result = new double[]{Double.NaN, Double.NaN};
            return result;
        }
        double[][] jpmfMax = Observations.observationsToJPMF(jodMax);
        int[][] jodMin = MinEntropy.obsMinimizingCondVulnerability(list, chiSquarePosterior, noOfInputs, noOfOutputs);
        if (jodMin == null) {
            double[] result = new double[]{Double.NaN, Double.NaN};
            return result;
        }
        double[][] jpmfMin = Observations.observationsToJPMF(jodMin);
        double lower = MinEntropy.minEntropy(pmfMax) + InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMin));
        double upper = MinEntropy.minEntropy(pmfMin) + InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMax));
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  minEntropy =     [ %13.10f, %13.10f ] ", MinEntropy.minEntropy(pmfMax), MinEntropy.minEntropy(pmfMin));
            System.out.printf("  Chi-square: ( %6.3f, %6.3f )\n", Stats.chiSquare(od, odMax), Stats.chiSquare(od, odMin));
            System.out.printf("  condMinEntropy = [ %13.10f, %13.10f ] ", -InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMax)), -InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMin)));
            System.out.printf("  Chi-square: ( %6.3f, %6.3f )\n", MinEntropy.chiSquare(MinEntropy.listToMatrix(list, noOfInputs, noOfOutputs), jodMax), MinEntropy.chiSquare(MinEntropy.listToMatrix(list, noOfInputs, noOfOutputs), jodMin));
        }
        double[] result = new double[]{Math.max(0.0, lower), upper};
        return result;
    }

    private static double minConditionalEntropyLowerBoundConfidenceIntervalChiSquare(Observations obs, ArrayList<ArrayList<Integer>> list, double chiSquarePosterior) {
        int noOfOutputs;
        int noOfInputs = obs.getUniqueInputCount();
        int[][] jodMax = MinEntropy.obsMaximizingCondVulnerability(list, chiSquarePosterior, noOfInputs, noOfOutputs = obs.getUniqueOutputCount());
        if (jodMax == null) {
            return Double.NaN;
        }
        double[][] jpmfMax = Observations.observationsToJPMF(jodMax);
        double lower = -InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMax));
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  condMinEntropy <= %13.10f", -InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMax)));
            System.out.printf("  Chi-square: %6.3f\n", MinEntropy.chiSquare(MinEntropy.listToMatrix(list, noOfInputs, noOfOutputs), jodMax));
        }
        return Math.max(0.0, lower);
    }

    public static double minConditionalEntropyLowerBoundConfidenceIntervalChiSquare(Observations obs) {
        if (InfoTheory.verbose >= 1 && !obs.hasSufficientSamplesForMEL()) {
            System.out.println("Caution: The sample size is not large enough to estimate the confidence interval.");
            if (InfoTheory.verbose >= 3) {
                obs.printObservationsMatrix();
            }
        }
        int[][] jod = obs.getObservationsMatrix();
        ArrayList<ArrayList<Integer>> list = MinEntropy.mergedData(jod, 5);
        int freedomPosterior = MinEntropy.degreeOfFreedomPosterior(list);
        double chiSquarePosterior = Stats.chiSqu95Interval(freedomPosterior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  Degree of freedom (Posterior) = %3d", freedomPosterior);
            System.out.println("  chi-square = " + chiSquarePosterior);
        }
        double maximum = MinEntropy.minEntropy(obs.getInputProbDist());
        return Math.min(maximum, MinEntropy.minConditionalEntropyLowerBoundConfidenceIntervalChiSquare(obs, list, chiSquarePosterior));
    }

    private static double minConditionalEntropyUpperBoundConfidenceIntervalChiSquare(Observations obs, ArrayList<ArrayList<Integer>> list, double chiSquarePosterior) {
        int noOfOutputs;
        int noOfInputs = obs.getUniqueInputCount();
        int[][] jodMin = MinEntropy.obsMinimizingCondVulnerability(list, chiSquarePosterior, noOfInputs, noOfOutputs = obs.getUniqueOutputCount());
        if (jodMin == null) {
            return Double.NaN;
        }
        double[][] jpmfMin = Observations.observationsToJPMF(jodMin);
        double upper = -InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMin));
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  condMinEntropy <= %13.10f ", -InfoTheory.log2(MinEntropy.conditionalVulnerability(jpmfMin)));
            System.out.printf("  Chi-square: %6.3f\n", MinEntropy.chiSquare(MinEntropy.listToMatrix(list, noOfInputs, noOfOutputs), jodMin));
        }
        return Math.max(0.0, upper);
    }

    public static double minConditionalEntropyUpperBoundConfidenceIntervalChiSquare(Observations obs) {
        if (InfoTheory.verbose >= 1 && !obs.hasSufficientSamplesForMEL()) {
            System.out.println("Caution: The sample size is not large enough to estimate the confidence interval.");
            if (InfoTheory.verbose >= 3) {
                obs.printObservationsMatrix();
            }
        }
        int[][] jod = obs.getObservationsMatrix();
        ArrayList<ArrayList<Integer>> list = MinEntropy.mergedData(jod, 5);
        int freedomPosterior = MinEntropy.degreeOfFreedomPosterior(list);
        double chiSquarePosterior = Stats.chiSqu95Interval(freedomPosterior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  Degree of freedom (Posterior) = %3d", freedomPosterior);
            System.out.println("  chi-square = " + chiSquarePosterior);
        }
        return MinEntropy.minConditionalEntropyUpperBoundConfidenceIntervalChiSquare(obs, list, chiSquarePosterior);
    }

    public static double[] minConditionalEntropyConfidenceIntervalChiSquare(Observations obs) {
        if (InfoTheory.verbose >= 1 && !obs.hasSufficientSamplesForMEL()) {
            System.out.println("Caution: The sample size is not large enough to estimate the confidence interval.");
            if (InfoTheory.verbose >= 3) {
                obs.printObservationsMatrix();
            }
        }
        int[][] jod = obs.getObservationsMatrix();
        ArrayList<ArrayList<Integer>> list = MinEntropy.mergedData(jod, 5);
        int freedomPosterior = MinEntropy.degreeOfFreedomPosterior(list);
        double chiSquarePosterior = Stats.chiSqu95Interval(freedomPosterior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  Degree of freedom (Posterior) = %3d", freedomPosterior);
            System.out.println("  chi-square = " + chiSquarePosterior);
        }
        double lower = MinEntropy.minConditionalEntropyLowerBoundConfidenceIntervalChiSquare(obs, list, chiSquarePosterior);
        double upper = MinEntropy.minConditionalEntropyUpperBoundConfidenceIntervalChiSquare(obs, list, chiSquarePosterior);
        if (InfoTheory.verbose >= 5) {
            System.out.printf("  condMinEntropy = [ %13.10f, %13.10f ] ", lower, upper);
        }
        double[] result = new double[]{Math.max(0.0, lower), upper};
        return result;
    }

    public static boolean hasSufficientSamplesForMEL(Observations obs, int numCells) {
        int noOfInputs = obs.getUniqueInputCount();
        int noOfOutputs = obs.getUniqueOutputCount();
        int countSmallFrequencies = 0;
        ArrayList<ArrayList<Integer>> list = MinEntropy.mergedData(obs.getObservationsMatrix(), 0);
        double chiSquarePosterior = Stats.chiSqu95Interval(MinEntropy.degreeOfFreedomPosterior(list));
        int[][] jodMin = MinEntropy.obsMinimizingCondVulnerability(list, chiSquarePosterior, noOfInputs, noOfOutputs);
        int numRow = 0;
        while (numRow < jodMin.length) {
            int numCol = 0;
            while (numCol < jodMin[0].length) {
                if (jodMin[numRow][numCol] != 0 && jodMin[numRow][numCol] < 5) {
                    ++countSmallFrequencies;
                }
                if ((double)countSmallFrequencies > (double)numCells * 0.2) {
                    return false;
                }
                ++numCol;
            }
            ++numRow;
        }
        return true;
    }

    private static int[][] listToMatrix(ArrayList<ArrayList<Integer>> list, int noOfInputs, int noOfOutputs) {
        int[][] matrix = new int[noOfInputs][noOfOutputs];
        int numCol = 0;
        while (numCol < noOfOutputs) {
            int numRow = 0;
            while (numRow < noOfInputs) {
                matrix[numRow][numCol] = numCol < list.size() && numRow < list.get(numCol).size() ? list.get(numCol).get(numRow) : 0;
                ++numRow;
            }
            ++numCol;
        }
        return matrix;
    }

    private static double chiSquare(int[][] observedCounts, int[][] expectedCounts) {
        if (observedCounts.length != expectedCounts.length || observedCounts[0].length != expectedCounts[0].length) {
            if (InfoTheory.verbose >= 1) {
                System.out.println("Error: The lengths of observed and expected counts are different.");
            }
            return Double.NaN;
        }
        int size = observedCounts.length * observedCounts[0].length;
        ArrayList<Integer> observedCountsArrayList = new ArrayList<Integer>();
        ArrayList<Integer> expectedCountsArrayList = new ArrayList<Integer>();
        int index = 0;
        int numRow = 0;
        while (numRow < observedCounts.length) {
            int numCol = 0;
            while (numCol < observedCounts[0].length) {
                if (observedCounts[numRow][numCol] != 0 && expectedCounts[numRow][numCol] != 0) {
                    observedCountsArrayList.add(observedCounts[numRow][numCol]);
                    expectedCountsArrayList.add(expectedCounts[numRow][numCol]);
                    ++index;
                }
                ++numCol;
            }
            ++numRow;
        }
        int[] observedCountsArray = new int[index];
        int[] expectedCountsArray = new int[index];
        if (InfoTheory.verbose >= 7) {
            System.out.println("  ------------------------------");
            System.out.println("  ObservedCounts, ExpectedCounts");
        }
        int i = 0;
        while (i < index) {
            observedCountsArray[i] = (Integer)observedCountsArrayList.get(i);
            expectedCountsArray[i] = (Integer)expectedCountsArrayList.get(i);
            if (InfoTheory.verbose >= 7) {
                System.out.println("  " + observedCountsArray[i] + ", " + expectedCountsArray[i]);
            }
            ++i;
        }
        if (InfoTheory.verbose >= 7) {
            System.out.println("  ------------------------------");
        }
        double chiSq = Stats.chiSquare(observedCountsArray, expectedCountsArray);
        return chiSq;
    }

    private static int degreeOfFreedomPrior(ArrayList<Integer> column) {
        return column.size() - 1;
    }

    private static int degreeOfFreedomPosterior(ArrayList<ArrayList<Integer>> list) {
        int freedom = 0;
        for (ArrayList<Integer> column : list) {
            freedom += column.size();
        }
        return freedom - 1;
    }

    private static ArrayList<ArrayList<Integer>> mergedData(int[][] jod, int threshold) {
        int noOfInputs = jod.length;
        int noOfOutputs = jod[0].length;
        ArrayList<ArrayList<Integer>> list = new ArrayList<ArrayList<Integer>>();
        int numCol = 0;
        while (numCol < noOfOutputs) {
            int[] column = new int[noOfInputs];
            int numRow = 0;
            while (numRow < noOfInputs) {
                column[numRow] = jod[numRow][numCol];
                ++numRow;
            }
            ArrayList<Integer> columnModified = MinEntropy.mergedData(column, threshold);
            list.add(columnModified);
            ++numCol;
        }
        return list;
    }

    private static ArrayList<Integer> mergedData(int[] od, int threshold) {
        if (threshold <= 0) {
            threshold = 1;
        }
        int size = od.length;
        ArrayList<Integer> column = new ArrayList<Integer>();
        int minimum = 0;
        int numRowMin = 0;
        int mergedValue = 0;
        int numRow = 0;
        while (numRow < size) {
            if (od[numRow] < threshold) {
                mergedValue += od[numRow];
            } else if (minimum == 0) {
                minimum = od[numRow];
                numRowMin = numRow;
            } else if (od[numRow] < minimum) {
                minimum = od[numRow];
                numRowMin = numRow;
            }
            ++numRow;
        }
        numRow = 0;
        while (numRow < size) {
            if (od[numRow] >= threshold) {
                if (numRow == numRowMin && mergedValue < threshold) {
                    column.add(od[numRow] + mergedValue);
                } else {
                    column.add(od[numRow]);
                }
            }
            ++numRow;
        }
        if (mergedValue >= threshold) {
            column.add(mergedValue);
        }
        return column;
    }

    private static int[] obsMaximizingVulnerability(ArrayList<Integer> priorCounts, double chiSquare) {
        int size = priorCounts.size();
        if (size <= 0) {
            if (InfoTheory.verbose >= 1) {
                System.out.println("Error: Cannot estimate the confidence interval.");
                System.out.println("  The sample size is too small.");
            }
            return null;
        }
        int[] od = new int[size];
        int i = 0;
        while (i < size) {
            od[i] = priorCounts.get(i);
            ++i;
        }
        int maxIndex = Stats.maxIndex(od);
        int maxCount = od[maxIndex];
        int[] odMax = new int[size];
        if (size == 1) {
            odMax[0] = priorCounts.get(0);
            int i2 = 1;
            while (i2 < size) {
                odMax[i2] = 0;
                ++i2;
            }
            return odMax;
        }
        ArrayList<Pair<Integer, Integer>> odIndexed = new ArrayList<Pair<Integer, Integer>>();
        int i3 = 0;
        while (i3 < size) {
            Pair<Integer, Integer> p = new Pair<Integer, Integer>(od[i3], i3);
            odIndexed.add(p);
            ++i3;
        }
        ComparatorIntegers comparator = new ComparatorIntegers();
        Collections.sort(odIndexed, comparator);
        int countAdded = (int)Math.sqrt(chiSquare / (double)size * (double)maxCount);
        int sumOfOthers = 0;
        int i4 = 0;
        while (i4 < size) {
            if (i4 != maxIndex) {
                sumOfOthers += Math.max(5, od[i4]);
            }
            ++i4;
        }
        if (countAdded > sumOfOthers) {
            countAdded = sumOfOthers;
        }
        odMax[maxIndex] = od[maxIndex] + countAdded;
        int countSubtracted = countAdded;
        int i5 = 0;
        while (i5 < size) {
            int index = (Integer)((Pair)odIndexed.get(i5)).getElement2();
            if (index != maxIndex) {
                if (od[index] > 0) {
                    if (od[index] < 5) {
                        odMax[index] = 5;
                    } else {
                        odMax[index] = Math.max(5, od[index] - countSubtracted / Math.max(1, size - i5 - 1));
                        countSubtracted -= od[index] - odMax[index];
                    }
                } else {
                    odMax[i5] = 0;
                }
            }
            ++i5;
        }
        double tmpChiSquare = Stats.chiSquare(od, odMax);
        int numIterate = 0;
        do {
            if (tmpChiSquare > chiSquare && countAdded >= 1) {
                if (tmpChiSquare - chiSquare > 10.0 && --countAdded > 40) {
                    countAdded -= 30;
                }
            } else {
                ++countAdded;
                if (chiSquare - tmpChiSquare > 10.0) {
                    countAdded += 30;
                }
            }
            odMax[maxIndex] = od[maxIndex] + countAdded;
            countSubtracted = countAdded;
            int i6 = 0;
            while (i6 < size) {
                int index = (Integer)((Pair)odIndexed.get(i6)).getElement2();
                if (index != maxIndex) {
                    if (od[index] > 0) {
                        if (od[index] < 5) {
                            odMax[index] = 5;
                        } else {
                            odMax[index] = Math.max(5, od[index] - countSubtracted / Math.max(1, size - i6 - 1));
                            countSubtracted -= od[index] - odMax[index];
                        }
                    } else {
                        odMax[i6] = 0;
                    }
                }
                ++i6;
            }
        } while (Math.abs((tmpChiSquare = Stats.chiSquare(od, odMax)) - chiSquare) > 0.05 && ++numIterate < 1000 && countAdded > 0);
        return odMax;
    }

    private static int[] uniformFrequenciesArray(int[] array) {
        int sum = 0;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int freq = nArray[n2];
            sum += freq;
            ++n2;
        }
        int mean = sum / array.length;
        int remained = sum - mean * array.length;
        int[] uniformFrequencies = new int[array.length];
        int i = 0;
        while (i < array.length) {
            uniformFrequencies[i] = mean;
            if (i < remained) {
                int n3 = i;
                uniformFrequencies[n3] = uniformFrequencies[n3] + 1;
            }
            ++i;
        }
        return uniformFrequencies;
    }

    private static int[] obsMinimizingVulnerability(ArrayList<Integer> priorCounts, double chiSquare) {
        int AdjustedCounts;
        int size = priorCounts.size();
        if (size <= 0) {
            if (InfoTheory.verbose >= 1) {
                System.out.println("Error: Cannot estimate the confidence interval.");
                System.out.println("  The sample size is too small.");
            }
            return null;
        }
        int[] od = new int[size];
        int average = 0;
        int i = 0;
        while (i < size) {
            od[i] = priorCounts.get(i);
            average += od[i];
            ++i;
        }
        average = average / size - 1;
        int maxIndex = Stats.maxIndex(od);
        int maxCount = od[maxIndex];
        chiSquare = Math.min(chiSquare, Stats.chiSquare(od, MinEntropy.uniformFrequenciesArray(od)));
        int[] odMin = new int[size];
        if (size == 1) {
            odMin[0] = priorCounts.get(0);
            int i2 = 1;
            while (i2 < size) {
                odMin[i2] = 0;
                ++i2;
            }
            return odMin;
        }
        ArrayList<Pair<Integer, Integer>> odIndexed = new ArrayList<Pair<Integer, Integer>>();
        int i3 = 0;
        while (i3 < size) {
            Pair<Integer, Integer> p = new Pair<Integer, Integer>(od[i3], i3);
            odIndexed.add(p);
            ++i3;
        }
        ComparatorIntegers comparator = new ComparatorIntegers();
        Collections.sort(odIndexed, comparator);
        double tmp = chiSquare / (double)size;
        int countSubtracted = (int)(Math.sqrt(tmp * tmp + 4.0 * tmp * (double)maxCount) - tmp / 2.0);
        int IncreaseCounts = AdjustedCounts = (countSubtracted = Math.min(countSubtracted, maxCount - average));
        int DecreaseCounts = AdjustedCounts;
        double tmpChiSquare = 0.0;
        int numIterate = 0;
        do {
            int index;
            int j;
            int index2;
            int j2;
            int index22;
            int index1;
            int i4 = 0;
            while (i4 < size) {
                odMin[i4] = od[i4];
                ++i4;
            }
            i4 = 0;
            while (i4 < size - 1) {
                if (IncreaseCounts > 0) {
                    index1 = (Integer)((Pair)odIndexed.get(0)).getElement2();
                    index22 = (Integer)((Pair)odIndexed.get(i4 + 1)).getElement2();
                    if (IncreaseCounts >= (odMin[index22] - odMin[index1]) * (i4 + 1)) {
                        IncreaseCounts -= (odMin[index22] - odMin[index1]) * (i4 + 1);
                        j2 = 0;
                        while (j2 <= i4) {
                            index2 = (Integer)((Pair)odIndexed.get(j2)).getElement2();
                            odMin[index2] = odMin[index22];
                            ++j2;
                        }
                    } else {
                        int sumAdded = 0;
                        j = 0;
                        while (j <= i4) {
                            index = (Integer)((Pair)odIndexed.get(j)).getElement2();
                            int added = IncreaseCounts / (i4 + 1);
                            sumAdded += added;
                            int n = index;
                            odMin[n] = odMin[n] + added;
                            ++j;
                        }
                        int n = index2 = ((Integer)((Pair)odIndexed.get(i4)).getElement2()).intValue();
                        odMin[n] = odMin[n] + (IncreaseCounts - sumAdded);
                        IncreaseCounts = 0;
                    }
                }
                ++i4;
            }
            i4 = size - 1;
            while (i4 > 0) {
                if (DecreaseCounts > 0) {
                    index1 = (Integer)((Pair)odIndexed.get(size - 1)).getElement2();
                    if (DecreaseCounts >= (od[index1] - od[index22 = ((Integer)((Pair)odIndexed.get(i4 - 1)).getElement2()).intValue()]) * (size - i4)) {
                        j2 = size - 1;
                        while (j2 >= i4) {
                            index2 = (Integer)((Pair)odIndexed.get(j2)).getElement2();
                            odMin[index2] = od[index22];
                            --j2;
                        }
                        DecreaseCounts -= od[index1] - od[index22] * (size - i4);
                    } else {
                        int sumSubtracted = 0;
                        j = size - 1;
                        while (j >= i4) {
                            index = (Integer)((Pair)odIndexed.get(j)).getElement2();
                            int subtracted = DecreaseCounts / (size - i4);
                            sumSubtracted += subtracted;
                            int n = index;
                            odMin[n] = odMin[n] - subtracted;
                            --j;
                        }
                        int n = index2 = ((Integer)((Pair)odIndexed.get(i4)).getElement2()).intValue();
                        odMin[n] = odMin[n] - (DecreaseCounts - sumSubtracted);
                        DecreaseCounts = 0;
                    }
                }
                --i4;
            }
            tmpChiSquare = Stats.chiSquare(od, odMin);
            if (tmpChiSquare > chiSquare) {
                --AdjustedCounts;
                if (tmpChiSquare - chiSquare > 10.0 && IncreaseCounts > 40) {
                    IncreaseCounts -= 30;
                }
            } else {
                ++AdjustedCounts;
                if (chiSquare - tmpChiSquare > 10.0) {
                    IncreaseCounts += 30;
                }
            }
            IncreaseCounts = AdjustedCounts;
            DecreaseCounts = AdjustedCounts;
        } while (Math.abs(tmpChiSquare - chiSquare) > 0.05 && ++numIterate < 1000 && IncreaseCounts > 0);
        return odMin;
    }

    private static int[][] obsMaximizingCondVulnerability(ArrayList<ArrayList<Integer>> posteriorCounts, double chiSquare, int noOfInputs, int noOfOutputs) {
        int[][] obsMatrixMax = new int[noOfInputs][noOfOutputs];
        double sumChiSquare = 0.0;
        int numCol = 0;
        while (numCol < noOfOutputs) {
            ArrayList<Integer> column = new ArrayList<Integer>();
            int numRow = 0;
            while (numRow < noOfInputs) {
                if (numCol < posteriorCounts.size() && numRow < posteriorCounts.get(numCol).size()) {
                    int expectedCounts = posteriorCounts.get(numCol).get(numRow);
                    column.add(expectedCounts);
                }
                ++numRow;
            }
            int[] columnModifed = MinEntropy.obsMaximizingVulnerability(column, 1.5 * (chiSquare - sumChiSquare) / (double)(noOfOutputs - numCol));
            if (columnModifed == null) {
                return null;
            }
            int[] columnObserved = new int[column.size()];
            int numRow2 = 0;
            while (numRow2 < column.size()) {
                columnObserved[numRow2] = column.get(numRow2);
                ++numRow2;
            }
            sumChiSquare += Stats.chiSquare(columnObserved, columnModifed);
            numRow2 = 0;
            while (numRow2 < noOfInputs) {
                obsMatrixMax[numRow2][numCol] = numRow2 < column.size() ? columnModifed[numRow2] : 0;
                ++numRow2;
            }
            ++numCol;
        }
        return obsMatrixMax;
    }

    private static int[][] obsMinimizingCondVulnerability(ArrayList<ArrayList<Integer>> posteriorCounts, double chiSquare, int noOfInputs, int noOfOutputs) {
        int[][] obsMatrixMin = new int[noOfInputs][noOfOutputs];
        double sumChiSquare = 0.0;
        int numCol = 0;
        while (numCol < noOfOutputs) {
            ArrayList<Integer> column = new ArrayList<Integer>();
            int numRow = 0;
            while (numRow < noOfInputs) {
                if (numCol < posteriorCounts.size() && numRow < posteriorCounts.get(numCol).size()) {
                    int expectedCounts = posteriorCounts.get(numCol).get(numRow);
                    column.add(expectedCounts);
                }
                ++numRow;
            }
            int[] columnModifed = MinEntropy.obsMinimizingVulnerability(column, 1.5 * (chiSquare - sumChiSquare) / (double)(noOfOutputs - numCol));
            if (columnModifed == null) {
                return null;
            }
            int[] columnObserved = new int[column.size()];
            int numRow2 = 0;
            while (numRow2 < column.size()) {
                columnObserved[numRow2] = column.get(numRow2);
                ++numRow2;
            }
            sumChiSquare += Stats.chiSquare(columnObserved, columnModifed);
            numRow2 = 0;
            while (numRow2 < noOfInputs) {
                obsMatrixMin[numRow2][numCol] = numRow2 < column.size() ? columnModifed[numRow2] : 0;
                ++numRow2;
            }
            ++numCol;
        }
        return obsMatrixMin;
    }

    public static double minCapacity(double[][] matrix) {
        double sum = 0.0;
        int y = 0;
        while (y < matrix[0].length) {
            double maxProb = 0.0;
            int x = 0;
            while (x < matrix.length) {
                maxProb = Math.max(matrix[x][y], maxProb);
                ++x;
            }
            sum += maxProb;
            ++y;
        }
        return InfoTheory.log(sum, 2);
    }

    public static double minCapacity(Channel channel) {
        return MinEntropy.minCapacity(channel.getMatrix());
    }
}

