B<?php
require_once('../lib.php');

SetHeaderTitle('leakiEst Example Datasets');
AddBreadcrumb(array('Examples', '/research/projects/infotools/leakiest/examples/index.php'));

HTMLHeader();
PageStart();

$latest_version = preg_replace('/\.\.\/downloads\/leakiest-(.*)\.tar\.bz2/', '$1', end(glob("../downloads/leakiest-*.tar.bz2")));
?>

<h2>Examples</h2>
<p>This is a repository of sample datasets that can be processed with leakiEst.</p>
<!-- <p>All of the following datasets together with leakiest-<?php echo $latest_version ?>.jar etc are available in the download page.</p> -->

<ul>
	<li><a href="prng.php">Pseudorandom number generators</a></li>
	<li><a href="epassports.php">e-Passport traceability</a></li>
	<li><a href="tor.php">Fingerprinting encrypted Tor traffic</a></li>
	<li><a href="javascript.php">Malicious JavaScript</a></li>
	<li><a href="dcnets.php">TLS-encrypted dining cryptographers networks</a></li>
</ul>

<p>All of these datasets together with leakiest-<?php echo $latest_version ?>.jar etc are available below:</p>

<div class="boxout boxout_archive">
  <h2><a href="../downloads/leakiest-<?php echo $latest_version ?>.tar.bz2">Download</a></h2>
  <p>Version <?php echo $latest_version ?>, all files (executable Java archive, datasets, manual, Javadoc, source codes), <?php printf("%.1f", filesize("../downloads/leakiest-$latest_version.tar.bz2") / 1024) ?> KB</p>
</div>

<!--
<div class="boxout boxout_archive">
        <h2><a href="examples.tar.bz2">Download all sample datasets</a></h2>
        <p><?php echo size_readable(filesize("examples.tar.bz2")) ?></p>
</div>
-->

<?php
PageEnd();
HTMLFooter();
?>
1;
2c