B1;2c<?php
require_once('../lib.php');

SetHeaderTitle('leakiEst TLS-Encrypted Dining Cryptographers Networks Example Dataset');
AddBreadcrumb(array('Examples', '/research/projects/infotools/leakiest/examples/index.php'));
AddBreadcrumb(array('TLS-Encrypted Dining Cryptographers Networks', '/research/projects/infotools/leakiest/examples/dcnets.php'));

HTMLHeader();
PageStart();

$latest_version = preg_replace('/\.\.\/downloads\/leakiest-(.*)\.tar\.bz2/', '$1', end(glob("../downloads/leakiest-*.tar.bz2")));
?>

<h2>Example: TLS-Encrypted Dining Cryptographers Networks</h2>

<?php DownloadDataset('dataset-dcnets.tar.bz2') ?>

<p>This dataset is an observation file containing 10,000 executions of a <a href="https://en.wikipedia.org/wiki/Dining_cryptographers_problem">dining cryptographers network</a> in which the secret payer sends his credit card number over an encrypted link before reporting the values of his coins; the public outputs are the values of the coins as announced by each participant, in the order in which they announce them. The possible source of leakage here is that in a broken implementation, the payer may take longer to announce the value of their coin, which may reveal the identity of the payer.</p>

<h3>Command lines and outputs</h3>
<p>The configuration files need to be located in the same directory as leakiest-<?php echo $latest_version ?>.jar.</p>
<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configDC.txt
</pre>
<?php ExampleOutput('output-dcnets-configDC.txt', 'configDC.txt') ?>

<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configTLS.txt
</pre>
<?php ExampleOutput('output-dcnets-configTLS.txt', 'configTLS.txt') ?>

<?php
PageEnd();
HTMLFooter();
?>
