<?php
require_once('../lib.php');

SetHeaderTitle('leakiEst Malicious JavaScript Example Dataset');
AddBreadcrumb(array('Examples', '/research/projects/infotools/leakiest/examples/index.php'));
AddBreadcrumb(array('Malicious JavaScript', '/research/projects/infotools/leakiest/examples/javascript.php'));

HTMLHeader();
PageStart();

$latest_version = preg_replace('/\.\.\/downloads\/leakiest-(.*)\.tar\.bz2/', '$1', end(glob("../downloads/leakiest-*.tar.bz2")));
?>

<h2>Example: Malicious JavaScript</h2>

<?php DownloadDataset('dataset-javascript.tar.bz2') ?>

<p>This dataset relates a binary value indicating the maliciousness of a particular piece of JavaScript code (the secret) to characteristics that can be inferred by observing or executing the code (the public outputs).</p>

<p>We thank Oliver Freeman for his work on generating this dataset.</p>

<h3>Command lines and outputs</h3>
<p>The configuration file needs to be located in the same directory as leakiest-<?php echo $latest_version ?>.jar.</p>
<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configJavaScript.txt
</pre>
<?php ExampleOutput('output-javascript-configJavaScript.txt', 'configJavaScript.txt') ?>

<?php
PageEnd();
HTMLFooter();
?>
