B1;2c<?php
require_once('../lib.php');

SetHeaderTitle('leakiEst Fingerprinting Encrypted Tor Traffic Example Dataset');
AddBreadcrumb(array('Examples', '/research/projects/infotools/leakiest/examples/index.php'));
AddBreadcrumb(array('Fingerprinting Encrypted Tor Traffic', '/research/projects/infotools/leakiest/examples/tor.php'));

HTMLHeader();
PageStart();

$latest_version = preg_replace('/\.\.\/downloads\/leakiest-(.*)\.tar\.bz2/', '$1', end(glob("../downloads/leakiest-*.tar.bz2")));
?>

<h2>Example: Fingerprinting Encrypted Tor Traffic</h2>

<?php DownloadDataset('dataset-tor.tar.bz2') ?>

<p><a href="https://www.torproject.org">Tor</a> is an anonymity system that uses encryption and onion routing to disguise users' network traffic. Traffic is encrypted before it leaves the user's node, but an intermediary can still infer information about the web sites a user is requesting based on characteristics of the encrypted traffic: the time taken to respond to the request, the number of packets, the packet sizes, the number of &quot;spikes&quot; in the data stream, etc.</p>

<p>Such an attack has previously been mounted against Tor by <a href="http://lorre.uni.lu/~andriy/papers/acmccs-wpes11-fingerprinting.pdf">Panchenko et al.</a>, using Weka to fingerprint encrypted traffic with a 54% success rate; since fingerprinting the web site is possible, clearly a leak exists. We generated a dataset by accessing each of the Alexa top 500 web sites ten times through a Tor node and recording attributes of the encrypted traffic. leakiEst ranks them and identifies which attributes (or sets of attributes) leak information. Its analysis showed that a web site is most easily fingerprinted by the number of spikes in the data stream. It also showed that some attributes do not contain <i>any</i> useful information; we verified this by removing these attributes from the dataset and rerunning the classification in Weka, and observed no drop in the identification rate.</p>

<p>We thank William Neves for his work on generating this dataset.</p>

<h3>Command lines and outputs</h3>
<p>The configuration file needs to be located in the same directory as leakiest-<?php echo $latest_version ?>.jar.</p>
<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configTor.txt
</pre>
<?php ExampleOutput('output-tor-configTor.txt', 'configTor.txt') ?>

<?php
PageEnd();
HTMLFooter();
?>
