B1;2c<?php
require_once('../lib.php');

SetHeaderTitle('leakiEst e-Passport Traceability Example Dataset');
AddBreadcrumb(array('Examples', '/research/projects/infotools/leakiest/examples/index.php'));
AddBreadcrumb(array('e-Passport Traceability', '/research/projects/infotools/leakiest/examples/epassports.php'));

HTMLHeader();
PageStart();

$latest_version = preg_replace('/\.\.\/downloads\/leakiest-(.*)\.tar\.bz2/', '$1', end(glob("../downloads/leakiest-*.tar.bz2")));
?>

<h2>Example: e-Passport Traceability</h2>

<?php DownloadDataset('dataset-epassports.tar.bz2') ?>

<p>The RFID chip in e-passports is designed to be untraceable; i.e., without knowing the secret key for a passport, it should be impossible to distinguish it from another passport across sessions. In <a href="../../publications.php#CG11">[CG11]</a> we observed that e-passports fail to achieve this goal due to a poorly-implemented MAC check: passports take longer to reject replayed messages. This means that a single message can be used to test for the presence of a particular passport.</p>

<p>We collected timing data from an e-passport and analysed it with leakiEst, which clearly detects the presence of an information leak from a dataset containing 100 observations. Attempting to fix the leak, we developed a variant of the e-passport protocol that pads the time delays so that the average response time is equal in all cases. leakiEst still indicated the presence of a small information leak: while the average times are the same, it appears that the actual time measurements come from a different distribution. After modifying the protocol to continue processing a message even when the MAC check fails, and only reject it at the end of the protocol, leakiEst indicates that it is free from leaks.</p>

<h3>Command lines and outputs</h3>
<p>The configuration files need to be located in the same directory as leakiest-<?php echo $latest_version ?>.jar.</p>
<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configPassportBritish.txt
</pre>
<?php ExampleOutput('output-epassports-configPassportBritish.txt', 'configPassportBritish.txt') ?>

<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configPassportBritishFix.txt
</pre>
<?php ExampleOutput('output-epassports-configPassportBritishFix.txt', 'configPassportBritishFix.txt') ?>

<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configPassportGerman.txt
</pre>
<?php ExampleOutput('output-epassports-configPassportGerman.txt', 'configPassportGerman.txt') ?>

<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configPassportGermanFix.txt
</pre>
<?php ExampleOutput('output-epassports-configPassportGermanFix.txt', 'configPassportGermanFix.txt') ?>

<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configPassportIrish.txt
</pre>
<?php ExampleOutput('output-epassports-configPassportIrish.txt', 'configPassportIrish.txt') ?>

<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configPassportIrishFix.txt
</pre>
<?php ExampleOutput('output-epassports-configPassportIrishFix.txt', 'configPassportIrishFix.txt') ?>

<?php
PageEnd();
HTMLFooter();
?>
