B1;2c<?php
require_once('../lib.php');

SetHeaderTitle('leakiEst Pseudorandom Number Generators Example Dataset');
AddBreadcrumb(array('Examples', '/research/projects/infotools/leakiest/examples/index.php'));
AddBreadcrumb(array('Pseudorandom Number Generators', '/research/projects/infotools/leakiest/examples/prng.php'));

HTMLHeader();
PageStart();

$latest_version = preg_replace('/\.\.\/downloads\/leakiest-(.*)\.tar\.bz2/', '$1', end(glob("../downloads/leakiest-*.tar.bz2")));
?>

<h2>Example: Pseudorandom Number Generators</h2>

<?php DownloadDataset('dataset-prng.tar.bz2') ?>

<p>The Java API contains a class, <a href="http://docs.oracle.com/javase/7/docs/api/java/util/Random.html"><tt>java.util.Random</tt></a>, for pseudorandomly generating numbers. This class implements a <a href="https://en.wikipedia.org/wiki/Linear_congruential_generator">linear congruential generator</a>, which does not provide high-quality randomness; there may therefore be a relationship between consecutive integers generated by this class. The Java API also provides another class, <a href="http://docs.oracle.com/javase/7/docs/api/java/security/SecureRandom.html"><tt>java.security.SecureRandom</tt></a>, which instead generates random numbers in a cryptographically strong way.</p>

<p>These datasets are formed using the <tt>RandomLowEny</tt> and <tt>SecRanLowEny</tt> test classes, whose source code is included with the dataset. Each PRNG class is seeded with an integer between 0 and 199 inclusive, and is then ordered to produce two random numbers between 0 and 9 inclusive. leakiEst can then process the dataset and estimate the mutual information between the two randomly-generated numbers. leakiEst reveals that the mutual information for integers generated by <tt>java.util.Random</tt> is 0.5 bits, and for <tt>java.security.SecureRandom</tt> 0 bits (out of a possible 3.3 bits) &mdash; <tt>java.util.Random</tt> therefore contains an information leakage, while <tt>java.security.SecureRandom</tt> does not.</p>


<h3>Command lines and outputs</h3>
<p>The configuration files need to be located in the same directory as leakiest-<?php echo $latest_version ?>.jar.</p>
<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configRandom.txt
</pre>
<?php ExampleOutput('output-prng-configRandom.txt', 'configRandom.txt') ?>

<pre class="terminal">
$ java -jar leakiest-<?php echo $latest_version ?>.jar -cfg configSecureRandom.txt
</pre>
<?php ExampleOutput('output-prng-configSecureRandom.txt', 'configSecureRandom.txt') ?>

<?php
PageEnd();
HTMLFooter();
?>
